/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.vectorgraphics;

import java.awt.Component;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.rug.syntree.hierarchicalmodel.exporters.BatikAbstractExportFileType;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.OptionJRadioButton;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.batik.swing.svg.JSVGComponent;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.fop.render.ps.AbstractPSTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public abstract class BatikAbstractPSExportFileType
extends BatikAbstractExportFileType {
    public static final String FONT_TRIPLET_SEPARATION_CHAR = ",";
    private static final String OPTIONS_ROOT = BatikAbstractPSExportFileType.class.getName();
    public static final String PS_TRANSPARENT_BACKGROUND = BatikAbstractExportFileType.class.getName() + "." + "Transparent";
    public static final String PS_EMBED_FONTS = OPTIONS_ROOT + ".PSEmbedFonts";
    public static final String PS_TEXT_AS_SHAPES = OPTIONS_ROOT + ".PSTextAsShapes";
    protected static final UserProperties defaultProperties = new UserProperties();
    protected AbstractPSTranscoder psTranscoder = null;

    @Override
    public String[] getMIMETypes() {
        return new String[]{"application/postscript"};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void export() throws IOException {
        if (!(this.source instanceof JSVGComponent)) throw new IOException("Source cannot be exported to the " + this.getDescription() + ".\nCannot interprete source format. Source should be a JSVGComponent instance from the Apache Batik library.\nExport cannot continue.");
        JSVGComponent sourceComponent = (JSVGComponent)this.source;
        if (sourceComponent.getSVGDocument() == null) throw new IOException("Source cannot be exported to the " + this.getDescription() + ".\nCannot interprete source format. Source is a JSVGComponent instance from the Apache Batik library, but does not contain a SVGDocument instance.\nExporting cannot continue.");
        this.progressDialog.setProgress(8);
        this.progressDialog.setNote("Setting up font embedding...");
        try {
            DefaultConfiguration config = new DefaultConfiguration("cfg");
            String fontEmbedding = this.properties.getProperty(PS_EMBED_FONTS);
            if (fontEmbedding == null) {
                fontEmbedding = defaultProperties.getProperty(PS_EMBED_FONTS);
            }
            if (Boolean.parseBoolean(fontEmbedding)) {
                this.setupFontEmbedding(config, sourceComponent.getSVGDocument());
            }
            if (this.progressDialog.isCanceled()) return;
            this.psTranscoder.configure(config);
            this.progressDialog.setProgress(this.progressDialog.getProgress() + 16);
            super.export();
            return;
        }
        catch (Exception ce) {
            ce.printStackTrace();
            throw new IOException("A system error occurred while generating the configuration for the embedding or referencing of used fonts.\nExporting is aborted.\nPlease contact the developers of SynTree with this error message and cause.\n" + (ce.getMessage() == null ? "Exception was caught and rethrown:" : ce.getMessage()), ce);
        }
    }

    @Override
    public void endExport() {
        this.psTranscoder = null;
        super.endExport();
    }

    @Override
    public JPanel createOptionPanel(Properties theOptions) {
        UserProperties options = new UserProperties(theOptions, this.getDefaultProperties());
        OptionPanel fontPanel = new OptionPanel(null);
        ButtonGroup radioGroup = new ButtonGroup();
        boolean useFontEmbedding = new Boolean(options.getProperty(PS_EMBED_FONTS, "false"));
        OptionJRadioButton noEmbedRadio = new OptionJRadioButton(PS_EMBED_FONTS, "No, substitute with defaults", !useFontEmbedding);
        noEmbedRadio.setOpaque(false);
        noEmbedRadio.setToolTipText("Fonts are substituted with default PDF font set (e.g. serif, sans or times etc., smallest file size). Default: unchecked.");
        radioGroup.add(noEmbedRadio);
        OptionJRadioButton embedRadio = new OptionJRadioButton(PS_EMBED_FONTS, "Yes, embed them to keep original characters", useFontEmbedding);
        embedRadio.setOpaque(false);
        embedRadio.setToolTipText("<html>Embeds used font types for OS independent viewing (retains text selectability, largest file size). Default: checked.</html>");
        radioGroup.add(embedRadio);
        OptionJRadioButton shapesRadio = new OptionJRadioButton(PS_TEXT_AS_SHAPES, "Yes, convert characters to shapes", (boolean)new Boolean(options.getProperty(PS_TEXT_AS_SHAPES, "false")));
        shapesRadio.setOpaque(false);
        shapesRadio.setToolTipText("<html>Converts all text to geometric shapes (looses selectability, medium file size). Default: unchecked.</html>");
        radioGroup.add(shapesRadio);
        fontPanel.add((Component)new JLabel("Preserve used fonts:"), "0 * [5 5 0 0] w");
        fontPanel.add((Component)noEmbedRadio, "0 1 [0 5 0 0] w");
        fontPanel.add((Component)embedRadio, "0 2 [0 5 0 0] w");
        fontPanel.add((Component)shapesRadio, "0 3 [0 5 5 0] w");
        return fontPanel;
    }

    @Override
    public void setBatikTranscoderHints(Properties freeHEPExportOptions, Map hints) {
        super.setBatikTranscoderHints(freeHEPExportOptions, hints);
        Properties props = this.getDefaultProperties();
        String textAsShapes = freeHEPExportOptions.getProperty(PS_TEXT_AS_SHAPES);
        if (textAsShapes == null) {
            textAsShapes = props.getProperty(PS_TEXT_AS_SHAPES);
        }
        hints.put(PDFTranscoder.KEY_STROKE_TEXT, Boolean.valueOf(textAsShapes));
    }

    @Override
    public Properties getDefaultProperties() {
        UserProperties props = new UserProperties(defaultProperties, super.getDefaultProperties());
        return props;
    }

    @Override
    public void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    @Override
    public void setExportFormatFontEmbedSpecifics(DefaultConfiguration fontConfig) {
        fontConfig.setAttribute("encoding-mode", "single-byte");
    }

    @Override
    protected SVGAbstractTranscoder getBatikTranscoder() {
        return this.getPostScriptTranscoder();
    }

    protected abstract AbstractPSTranscoder getPostScriptTranscoder();

    static {
        defaultProperties.setProperty(PS_TEXT_AS_SHAPES, false);
        defaultProperties.setProperty(PS_EMBED_FONTS, true);
    }
}

