/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.nodecontent;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import nl.rug.syntree.Settings;
import nl.rug.syntree.bracketstructure.BracketView;
import rtf.AdvancedRTFDocument;

public class DocumentContent
extends AdvancedRTFDocument {
    private static final long serialVersionUID = 6450200966751451769L;
    public MutableAttributeSet defaultStyle = this.addStyle("default", null);
    public MutableAttributeSet defaultParaStyle = this.addStyle("defaultPara", null);
    private boolean virgin = true;
    public float cachedWidth = 0.0f;
    public float cachedHeight = 0.0f;

    public DocumentContent() {
        Settings.defaultStyle(this.defaultStyle, null);
        Settings.defaultParaStyle(this.defaultParaStyle, null);
        try {
            this.insertString(0, "", this.defaultStyle);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.setCharacterAttributes(0, this.getLength() + 1, this.defaultStyle, true);
        this.setParagraphAttributes(0, this.getLength() + 1, this.defaultParaStyle, true);
        this.addDocumentListener(new DocumentListener(){

            private void triggered() {
                DocumentContent.this.deflower();
                DocumentContent.this.removeDocumentListener(this);
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
            }
        });
        this.setCharacterAttributes(0, 0, new SimpleAttributeSet(), true);
        this.setParagraphAttributes(0, 0, new SimpleAttributeSet(), true);
    }

    private boolean compareAttributes(DocumentContent dc) {
        for (int i = 0; i < this.getLength(); ++i) {
            Element elm = this.getCharacterElement(i);
            Element elm2 = dc.getCharacterElement(i);
            ArrayList attrNames = Collections.list(elm.getAttributes().getAttributeNames());
            for (Object name : attrNames) {
                if (elm.getAttributes().getAttribute(name).equals(elm2.getAttributes().getAttribute(name))) continue;
                return false;
            }
        }
        return true;
    }

    public void clearContents() {
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean compareDocumentContent(DocumentContent dc) {
        try {
            String oldStr = this.getText(0, this.getLength());
            String newStr = dc.getText(0, dc.getLength());
            return oldStr.equals(newStr) && this.compareAttributes(dc);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void copyContent(DefaultStyledDocument src, int start, int end) {
        this.clearContents();
        try {
            for (int i = start; i < end; ++i) {
                int charLength = 1;
                Element e = src.getCharacterElement(i);
                String text = src.getText(i, charLength);
                this.insertString(this.getLength(), text, e.getAttributes().copyAttributes());
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void copyContent(DefaultStyledDocument document, int start, int end, BracketView bv) {
        try {
            for (int i = start; i < end; ++i) {
                int charLength = 1;
                Element e = document.getCharacterElement(i);
                String text = document.getText(i, charLength).replace('\\', '\n').replace(Settings.BV_HARD_SPACE, " ");
                SimpleAttributeSet mas = new SimpleAttributeSet(e.getAttributes().copyAttributes());
                AttributeSet backup = (AttributeSet)mas.getAttribute("bracket-backup-styles");
                if (backup != null) {
                    System.out.println("DC found backup styles");
                    mas.addAttributes(backup);
                }
                this.insertString(this.getLength(), text, mas);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public DocumentContent createCopy() {
        DocumentContent ret = new DocumentContent();
        ret.copyContent(this, 0, this.getLength());
        return ret;
    }

    public DocumentContent deflower() {
        this.virgin(false);
        return this;
    }

    public void delete() {
    }

    public boolean virgin() {
        return this.virgin;
    }

    public DocumentContent virgin(boolean b) {
        this.virgin = b;
        return this;
    }

    public void layoutParagraphs() {
        Element root = this.getDefaultRootElement();
        for (int i = 0; i < root.getElementCount(); ++i) {
            Element para = root.getElement(i);
            Element firstSpan = para.getElement(0);
            AttributeSet attrs = firstSpan.getAttributes();
            SimpleAttributeSet alignAttribute = new SimpleAttributeSet();
            alignAttribute.addAttribute(StyleConstants.Alignment, attrs.getAttribute(StyleConstants.Alignment));
            this.setParagraphAttributes(para.getStartOffset(), para.getEndOffset() - para.getStartOffset(), alignAttribute, false);
        }
    }

    public void layoutCharacters() {
        Element root = this.getDefaultRootElement();
        for (int i = 0; i < root.getElementCount(); ++i) {
            Element para = root.getElement(i);
            this.setCharacterAttributes(para.getStartOffset(), para.getEndOffset() - para.getStartOffset(), para.getAttributes(), false);
        }
    }
}

