/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.undoableedits;

import javax.swing.undo.AbstractUndoableEdit;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;

public class AddChildEdit
extends AbstractUndoableEdit {
    private HierarchicalModel model;
    private HierarchicalNode parent;
    private HierarchicalNode child1;
    private HierarchicalNode child2 = null;
    private Integer idx = null;
    private Integer idx2 = null;

    public AddChildEdit(HierarchicalModel model, HierarchicalNode parent, HierarchicalNode child) {
        this.model = model;
        this.parent = parent;
        this.child1 = child;
        this.idx = child.getSiblingIndex();
    }

    public AddChildEdit(HierarchicalModel model, HierarchicalNode parent, HierarchicalNode child1, HierarchicalNode child2) {
        this(model, parent, child1);
        this.child2 = child2;
        this.idx2 = child2.getSiblingIndex();
    }

    public AddChildEdit(HierarchicalModel model, HierarchicalNode parent, HierarchicalNode child, int idx) {
        this(model, parent, child);
        this.idx = idx;
    }

    public HierarchicalNode child1() {
        return this.child1;
    }

    public HierarchicalNode child2() {
        return this.child2;
    }

    @Override
    public void redo() {
        super.redo();
        this.model.addChild(this.parent, this.child1, this.idx);
        if (this.child2 != null) {
            this.model.addChild(this.parent, this.child2, this.idx2);
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.model.removeChild(this.child1);
        if (this.child2 != null) {
            this.model.removeChild(this.child2);
        }
    }
}

