/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.undoableedits;

import javax.swing.undo.AbstractUndoableEdit;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.undoableedits.AddChildEdit;

public class AddTreeEdit
extends AbstractUndoableEdit {
    private HierarchicalModel model;
    private HierarchicalNode root;
    private Integer idx = null;
    private AddChildEdit addChildEdit = null;

    public AddTreeEdit(HierarchicalModel model, HierarchicalNode root) {
        this.model = model;
        this.root = root;
        this.idx = root.getSiblingIndex();
    }

    public AddTreeEdit(HierarchicalModel model, HierarchicalNode root, int idx) {
        this(model, root);
        this.idx = idx;
    }

    public AddTreeEdit(HierarchicalModel model, HierarchicalNode root, AddChildEdit edit) {
        this(model, root);
        this.addChildEdit = edit;
        System.out.println("Adding tree with children edit " + edit != null);
    }

    @Override
    public void redo() {
        super.redo();
        if (this.idx == null) {
            this.model.addTree(this.root);
        } else {
            this.model.addTree(this.root, this.idx);
        }
        if (this.addChildEdit != null) {
            System.out.println("Redoing addChildEdit in addTree");
            this.addChildEdit.redo();
        }
    }

    public HierarchicalNode tree() {
        return this.root;
    }

    @Override
    public void undo() {
        super.undo();
        if (this.addChildEdit != null) {
            this.addChildEdit.undo();
        }
        this.model.removeTree(this.root);
    }
}

