/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.undoableedits;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;

public class MoveChildEdit
extends AbstractUndoableEdit {
    private HierarchicalModel model;
    private HierarchicalNode node;
    private int from;
    private int to;

    public MoveChildEdit(HierarchicalModel model, HierarchicalNode child, int from) {
        this.model = model;
        this.node = child;
        this.from = from;
        this.to = child.getSiblingIndex();
    }

    private boolean isEquivalent(MoveChildEdit other) {
        return this.node.equals(other.node());
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        return edit instanceof MoveChildEdit && this.isEquivalent((MoveChildEdit)edit);
    }

    public HierarchicalNode node() {
        return this.node;
    }

    @Override
    public void undo() {
        super.undo();
        this.model.moveChild(this.node, this.from);
    }

    @Override
    public void redo() {
        super.redo();
        this.model.moveChild(this.node, this.to);
    }
}

