/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.undoableedits;

import javax.swing.undo.AbstractUndoableEdit;
import nl.rug.syntree.hierarchicalmodel.HierarchicalBranch;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;

public class PasteTreeEdit
extends AbstractUndoableEdit {
    private HierarchicalNode cTree;
    private HierarchicalNode parent;
    private HierarchicalBranch branch;
    private HierarchicalController hc;
    private int idx;

    public PasteTreeEdit(HierarchicalNode cTree, HierarchicalController hc) {
        this.cTree = cTree;
        this.parent = cTree.getParent();
        this.branch = this.parent.getBranchFor(cTree);
        this.hc = hc;
        this.idx = cTree.getSiblingIndex();
    }

    @Override
    public void undo() {
        super.undo();
        this.hc.setClipboard(this.cTree);
        this.parent.removeBranch(this.branch);
    }

    @Override
    public void redo() {
        super.redo();
        this.parent.addChild(this.cTree, this.branch, this.idx);
        this.hc.clearClipboard();
    }
}

