/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.undoableedits;

import javax.swing.undo.AbstractUndoableEdit;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Tweak;

public class TweakEdit
extends AbstractUndoableEdit {
    private HierarchicalObject obj;
    private Tweak old;
    private Tweak nw;
    private Class<?> type;

    public TweakEdit(HierarchicalObject obj, Tweak old, Class<?> type) {
        this.obj = obj;
        this.old = old;
        Tweak nw = obj.getTweakByType(type);
        this.nw = nw == null ? null : nw.createCopy();
        this.type = type;
    }

    @Override
    public void undo() {
        super.undo();
        if (this.old == null) {
            this.obj.removeTweaksByType(this.type);
        } else {
            this.obj.addTweak(this.old);
        }
    }

    @Override
    public void redo() {
        super.redo();
        if (this.nw == null) {
            this.obj.removeTweaksByType(this.type);
        } else {
            this.obj.addTweak(this.nw);
        }
    }
}

