/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import nl.rug.syntree.Main;
import nl.rug.syntree.Settings;
import nl.rug.syntree.bracketstructure.BracketPane;
import nl.rug.syntree.bracketstructure.BracketView;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.mainview.Editor;
import nl.rug.syntree.mainview.components.FormatActions;
import nl.rug.syntree.mainview.components.NavigatableDialog;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.menus.AnnoEditMenu;
import nl.rug.syntree.mainview.menus.AnnotationMenu;
import nl.rug.syntree.mainview.menus.EditMenu;
import nl.rug.syntree.mainview.menus.FileMenu;
import nl.rug.syntree.mainview.menus.FormatMenu;
import nl.rug.syntree.mainview.menus.ModelMenu;
import nl.rug.syntree.mainview.menus.TreeStyleMenu;
import nl.rug.syntree.mainview.toolbars.AnnotationToolBar;
import nl.rug.syntree.mainview.toolbars.FileToolBar;
import nl.rug.syntree.mainview.toolbars.FormatToolBar;
import nl.rug.syntree.mainview.toolbars.ModelToolBar;
import nl.rug.syntree.treediagram.TreePane;
import nl.rug.syntree.treediagram.TreeView;

public class MainFrame
extends JFrame
implements Observer {
    private static int nWindows = 0;
    private TreeView tv;
    private TreeView tv2 = null;
    private BracketView bv;
    private HierarchicalController control;
    private boolean enableExtraView = false;
    private int treeViewID = 0;
    private Editor currentEditor;
    private FormatToolBar formatToolBar;

    public MainFrame(HierarchicalController control) {
        super("Syntree - 0.8");
        this.control = control;
        this.setMinimumSize(new Dimension(600, 400));
        this.setDefaultCloseOperation(2);
        this.setIconImages(Arrays.asList(UIIcons.addImage("icons/syntree_new.png"), UIIcons.addImage("icons/syntree-new-new.png")));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (Settings.DO_SAVE_NAG) {
                    if (MainFrame.this.control.getModel().isDirty()) {
                        JOptionPane confirmationPane = new JOptionPane("Do you want to save your model?", 3, 1);
                        NavigatableDialog dialog = new NavigatableDialog((Component)MainFrame.this, confirmationPane, "Closing Syntree document");
                        int ret = (Integer)dialog.getResult();
                        if (ret == 1) {
                            MainFrame.this.dispose();
                            Main.closeWindow();
                        } else if (ret == 0) {
                            MainFrame.this.control.fileSave(false);
                        }
                        return;
                    }
                    MainFrame.this.dispose();
                    Main.closeWindow();
                }
            }
        });
        this.control.getModel().addObserver(this);
    }

    private void addBinding(Action act) {
        Object ks = act.getValue("AcceleratorKey");
        if (ks != null) {
            // empty if block
        }
    }

    private void doExtraView() {
        JSplitPane verticalPane = (JSplitPane)this.getContentPane().getComponent(this.treeViewID);
        JPanel contentPane = (JPanel)verticalPane.getTopComponent();
        BorderLayout layout = (BorderLayout)contentPane.getLayout();
        if (this.enableExtraView) {
            JSplitPane horizontalPane = new JSplitPane(1);
            horizontalPane.setResizeWeight(0.5);
            Component tp1 = layout.getLayoutComponent("Center");
            contentPane.remove(tp1);
            this.tv2 = new TreeView(1, this.control, this);
            this.tv2.init();
            horizontalPane.add((Component)new TreePane(this.tv2), "right");
            horizontalPane.add(tp1, "left");
            contentPane.add((Component)horizontalPane, "Center");
            verticalPane.revalidate();
        } else {
            JSplitPane splitPane = (JSplitPane)layout.getLayoutComponent("Center");
            contentPane.remove(splitPane);
            this.tv2.end();
            this.control.removeObserver(this.tv2);
            this.tv2 = null;
            Component tv1 = splitPane.getLeftComponent();
            splitPane.remove(tv1);
            contentPane.add(tv1, "Center");
            splitPane = null;
            verticalPane.revalidate();
        }
        this.tv.getModel().setCentered(true);
    }

    private void initActionBindings() {
        for (Action act : FormatActions.getActions()) {
            this.addBinding(act);
        }
        for (Action act : this.control.getFileActions()) {
            this.addBinding(act);
        }
    }

    private JMenuBar initMenus() {
        JMenuBar ret = new JMenuBar();
        ret.add(new FileMenu(this.control));
        ret.add(new EditMenu(this.control));
        ret.add(new FormatMenu(this.control));
        ret.add(new ModelMenu(this.control));
        ret.add(new TreeStyleMenu(this.control, this.tv));
        ret.add(new AnnotationMenu(this.control, this.tv));
        ret.add(new AnnoEditMenu(this.control, this.tv));
        return ret;
    }

    private JPanel initToolbars() {
        JPanel toolbarPane = new JPanel(new BorderLayout());
        FileToolBar ftb = new FileToolBar(this.control);
        ftb.setFloatable(false);
        ModelToolBar mtb = new ModelToolBar(this.control, this.tv.getControl());
        mtb.setFloatable(false);
        toolbarPane.add((Component)ftb, "West");
        toolbarPane.add((Component)mtb, "Center");
        this.formatToolBar = new FormatToolBar(this.control);
        this.formatToolBar.setFloatable(false);
        toolbarPane.add((Component)this.formatToolBar, "South");
        return toolbarPane;
    }

    public boolean hasExtraView() {
        return this.enableExtraView;
    }

    public MainFrame toggleExtraView() {
        this.enableExtraView = !this.enableExtraView;
        this.doExtraView();
        return this;
    }

    public Editor getCurrentEditor() {
        return this.currentEditor;
    }

    public TreeView getTV() {
        return this.tv;
    }

    public void init(TreeView tv, BracketView bv) {
        this.tv = tv;
        this.bv = bv;
        this.initFrame();
    }

    private void initFrame() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.initToolbars(), "North");
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int width = gd.getDisplayMode().getWidth();
        int height = gd.getDisplayMode().getHeight();
        Dimension windowDim = new Dimension(width / 5 * 4, height / 5 * 4);
        this.getContentPane().setMinimumSize(windowDim);
        this.getContentPane().setPreferredSize(windowDim);
        JSplitPane contentPane = new JSplitPane(0);
        contentPane.setResizeWeight(0.75);
        JPanel topPanel = new JPanel(new BorderLayout());
        AnnotationToolBar atb = new AnnotationToolBar(this.tv.getControl());
        topPanel.add((Component)atb, "West");
        topPanel.add((Component)new TreePane(this.tv), "Center");
        contentPane.add((Component)topPanel, "top");
        if (this.bv != null) {
            contentPane.add((Component)new BracketPane(this.bv), "bottom");
        }
        this.treeViewID = this.getContentPane().getComponentCount();
        this.getContentPane().add(contentPane, "Center", -1);
        this.initActionBindings();
        this.setJMenuBar(this.initMenus());
        this.pack();
    }

    public void setCurrentEditor(Editor newEditor) {
        this.setCurrentEditor(newEditor, this.formatToolBar);
    }

    public void setCurrentEditor(Editor newEditor, FormatToolBar toolBar) {
        this.currentEditor = newEditor;
    }

    @Override
    public void update(Observable o, Object arg) {
        File file = this.control.getModel().file();
        String name = "<untitled>";
        boolean dirty = this.control.getModel().isDirty();
        if (file != null) {
            name = file.getName();
        }
        this.setTitle((dirty ? "*" : "") + name + " - Syntree " + "0.8");
    }
}

