/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import nl.rug.syntree.Settings;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.mainview.components.BracketPreferences;
import nl.rug.syntree.mainview.components.FormatActions;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.components.UITreeVisPane;

public class PreferencesWindow
extends JFrame {
    private HierarchicalController control;
    private JTabbedPane tabs;
    private JPanel textStylePane;

    public PreferencesWindow(HierarchicalController control) {
        super("Syntree - Preferences");
        this.setIconImage(UIIcons.addImage("icons/preferences.png"));
        this.control = control;
        JPanel cp = new JPanel();
        cp.setLayout(new BorderLayout());
        this.tabs = new JTabbedPane();
        cp.add((Component)this.tabs, "Center");
        JPanel btns = new JPanel();
        JButton btnRestore = new JButton("Restore defaults");
        btnRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Settings.purge();
                PreferencesWindow.this.dispose();
                PreferencesWindow.this.control.update(null);
                PreferencesWindow.this.control.showSettings();
            }
        });
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PreferencesWindow.this.setVisible(false);
                PreferencesWindow.this.dispose();
            }
        });
        btns.add(btnRestore);
        btns.add(btnClose);
        cp.add((Component)btns, "South");
        this.setContentPane(cp);
        this.tabs.addTab("Tree view", null, new UITreeVisPane(this.control));
        this.tabs.addTab("Bracket view", null, new BracketPreferences(this.control));
        this.setSize(950, 600);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                Settings.save();
            }
        });
        for (Action act : FormatActions.getActions()) {
            Object ks = act.getValue("AcceleratorKey");
            if (ks == null) continue;
            this.getRootPane().getActionMap().put(act.getValue("Name"), act);
            this.getRootPane().getInputMap(2).put((KeyStroke)ks, act.getValue("Name"));
        }
        this.setVisible(true);
    }

    private JComponent makeHotkeyPanel() {
        JPanel pane = new JPanel();
        final JTextField tf = new JTextField(20);
        tf.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                tf.setText(KeyStroke.getKeyStrokeForEvent(arg0).toString());
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        pane.add(tf);
        return pane;
    }
}

