/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JDialog;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.mainview.components.UIMessagePane;

public class UIUtilities {
    public static final long DEFAULT_MOUSE_DOUBLE_CLICK_THRESHOLD = 500L;

    public static long getMouseDoubleClickThreshold() {
        long threshold = 0L;
        if (Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval") != null) {
            try {
                threshold = Integer.parseInt(Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval").toString());
            }
            catch (NumberFormatException nfe) {
                System.err.println("An exception occurred while parsing the awt.multiClickInterval setting");
                nfe.printStackTrace();
            }
        }
        if (threshold < 250L) {
            threshold = 500L;
        }
        return threshold;
    }

    public static void handleException(Throwable e, Component parentComponent, HierarchicalModel model) {
        UIMessagePane errorPane = new UIMessagePane(e, model);
        JDialog errorDialog = errorPane.createDialog(parentComponent);
        if (e.getMessage() != null && e.getMessage().indexOf(":") > -1) {
            errorDialog.setTitle(e.getMessage().substring(0, e.getMessage().indexOf(":")));
        } else {
            errorDialog.setTitle("Error");
        }
        if (UIMessagePane.lastThrownException == null || !UIMessagePane.lastThrownException.getMessage().equals(e.getMessage())) {
            UIMessagePane.lastThrownException = e;
            errorDialog.pack();
            errorDialog.setModal(true);
            errorDialog.setVisible(true);
        }
        e.printStackTrace();
    }

    public static boolean isSystemClipboardEmpty() {
        boolean isEmpty = false;
        Transferable clipBoardContents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            Object data;
            isEmpty = clipBoardContents.getTransferDataFlavors().length > 0 ? (data = clipBoardContents.getTransferData(DataFlavor.stringFlavor)) == null : true;
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isEmpty;
    }

    public static Color parseColour(String theColour) {
        Color color = null;
        if (theColour != null && !theColour.equals("null")) {
            String[] r = theColour.split(", ");
            color = new Color(Integer.parseInt(r[0]), Integer.parseInt(r[1]), Integer.parseInt(r[2]), Integer.parseInt(r[3]));
        }
        return color;
    }
}

