/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import nl.rug.syntree.Settings;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.components.UIToolbarButton;

public abstract class ViewPane
extends JPanel {
    private JComponent view;
    private JPanel aboveBar;
    private JButton btnZoomOut;
    private JButton btnZoomIn;
    private JButton btnZoomStd;
    private JLabel image;
    private JLabel message;
    protected JPanel viewButtonBar;
    protected JPanel zoomButtonBar;
    protected JPanel textPanel;
    protected JPanel viewTitle;
    public static final int MESSAGE_INFO = 0;
    public static final int MESSAGE_WARNING = 1;

    public ViewPane(JComponent view, String title) {
        this.view = view;
        if (view == null) {
            return;
        }
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setBackground(Color.WHITE);
        this.zoomButtonBar = new JPanel(new FlowLayout(3, 0, 0));
        this.aboveBar = new JPanel(new BorderLayout());
        this.aboveBar.setBackground(Color.WHITE);
        this.aboveBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray));
        this.btnZoomOut = new UIToolbarButton(UIIcons.addImageIcon("icons/zoom_out.png"));
        this.btnZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewPane.this.zoomOut();
            }
        });
        this.btnZoomIn = new UIToolbarButton(UIIcons.addImageIcon("icons/zoom_in.png"));
        this.btnZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewPane.this.zoomIn();
            }
        });
        this.btnZoomStd = new UIToolbarButton(UIIcons.addImageIcon("icons/zoom_original.png"));
        this.btnZoomStd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewPane.this.zoomRestore();
            }
        });
        Slope slopeLeft = new Slope(true, Color.white);
        Slope slopeRight = new Slope(false, Color.white);
        this.zoomButtonBar.add(this.btnZoomIn);
        this.zoomButtonBar.add(this.btnZoomStd);
        this.zoomButtonBar.add(this.btnZoomOut);
        this.zoomButtonBar.add(new JSeparator(1));
        this.aboveBar.add((Component)this.zoomButtonBar, "West");
        this.viewTitle = new JPanel(new BorderLayout());
        this.viewTitle.setBackground(Color.white);
        this.viewTitle.add((Component)slopeRight, "West");
        this.textPanel = new JPanel(new FlowLayout(0));
        this.textPanel.add(new JLabel(title));
        this.textPanel.setBackground(Color.WHITE);
        this.image = new JLabel();
        this.message = new JLabel("");
        this.textPanel.add(this.image);
        this.textPanel.add(this.message);
        this.viewTitle.add((Component)this.textPanel, "Center");
        this.viewTitle.add((Component)slopeLeft, "East");
        this.aboveBar.add((Component)this.viewTitle, "Center");
        this.viewButtonBar = new JPanel(new FlowLayout(3, 0, 0));
        this.aboveBar.add((Component)this.viewButtonBar, "East");
        this.add((Component)this.aboveBar, "North");
        this.add((Component)this.view, "Center");
    }

    protected void addButton(Component btn) {
        this.viewButtonBar.add(btn);
    }

    protected void addZoomButton(Component btn) {
        this.zoomButtonBar.add(btn);
    }

    protected void addMenu(JMenu menu) {
        menu.setBorder(UIToolbarButton.BTNBORDER);
        menu.setBackground(Settings.UI_BTN_BG);
        JMenuBar mb = new JMenuBar();
        mb.setBorder(BorderFactory.createEmptyBorder());
        mb.setBackground(Settings.UI_BTN_BG);
        mb.add(menu);
        this.viewButtonBar.add(mb);
    }

    public void displayMessage(String message, int severity) {
        if (this.message != null && message != null) {
            this.image.setIcon(UIIcons.addImageIcon(severity == 1 ? "icons/icon-warning.png" : "icons/icon-info.png"));
            this.message.setText(message);
        }
    }

    public void removeMessage() {
        this.image.setIcon(null);
        this.message.setText("");
    }

    public abstract void zoomIn();

    public abstract void zoomOut();

    public abstract void zoomRestore();

    private class Slope
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int height;
        private int width;
        private boolean left;
        private Color colour;
        private boolean inheritHeight = true;

        public Slope(boolean left, Color colour) {
            this.left = left;
            this.colour = colour;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.inheritHeight) {
                this.width = this.height = this.getParent().getSize().height;
            }
            this.setPreferredSize(new Dimension(this.width, this.height));
            this.setSize(new Dimension(this.width, this.height));
            if (this.left) {
                int[] xg = new int[]{0, 0, this.width};
                int[] yg = new int[]{0, this.height, 0};
                Polygon p = new Polygon(xg, yg, 3);
                g.setColor(this.colour);
                g.fillPolygon(p);
            } else {
                int[] xg = new int[]{0, this.width, this.width};
                int[] yg = new int[]{0, this.height, 0};
                Polygon p = new Polygon(xg, yg, 3);
                g.setColor(this.colour);
                g.fillPolygon(p);
            }
        }
    }
}

