/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.Color;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import nl.rug.syntree.mainview.components.ActionGroup;
import nl.rug.syntree.mainview.components.UIToggleToolbarButton;
import nl.rug.syntree.mainview.components.UIToolbarButton;
import nl.rug.syntree.treediagram.TreeControl;

public class ActionSupport {
    public static final String TOGGLABLE = "ActionSupport-togglable";
    public static final String CHOOSABLE = "ActionSupport-choosable";

    public static JMenuItem makeMenuItem(Action act) {
        if (act.getValue(TOGGLABLE) != null) {
            return new JCheckBoxMenuItem(act);
        }
        if (act.getValue(CHOOSABLE) != null) {
            JRadioButtonMenuItem ret = new JRadioButtonMenuItem(act);
            return ret;
        }
        return new JMenuItem(act);
    }

    public static JMenuItem makeMenuItem(ActionGroup actg) {
        if (actg.act != null) {
            return ActionSupport.makeMenuItem(actg.act);
        }
        if (actg.subs != null) {
            JMenu ret = new JMenu(actg.title);
            for (ActionGroup ag : actg) {
                JMenuItem menuItem = ActionSupport.makeMenuItem(ag);
                if (ag.act instanceof TreeControl.HideAction && !((Boolean)ag.act.getValue("SwingSelectedKey")).booleanValue()) {
                    menuItem.setForeground(Color.red);
                    ret.insert(menuItem, 0);
                    continue;
                }
                menuItem.setSelected(false);
                ret.add(menuItem);
            }
            return ret;
        }
        throw new Error("ActionGroup malformed: act = " + actg.act + ", title = " + actg.title + ", subs = " + actg.subs);
    }

    public static AbstractButton makeButton(Action act) {
        if (act.getValue(TOGGLABLE) != null) {
            return new UIToggleToolbarButton(act);
        }
        return new UIToolbarButton(act);
    }
}

