/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import nl.rug.syntree.bracketstructure.BracketView;
import nl.rug.syntree.mainview.components.ActionSupport;
import nl.rug.syntree.mainview.components.UIIcons;

public class BracketMenu
extends JMenu {
    private BracketView bv;

    public BracketMenu(BracketView bv) {
        this.bv = bv;
        this.add(ActionSupport.makeMenuItem(new BracketAction("Brackets", "[", "]", "icons/brackets-brackets.png")));
        this.add(ActionSupport.makeMenuItem(new BracketAction("Braces", "{", "}", "icons/brackets-braces.png")));
        this.add(ActionSupport.makeMenuItem(new BracketAction("Parentheses", "(", ")", "icons/brackets-parens.png")));
        this.add(ActionSupport.makeMenuItem(new BracketAction("Angles", "<", ">", "icons/brackets-angled.png")));
    }

    private class BracketAction
    extends AbstractAction
    implements Observer {
        private String open;
        private String close;
        private String icon;

        public BracketAction(String title, String open, String close, String icon) {
            this.putValue("Name", title + ": " + open + ", " + close);
            this.putValue("ActionSupport-choosable", true);
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon(icon));
            this.open = open;
            this.close = close;
            this.icon = icon;
            BracketMenu.this.bv.getModel().addObserver(this);
            this.update(null, null);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            BracketMenu.this.bv.changeBracket((Serializable)((Object)this.open), (Serializable)((Object)this.close));
        }

        @Override
        public void update(Observable obs, Object arg) {
            boolean sel = BracketMenu.this.bv.getSetting("bv-bracket-type-open").equals(this.open);
            System.out.println("BM " + this.open + this.close + ": " + sel);
            if (sel) {
                BracketMenu.this.setIcon(UIIcons.addImageIcon(this.icon));
            }
            this.putValue("SwingSelectedKey", sel);
        }
    }
}

