/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import nl.rug.syntree.Settings;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.components.UIJToggleButtonWithIcon;

public class BracketPreferences
extends JPanel {
    private HierarchicalController hc;
    private UIJToggleButtonWithIcon radBrackets;
    private UIJToggleButtonWithIcon radBraces;
    private UIJToggleButtonWithIcon radParens;
    private UIJToggleButtonWithIcon radAngles;
    private ButtonGroup grpBrackets;
    private UIJToggleButtonWithIcon chkBold;
    private UIJToggleButtonWithIcon chkItalic;
    private UIJToggleButtonWithIcon radBaseline;
    private UIJToggleButtonWithIcon radSuper;
    private UIJToggleButtonWithIcon radSub;
    private ButtonGroup grpParentShift;
    private JEditorPane edtParent;
    private MutableAttributeSet parentStyle;
    private AbstractButton chkBranchClr;
    private AbstractButton chkNodeClr;

    private void setBrackets(String open, String close) {
        Settings.set("bv-bracket-type-open", (Serializable)((Object)open));
        Settings.set("bv-bracket-type-close", (Serializable)((Object)close));
        this.hc.update(null);
    }

    private UIJToggleButtonWithIcon mkBrktButton(String icon, String open, String close, ActionListener al) {
        UIJToggleButtonWithIcon ret = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon(icon));
        ret.addActionListener(al);
        ret.button.putClientProperty("open", open);
        ret.button.putClientProperty("close", close);
        return ret;
    }

    private void styleParent() {
        StyledDocument doc = (StyledDocument)this.edtParent.getDocument();
        doc.setCharacterAttributes(1, doc.getLength(), this.parentStyle, true);
        this.hc.update(null);
    }

    public BracketPreferences(HierarchicalController hc) {
        this.setLayout(new BoxLayout(this, 1));
        this.hc = hc;
        this.grpBrackets = new ButtonGroup();
        ActionListener alBrackets = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JRadioButton btn = (JRadioButton)ae.getSource();
                if (!btn.isSelected()) {
                    return;
                }
                String open = (String)btn.getClientProperty("open");
                String close = (String)btn.getClientProperty("close");
                BracketPreferences.this.setBrackets(open, close);
            }
        };
        this.radBrackets = this.mkBrktButton("icons/brackets-brackets.png", "[", "]", alBrackets);
        this.radBraces = this.mkBrktButton("icons/brackets-braces.png", "{", "}", alBrackets);
        this.radParens = this.mkBrktButton("icons/brackets-parens.png", "(", ")", alBrackets);
        this.radAngles = this.mkBrktButton("icons/brackets-angled.png", "<", ">", alBrackets);
        this.grpBrackets.add(this.radBrackets.button);
        this.grpBrackets.add(this.radBraces.button);
        this.grpBrackets.add(this.radParens.button);
        this.grpBrackets.add(this.radAngles.button);
        JPanel panBrackets = new JPanel();
        panBrackets.setLayout(new BoxLayout(panBrackets, 0));
        panBrackets.add(this.radBrackets);
        panBrackets.add(this.radBraces);
        panBrackets.add(this.radParens);
        panBrackets.add(this.radAngles);
        this.add(panBrackets);
        this.edtParent = new JEditorPane();
        this.edtParent.setEditorKit(new StyledEditorKit());
        this.edtParent.setDocument(new DefaultStyledDocument());
        this.parentStyle = new SimpleAttributeSet();
        Settings.defaultStyle(this.parentStyle, null);
        try {
            this.edtParent.getDocument().insertString(0, "[", this.parentStyle);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        boolean isSuper = (Boolean)Settings.get("bv-parent-super");
        boolean isSub = (Boolean)Settings.get("bv-parent-sub");
        boolean isBold = (Boolean)Settings.get("bv-parent-bold");
        boolean isItalic = (Boolean)Settings.get("bv-parent-italic");
        this.parentStyle.addAttribute(StyleConstants.Bold, isBold);
        this.parentStyle.addAttribute(StyleConstants.Italic, isItalic);
        this.parentStyle.addAttribute(StyleConstants.Subscript, isSub);
        this.parentStyle.addAttribute(StyleConstants.Superscript, isSuper);
        try {
            this.edtParent.getDocument().insertString(1, "parent", this.parentStyle);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.radBaseline = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/style_normalscript.png"));
        this.radBaseline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!BracketPreferences.this.radBaseline.isSelected()) {
                    return;
                }
                BracketPreferences.this.parentStyle.addAttribute(StyleConstants.Superscript, false);
                Settings.set("bv-parent-super", Boolean.valueOf(false));
                BracketPreferences.this.parentStyle.addAttribute(StyleConstants.Subscript, false);
                Settings.set("bv-parent-sub", Boolean.valueOf(false));
                BracketPreferences.this.styleParent();
            }
        });
        this.radBaseline.button.setSelected(!isSub && !isSuper);
        this.radSuper = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/lc_superscript.png"));
        this.radSuper.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!BracketPreferences.this.radSuper.isSelected()) {
                    return;
                }
                BracketPreferences.this.parentStyle.addAttribute(StyleConstants.Subscript, false);
                Settings.set("bv-parent-sub", Boolean.valueOf(false));
                BracketPreferences.this.parentStyle.addAttribute(StyleConstants.Superscript, true);
                Settings.set("bv-parent-super", Boolean.valueOf(true));
                BracketPreferences.this.styleParent();
            }
        });
        this.radSuper.setSelected(isSuper);
        this.radSub = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/lc_subscript.png"));
        this.radSub.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!BracketPreferences.this.radSub.isSelected()) {
                    return;
                }
                BracketPreferences.this.parentStyle.addAttribute(StyleConstants.Superscript, false);
                Settings.set("bv-parent-super", Boolean.valueOf(false));
                BracketPreferences.this.parentStyle.addAttribute(StyleConstants.Subscript, true);
                Settings.set("bv-parent-sub", Boolean.valueOf(true));
                BracketPreferences.this.styleParent();
            }
        });
        this.radSub.setSelected(isSub);
        this.chkBold = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/lc_bold.png"));
        this.chkBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BracketPreferences.this.parentStyle.addAttribute(StyleConstants.Bold, BracketPreferences.this.chkBold.isSelected());
                Settings.set("bv-parent-bold", Boolean.valueOf(BracketPreferences.this.chkBold.isSelected()));
                BracketPreferences.this.styleParent();
            }
        });
        this.chkBold.setSelected(isBold);
        this.chkItalic = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/lc_italic.png"));
        this.chkItalic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BracketPreferences.this.parentStyle.addAttribute(StyleConstants.Italic, BracketPreferences.this.chkItalic.isSelected());
                Settings.set("bv-parent-italic", Boolean.valueOf(BracketPreferences.this.chkItalic.isSelected()));
                BracketPreferences.this.styleParent();
            }
        });
        this.chkItalic.setSelected(isItalic);
        this.grpParentShift = new ButtonGroup();
        this.grpParentShift.add(this.radBaseline.button);
        this.grpParentShift.add(this.radSub.button);
        this.grpParentShift.add(this.radSuper.button);
        JPanel panParentStyle = new JPanel();
        panParentStyle.setLayout(new BoxLayout(panParentStyle, 0));
        panParentStyle.add(this.radBaseline);
        panParentStyle.add(this.radSub);
        panParentStyle.add(this.radSuper);
        panParentStyle.add(this.chkBold);
        panParentStyle.add(this.chkItalic);
        this.add(panParentStyle);
        this.add(this.edtParent);
        this.chkBranchClr = new JCheckBox("Inherit branch colour");
        this.chkBranchClr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Settings.set("bv-show-branches-background-colour-enabled", Boolean.valueOf(BracketPreferences.this.chkBranchClr.isSelected()));
                BracketPreferences.this.hc.update(null);
            }
        });
        this.chkBranchClr.setSelected((Boolean)Settings.get("bv-show-branches-background-colour-enabled"));
        this.chkNodeClr = new JCheckBox("Inherit node colour");
        this.chkNodeClr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Settings.set("bv-show-node-background-colour-enabled", Boolean.valueOf(BracketPreferences.this.chkNodeClr.isSelected()));
                BracketPreferences.this.hc.update(null);
            }
        });
        this.chkNodeClr.setSelected((Boolean)Settings.get("bv-show-node-background-colour-enabled"));
        JPanel panOthers = new JPanel();
        panOthers.setLayout(new BoxLayout(panOthers, 0));
        panOthers.add(this.chkBranchClr);
        panOthers.add(this.chkNodeClr);
        this.add(panOthers);
    }
}

