/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import nl.rug.syntree.Settings;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.components.UISymbolChooser;
import nl.rug.syntree.treediagram.texteditor.SVGEditorKit;
import nl.rug.syntree.treediagram.texteditor.SVGEditorPane;

public class FormatActions {
    private static Map<Class<? extends Action>, Action> actions = null;
    private static Vector<StyleObserver> styleListeners = null;
    private static Vector<StyleObserver> alignmentActions = null;
    private static Map<String, Action> faceActions = null;
    private static Map<Integer, Action> sizeActions = null;
    public static JTextComponent currentEditor = null;
    private static JTextComponent lastEditor = null;
    private static UISymbolChooser symDiag = null;
    private static JColorChooser colourChs = null;

    private static Action actionFactory(Class<? extends Action> cls) {
        return actions.get(cls);
    }

    private static AttributeSet attributeUnion(AttributeSet a, AttributeSet b) {
        SimpleAttributeSet ret = new SimpleAttributeSet();
        Enumeration<?> en = a.getAttributeNames();
        while (en.hasMoreElements()) {
            Object val;
            Object key = en.nextElement();
            if (!b.containsAttribute(key, val = a.getAttribute(key))) continue;
            ret.addAttribute(key, val);
        }
        return ret.copyAttributes();
    }

    private static boolean isEditorActive() {
        return currentEditor != null && currentEditor.isEnabled();
    }

    public static void init() {
        actions = new HashMap<Class<? extends Action>, Action>();
        actions.put(FontColourAction.class, new FontColourAction());
        actions.put(BackgroundColourAction.class, new BackgroundColourAction());
        actions.put(BoldAction.class, new BoldAction());
        actions.put(ItalicAction.class, new ItalicAction());
        actions.put(UnderlineAction.class, new UnderlineAction());
        actions.put(StrikeThroughAction.class, new StrikeThroughAction());
        actions.put(InsertSymbolAction.class, new InsertSymbolAction());
        actions.put(AlignLeftAction.class, new AlignLeftAction());
        actions.put(AlignCenterAction.class, new AlignCenterAction());
        actions.put(AlignRightAction.class, new AlignRightAction());
        actions.put(SmallCapsAction.class, new SmallCapsAction());
        actions.put(SubscriptAction.class, new SubscriptAction());
        actions.put(SuperscriptAction.class, new SuperscriptAction());
        FormatActions.initFaceActions();
        FormatActions.initSizeActions();
        styleListeners = new Vector();
        for (Action act : actions.values()) {
            if (!(act instanceof StyleObserver)) continue;
            styleListeners.add((StyleObserver)act);
        }
        symDiag = new UISymbolChooser("Insert symbol", (String)Settings.get("font-face"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (lastEditor != null) {
                    lastEditor.replaceSelection(symDiag.getSymbol());
                }
            }
        });
        colourChs = new JColorChooser();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new PropertyChangeListener(){
            private JTextComponent curComp = null;
            private CaretListener caretListen = new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    JTextComponent comp;
                    int start = e.getDot();
                    int end = e.getMark();
                    if (start == 0) {
                        start = 1;
                    }
                    if (end == 0) {
                        end = 1;
                    }
                    if (end < start) {
                        int h = end;
                        end = start;
                        start = h;
                    }
                    if (!((comp = (JTextComponent)e.getSource()).getDocument() instanceof StyledDocument)) {
                        return;
                    }
                    StyledDocument doc = (StyledDocument)comp.getDocument();
                    System.out.println("Docaret from formatactions");
                    this.doCaret(start, end, doc);
                }
            };
            private boolean isCaretListening = false;

            private void doCaret(int start, int end, StyledDocument doc) {
                AttributeSet all = doc.getCharacterElement(start - 1).getAttributes().copyAttributes();
                for (int i = start + 1; i < end; ++i) {
                    AttributeSet as = doc.getCharacterElement(i - 1).getAttributes().copyAttributes();
                    all = FormatActions.attributeUnion(all, as);
                }
                FormatActions.notifyStyleListeners(all);
            }

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                currentEditor = null;
                if (!(arg0.getNewValue() instanceof JComponent)) {
                    return;
                }
                JComponent focusOwner = (JComponent)arg0.getNewValue();
                if (!(focusOwner instanceof JTextComponent)) {
                    return;
                }
                if (!(((JTextComponent)focusOwner).getDocument() instanceof StyledDocument)) {
                    return;
                }
                if (this.isCaretListening) {
                    this.curComp.removeCaretListener(this.caretListen);
                    this.isCaretListening = false;
                }
                currentEditor = this.curComp = (JTextComponent)focusOwner;
                lastEditor = this.curComp;
                this.curComp.addCaretListener(this.caretListen);
                this.isCaretListening = true;
                this.doCaret(0, 0, (StyledDocument)this.curComp.getDocument());
            }
        });
    }

    public static void notifyStyleListeners(AttributeSet as) {
        for (Observer observer : styleListeners) {
            observer.update(null, as);
        }
    }

    private static void initFaceActions() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object[] fontNames = ge.getAvailableFontFamilyNames();
        Arrays.sort(fontNames);
        faceActions = new HashMap<String, Action>();
        faceActions.put("Serif", new FontFaceAction("Serif"));
        faceActions.put("SansSerif", new FontFaceAction("SansSerif"));
        faceActions.put("Monospaced", new FontFaceAction("Monospaced"));
        for (String string : Arrays.asList(fontNames)) {
            faceActions.put(string, new FontFaceAction(string));
        }
    }

    private static void initSizeActions() {
        sizeActions = new HashMap<Integer, Action>();
        for (int i = 8; i < 72; i += 2) {
            sizeActions.put(i, new FontSizeAction(i));
        }
    }

    public static void addStyleListener(StyleObserver obs) {
        if (styleListeners == null) {
            styleListeners = new Vector();
        }
        if (styleListeners.contains(obs)) {
            return;
        }
        styleListeners.add(obs);
    }

    public static Collection<Action> getActions() {
        return actions.values();
    }

    public static Action getAlignCenterAction() {
        return FormatActions.actionFactory(AlignCenterAction.class);
    }

    public static Action getAlignLeftAction() {
        return FormatActions.actionFactory(AlignLeftAction.class);
    }

    public static Action getAlignRightAction() {
        return FormatActions.actionFactory(AlignRightAction.class);
    }

    public static Action getBackgroundColourAction() {
        return FormatActions.actionFactory(BackgroundColourAction.class);
    }

    public static Action getBoldAction() {
        return FormatActions.actionFactory(BoldAction.class);
    }

    public static Color getColour() {
        JDialog diag = JColorChooser.createDialog(null, "Select colour", true, colourChs, null, null);
        diag.setVisible(true);
        return colourChs.getColor();
    }

    public static Action getFontColourAction() {
        return FormatActions.actionFactory(FontColourAction.class);
    }

    public static Action getFontFaceAction(String face) {
        return faceActions.get(face);
    }

    public static List<String> getFontFaces() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(faceActions.keySet());
        Collections.sort(ret);
        return ret;
    }

    public static Action getFontSizeAction(int i) {
        return sizeActions.get(i);
    }

    public static List<Integer> getFontSizes() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ret.addAll(sizeActions.keySet());
        Collections.sort(ret);
        return ret;
    }

    public static Action getInsertSymbolAction() {
        return FormatActions.actionFactory(InsertSymbolAction.class);
    }

    public static Action getItalicAction() {
        return FormatActions.actionFactory(ItalicAction.class);
    }

    public static Action getSmallCapsAction() {
        return FormatActions.actionFactory(SmallCapsAction.class);
    }

    public static Action getStrikethroughAction() {
        return FormatActions.actionFactory(StrikeThroughAction.class);
    }

    public static Action getSubscriptAction() {
        return FormatActions.actionFactory(SubscriptAction.class);
    }

    public static Action getSuperscriptAction() {
        return FormatActions.actionFactory(SuperscriptAction.class);
    }

    public static Action getUnderlineAction() {
        return FormatActions.actionFactory(UnderlineAction.class);
    }

    public static interface StyleObserver
    extends Observer,
    Action {
    }

    public static class FontFaceAction
    extends StyledEditorKit.FontFamilyAction
    implements StyleObserver {
        public FontFaceAction(String face) {
            super(face, face);
            this.setEnabled(false);
        }

        @Override
        public void update(Observable obs, Object arg) {
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class UnderlineAction
    extends StyledEditorKit.UnderlineAction
    implements StyleObserver {
        public UnderlineAction() {
            this.putValue("Name", "Underline");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control U"));
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/lc_underline.png"));
            this.putValue("ShortDescription", "Underline");
            this.setEnabled(false);
        }

        @Override
        public void update(Observable obs, Object arg) {
            AttributeSet as = (AttributeSet)arg;
            this.putValue("SwingSelectedKey", StyleConstants.isUnderline(as));
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class SuperscriptAction
    extends SVGEditorKit.SuperscriptAction
    implements StyleObserver {
        public SuperscriptAction() {
            this.putValue("Name", "Superscript");
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/lc_superscript.png"));
            this.putValue("ShortDescription", "Superscript");
            this.setEnabled(false);
        }

        @Override
        public void update(Observable obs, Object arg) {
            AttributeSet as = (AttributeSet)arg;
            this.putValue("SwingSelectedKey", StyleConstants.isSuperscript(as));
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class SubscriptAction
    extends SVGEditorKit.SubscriptAction
    implements StyleObserver {
        public SubscriptAction() {
            this.putValue("Name", "Subscript");
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/lc_subscript.png"));
            this.putValue("ShortDescription", "Subscript");
            this.setEnabled(false);
        }

        @Override
        public void update(Observable obs, Object arg) {
            AttributeSet as = (AttributeSet)arg;
            this.putValue("SwingSelectedKey", StyleConstants.isSubscript(as));
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class StrikeThroughAction
    extends SVGEditorKit.StrikethroughAction
    implements StyleObserver {
        public StrikeThroughAction() {
            this.putValue("Name", "Strike-through");
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/lc_strikeout.png"));
            this.putValue("ShortDescription", "Strike-through");
            this.setEnabled(false);
        }

        @Override
        public void update(Observable obs, Object arg) {
            AttributeSet as = (AttributeSet)arg;
            this.putValue("SwingSelectedKey", StyleConstants.isStrikeThrough(as));
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class SmallCapsAction
    extends SVGEditorKit.SmallCapsAction
    implements StyleObserver {
        public SmallCapsAction() {
            this.putValue("Name", "Small-caps");
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/lc_charfontname.png"));
            this.putValue("ShortDescription", "Transform selected text to small-caps");
            this.setEnabled(false);
        }

        @Override
        public void update(Observable obs, Object arg) {
            AttributeSet as = (AttributeSet)arg;
            this.putValue("SwingSelectedKey", as.isDefined("SmallCaps"));
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class ItalicAction
    extends StyledEditorKit.ItalicAction
    implements StyleObserver {
        public ItalicAction() {
            this.putValue("Name", "Italic");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control I"));
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/lc_italic.png"));
            this.putValue("ShortDescription", "Italic");
            this.setEnabled(false);
        }

        @Override
        public void update(Observable obs, Object arg) {
            AttributeSet as = (AttributeSet)arg;
            this.putValue("SwingSelectedKey", StyleConstants.isItalic(as));
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class InsertSymbolAction
    extends StyledEditorKit.StyledTextAction
    implements StyleObserver {
        public InsertSymbolAction() {
            super("Insert symbol");
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/insert_symbol.png"));
            this.putValue("ShortDescription", "Insert symbol");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor == null) {
                return;
            }
            MutableAttributeSet as = this.getStyledEditorKit(editor).getInputAttributes();
            symDiag.changeFont(StyleConstants.getFontFamily(as));
            symDiag.setVisible(true);
        }

        @Override
        public void update(Observable obs, Object arg) {
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class FontSizeAction
    extends StyledEditorKit.FontSizeAction
    implements StyleObserver {
        public FontSizeAction(int size) {
            super("FontSize", size);
            this.setEnabled(false);
        }

        @Override
        public void update(Observable obs, Object arg) {
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class FontColourAction
    extends StyledEditorKit.StyledTextAction
    implements StyleObserver {
        public FontColourAction() {
            super("FontColor");
            this.putValue("Name", "Foreground");
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/lc_color.png"));
            this.putValue("ShortDescription", "Text colour");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor == null) {
                return;
            }
            MutableAttributeSet as = this.getStyledEditorKit(editor).getInputAttributes();
            Color clr = FormatActions.getColour();
            new StyledEditorKit.ForegroundAction("Foreground", clr).actionPerformed(ae);
        }

        @Override
        public void update(Observable obs, Object arg) {
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class BoldAction
    extends StyledEditorKit.BoldAction
    implements StyleObserver {
        public BoldAction() {
            this.putValue("Name", "Bold");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control B"));
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/lc_bold.png"));
            this.putValue("ShortDescription", "Bold");
            this.setEnabled(false);
        }

        @Override
        public void update(Observable obs, Object arg) {
            AttributeSet as = (AttributeSet)arg;
            this.putValue("SwingSelectedKey", StyleConstants.isBold(as));
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class BackgroundColourAction
    extends StyledEditorKit.StyledTextAction
    implements StyleObserver {
        public BackgroundColourAction() {
            super("BackgroundColour");
            this.putValue("Name", "Background");
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/lc_characterbackgroundpattern.png"));
            this.putValue("ShortDescription", "Background colour");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor == null) {
                return;
            }
            MutableAttributeSet as = this.getStyledEditorKit(editor).getInputAttributes();
            Color clr = FormatActions.getColour();
            new SVGEditorKit.BackgroundAction(clr).actionPerformed(ae);
        }

        @Override
        public void update(Observable arg0, Object arg1) {
            this.setEnabled(FormatActions.isEditorActive());
        }
    }

    private static class AlignRightAction
    extends AlignmentAction {
        public AlignRightAction() {
            super("right", 2, "icons/lc_alignright.png");
            this.putValue("Name", "Align right");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control R"));
            this.putValue("ShortDescription", "Align right");
        }
    }

    private static abstract class AlignmentAction
    extends StyledEditorKit.AlignmentAction
    implements StyleObserver {
        private int align;

        public AlignmentAction(String nm, Integer align, String icon) {
            super(nm, align);
            this.align = align;
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon(icon));
            this.setEnabled(false);
        }

        @Override
        public void update(Observable obs, Object arg) {
            AttributeSet as = (AttributeSet)arg;
            if (as != null) {
                this.putValue("SwingSelectedKey", StyleConstants.getAlignment(as) == this.align);
            }
            this.setEnabled(currentEditor != null && currentEditor instanceof SVGEditorPane && currentEditor.isEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            StyledDocument document = (StyledDocument)currentEditor.getDocument();
            for (Observer obs : styleListeners) {
                if (!(obs instanceof AlignmentAction)) continue;
                obs.update(null, document.getParagraphElement(currentEditor.getCaretPosition()).getAttributes());
            }
        }
    }

    private static class AlignLeftAction
    extends AlignmentAction {
        public AlignLeftAction() {
            super("left", 0, "icons/lc_alignleft.png");
            this.putValue("Name", "Align left");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control L"));
            this.putValue("ShortDescription", "Align left");
        }
    }

    private static class AlignCenterAction
    extends AlignmentAction {
        public AlignCenterAction() {
            super("center", 1, "icons/lc_alignhorizontalcenter.png");
            this.putValue("Name", "Align center");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control E"));
            this.putValue("ShortDescription", "Centered");
        }
    }
}

