/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import nl.rug.syntree.mainview.components.ActionSupport;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.treediagram.TreeView;

public class OrientMenu
extends JMenu {
    private TreeView tv;

    private Object getSetting(String key) {
        return this.tv.getSetting(key);
    }

    private void setSetting(String key, boolean horiz, boolean invert) {
        this.tv.setOrientSetting(horiz, invert);
    }

    private String getIcon(boolean horiz, boolean invert) {
        if (!horiz && !invert) {
            return "icons/tree_down.png";
        }
        if (!horiz && invert) {
            return "icons/tree_up.png";
        }
        if (horiz && !invert) {
            return "icons/tree_left.png";
        }
        return "icons/tree_right.png";
    }

    private String getTitle(boolean horiz, boolean invert) {
        if (!horiz && !invert) {
            return "Top to bottom";
        }
        if (!horiz && invert) {
            return "Bottom to top";
        }
        if (horiz && !invert) {
            return "Left to right";
        }
        return "Right to left";
    }

    public OrientMenu(TreeView tv) {
        this.tv = tv;
        this.setIcon(UIIcons.addImageIcon(this.getIcon(this.tv.isHorizontal(), this.tv.isInverted())));
        this.setText("");
        this.add(ActionSupport.makeMenuItem(new OrientAction(false, false)));
        this.add(ActionSupport.makeMenuItem(new OrientAction(false, true)));
        this.add(ActionSupport.makeMenuItem(new OrientAction(true, false)));
        this.add(ActionSupport.makeMenuItem(new OrientAction(true, true)));
    }

    private class OrientAction
    extends AbstractAction
    implements Observer {
        private boolean horiz;
        private boolean invert;

        public OrientAction(boolean horiz, boolean invert) {
            this.horiz = horiz;
            this.invert = invert;
            this.putValue("Name", OrientMenu.this.getTitle(horiz, invert));
            this.putValue("SmallIcon", UIIcons.addImageIcon(OrientMenu.this.getIcon(horiz, invert)));
            this.putValue("ActionSupport-choosable", true);
            this.putValue("SwingSelectedKey", OrientMenu.this.tv.isHorizontal() == horiz && OrientMenu.this.tv.isInverted() == invert);
            OrientMenu.this.tv.getModel().addObserver(this);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            OrientMenu.this.tv.getController().invokeLater(new Runnable(){

                @Override
                public void run() {
                    OrientMenu.this.setSetting("tv-horizontal", OrientAction.this.horiz, OrientAction.this.invert);
                }
            });
        }

        @Override
        public void update(Observable obs, Object arg) {
            this.putValue("SwingSelectedKey", OrientMenu.this.tv.isHorizontal() == this.horiz && OrientMenu.this.tv.isInverted() == this.invert);
            OrientMenu.this.setIcon(UIIcons.addImageIcon(OrientMenu.this.getIcon(OrientMenu.this.tv.isHorizontal(), OrientMenu.this.tv.isInverted())));
        }
    }
}

