/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import nl.rug.syntree.hierarchicalmodel.nodecontent.DocumentContent;
import nl.rug.syntree.mainview.RTFTransferable;
import nl.rug.syntree.treediagram.texteditor.SVGEditorKit;
import rtf.AdvancedRTFDocument;

public class RTFEditorPane
extends JEditorPane
implements ClipboardOwner {
    public RTFEditorPane() {
        CopyAction copyAction = new CopyAction();
        CutAction cutAction = new CutAction();
        PasteAction pasteAction = new PasteAction();
        this.getActionMap().put("copy", copyAction);
        this.getActionMap().put("cut", cutAction);
        this.getActionMap().put("paste", pasteAction);
    }

    private void replaceSelection(DocumentContent source) {
        System.out.println("Start pasting");
        RTFEditorPane editor = this;
        DocumentContent target = (DocumentContent)editor.getDocument();
        int start = editor.getSelectionStart();
        try {
            System.out.println("Removing in pasting");
            target.remove(editor.getSelectionStart(), editor.getSelectionEnd() - editor.getSelectionStart());
            System.out.println("Adding in pasting");
            for (int i = 0; i < source.getLength(); ++i) {
                System.out.println("pasting char " + (start + i));
                Element e = source.getCharacterElement(i);
                Element pe = source.getParagraphElement(i);
                System.out.println(source.getText(i, 1));
                target.insertString(start + i, source.getText(i, 1), e.getAttributes().copyAttributes());
                target.setCharacterAttributes(start + i, 1, pe.getAttributes(), false);
            }
            System.out.println("Done pasting");
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    private void copyRTF() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        RTFEditorPane editor = this;
        try {
            AdvancedRTFDocument document = this.getSubDocument((AdvancedRTFDocument)editor.getDocument(), editor.getSelectionStart(), editor.getSelectionEnd() - editor.getSelectionStart());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            StringWriter writer = new StringWriter();
            System.out.println("ARTF" + (document instanceof AdvancedRTFDocument));
            this.getEditorKit().write(writer, (Document)document, 0, document.getLength());
            ((Writer)writer).flush();
            String RTFText = ((Object)writer).toString();
            RTFText = RTFText.replaceAll("\\\\sub0", "\\}").replaceAll("\\\\sub(\\S+) ", "$1{\\\\sub ");
            RTFTransferable transferable = new RTFTransferable(RTFText, document.getText(0, document.getLength()));
            clipboard.setContents(transferable, this);
        }
        catch (IOException | BadLocationException e) {
            e.printStackTrace();
        }
    }

    private AdvancedRTFDocument getSubDocument(AdvancedRTFDocument document, int startIndex, int length) throws BadLocationException {
        AdvancedRTFDocument doc = (AdvancedRTFDocument)this.getEditorKit().createDefaultDocument();
        MutableAttributeSet inputAttributes = ((StyledEditorKit)this.getEditorKit()).getInputAttributes();
        SVGEditorKit.SubscriptAction.setFontScaling(inputAttributes, false);
        for (int i = startIndex; i < Math.min(document.getLength(), startIndex + length); ++i) {
            Element e = document.getCharacterElement(i);
            MutableAttributeSet mas = (MutableAttributeSet)e.getAttributes().copyAttributes();
            if (StyleConstants.isSubscript(mas) || StyleConstants.isSuperscript(mas)) {
                StyleConstants.setFontSize(mas, StyleConstants.getFontSize(inputAttributes));
            }
            doc.insertString(doc.getLength(), document.getText(i, 1), mas);
        }
        return doc;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private class PasteAction
    extends StyledEditorKit.StyledTextAction {
        public PasteAction() {
            super("Paste");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            DataFlavor RTFFlavor = new DataFlavor("text/rtf", "Rich Text Format");
            DocumentContent temporaryDocument = new DocumentContent();
            try {
                if (transferable.isDataFlavorSupported(RTFFlavor)) {
                    ByteArrayInputStream is = (ByteArrayInputStream)transferable.getTransferData(RTFFlavor);
                    RTFEditorPane.this.getEditorKit().read(is, (Document)temporaryDocument, 0);
                    if (temporaryDocument.getLength() == 0) {
                        is = (ByteArrayInputStream)transferable.getTransferData(RTFFlavor);
                        new RTFEditorKit().read(is, (Document)temporaryDocument, 0);
                    }
                    System.out.println("RTF");
                    RTFEditorPane.this.replaceSelection(temporaryDocument);
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String text = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    temporaryDocument.insertString(0, text, temporaryDocument.defaultStyle);
                    RTFEditorPane.this.replaceSelection(temporaryDocument);
                }
            }
            catch (UnsupportedFlavorException | IOException | BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private class CutAction
    extends StyledEditorKit.StyledTextAction {
        public CutAction() {
            super("Cut");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control X"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            RTFEditorPane.this.copyRTF();
            RTFEditorPane editor = RTFEditorPane.this;
            try {
                RTFEditorPane.this.getDocument().remove(editor.getSelectionStart(), editor.getSelectionEnd() - editor.getSelectionStart());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private class CopyAction
    extends StyledEditorKit.StyledTextAction {
        public CopyAction() {
            super("Copy");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control C"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MutableAttributeSet mas = (MutableAttributeSet)this.getStyledEditorKit(RTFEditorPane.this).getInputAttributes().copyAttributes();
            RTFEditorPane.this.copyRTF();
        }
    }
}

