/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.rug.syntree.Settings;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.treediagram.TreeView;

public class SlidersMenu
extends JMenu {
    private TreeView tv;
    private JRadioButton radioAutoAng;
    private JRadioButton radioConstAng;
    private JRadioButton radioMaxAng;
    private JCheckBox checkMaxHeight;
    private JSlider slideWidth;
    private JSlider slideHeight;
    private JSlider slideAngle;
    private JSlider slideMaxHeight;
    private JButton btnDefault;

    private Hashtable<Integer, JLabel> mkTab(int[] ticks, String suffix) {
        Hashtable<Integer, JLabel> tab = new Hashtable<Integer, JLabel>();
        for (int labelValue : ticks) {
            JLabel label = new JLabel(Integer.toString(labelValue) + suffix);
            tab.put(labelValue, label);
            label.setFont(label.getFont().deriveFont(9.0f));
        }
        return tab;
    }

    private JSlider mkSlider(int min, int max, int cur, Hashtable<Integer, JLabel> tickTab) {
        JSlider ret = new JSlider(min, max, cur);
        ret.setLabelTable(tickTab);
        ret.setPaintLabels(true);
        ret.setPaintTicks(true);
        ret.setMajorTickSpacing(100);
        ret.setMinorTickSpacing(25);
        return ret;
    }

    private JPanel mkPanel(JComponent left, JComponent right) {
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)left, "West");
        pane.add((Component)right, "East");
        return pane;
    }

    private JRadioButton mkRadio(String icon, String title) {
        JRadioButton ret = new JRadioButton(title);
        return ret;
    }

    private Object getSetting(String key) {
        return this.tv.getSetting(key);
    }

    private void setSetting(String key, Object val) {
        if (!(val instanceof Serializable)) {
            return;
        }
        this.tv.setSetting(key, (Serializable)val);
    }

    private Object setDefVal(String key) {
        Object ret = Settings.get(key);
        this.setSetting(key, ret);
        return ret;
    }

    public SlidersMenu(TreeView tv) {
        this.tv = tv;
        this.setIcon(UIIcons.addImageIcon("icons/tree_anglify.png"));
        ButtonGroup bg = new ButtonGroup();
        this.radioAutoAng = this.mkRadio("icons/tree_default.png", "Auto");
        this.radioAutoAng.addActionListener(new BatikActionListener(){

            @Override
            public void actionPerformed() {
                if (!SlidersMenu.this.radioAutoAng.isSelected()) {
                    return;
                }
                SlidersMenu.this.setSetting("tv-set-constant-angle", false);
                SlidersMenu.this.setSetting("tv-set-max-angle", false);
                SlidersMenu.this.slideAngle.setEnabled(false);
            }
        });
        bg.add(this.radioAutoAng);
        this.radioConstAng = this.mkRadio("icons/tree_anglify.png", "Constant");
        this.radioConstAng.addActionListener(new BatikActionListener(){

            @Override
            public void actionPerformed() {
                if (!SlidersMenu.this.radioConstAng.isSelected()) {
                    return;
                }
                SlidersMenu.this.setSetting("tv-set-constant-angle", true);
                SlidersMenu.this.setSetting("tv-set-max-angle", false);
                float cur = ((Float)SlidersMenu.this.getSetting("tv-constant-angle")).floatValue();
                SlidersMenu.this.slideAngle.setEnabled(true);
                SlidersMenu.this.slideAngle.setValue((int)cur);
            }
        });
        bg.add(this.radioConstAng);
        this.radioMaxAng = this.mkRadio("icons/tree_max_angle.png", "Maximum");
        this.radioMaxAng.addActionListener(new BatikActionListener(){

            @Override
            public void actionPerformed() {
                if (!SlidersMenu.this.radioMaxAng.isSelected()) {
                    return;
                }
                SlidersMenu.this.setSetting("tv-set-constant-angle", false);
                SlidersMenu.this.setSetting("tv-set-max-angle", true);
                float cur = ((Float)SlidersMenu.this.getSetting("tv-max-angle")).floatValue();
                SlidersMenu.this.slideAngle.setEnabled(true);
                SlidersMenu.this.slideAngle.setValue((int)cur);
            }
        });
        bg.add(this.radioMaxAng);
        this.checkMaxHeight = new JCheckBox("Max. height");
        this.checkMaxHeight.addActionListener(new BatikActionListener(){

            @Override
            public void actionPerformed() {
                SlidersMenu.this.setSetting("tv-set-max-height", SlidersMenu.this.checkMaxHeight.isSelected());
                SlidersMenu.this.slideMaxHeight.setEnabled(SlidersMenu.this.checkMaxHeight.isSelected());
            }
        });
        Hashtable<Integer, JLabel> whTable = this.mkTab(Settings.UI_WHTABLE_TICKS, "%");
        Hashtable<Integer, JLabel> angTable = this.mkTab(Settings.UI_ANGTABLE_TICKS, "\u00b0");
        float curWidth = ((Float)this.tv.getSetting("tv-horizontal-perc")).floatValue();
        this.slideWidth = this.mkSlider(Settings.UI_WIDTH_MIN, Settings.UI_WIDTH_MAX, (int)curWidth, whTable);
        this.slideWidth.addChangeListener(new BatikChangeListener(){

            @Override
            public void stateChanged() {
                if (SlidersMenu.this.slideWidth.getValueIsAdjusting()) {
                    return;
                }
                int val = SlidersMenu.this.slideWidth.getValue();
                SlidersMenu.this.setSetting("tv-horizontal-perc", Float.valueOf(val));
            }
        });
        float curHeight = ((Float)this.tv.getSetting("tv-vertical-perc")).floatValue();
        this.slideHeight = this.mkSlider(Settings.UI_HEIGHT_MIN, Settings.UI_HEIGHT_MAX, (int)curHeight, whTable);
        this.slideHeight.addChangeListener(new BatikChangeListener(){

            @Override
            public void stateChanged() {
                if (SlidersMenu.this.slideHeight.getValueIsAdjusting()) {
                    return;
                }
                int val = SlidersMenu.this.slideHeight.getValue();
                SlidersMenu.this.setSetting("tv-vertical-perc", Float.valueOf(val));
            }
        });
        float curConstAngle = ((Float)this.tv.getSetting("tv-constant-angle")).floatValue();
        this.slideAngle = this.mkSlider(Settings.UI_ANGLE_MIN, Settings.UI_ANGLE_MAX, (int)curConstAngle, angTable);
        this.slideAngle.setMajorTickSpacing(10);
        this.slideAngle.setMinorTickSpacing(10);
        this.slideAngle.addChangeListener(new BatikChangeListener(){

            @Override
            public void stateChanged() {
                if (SlidersMenu.this.slideAngle.getValueIsAdjusting()) {
                    return;
                }
                int val = SlidersMenu.this.slideAngle.getValue();
                String key = "tv-constant-angle";
                if (((Boolean)SlidersMenu.this.getSetting("tv-set-max-angle")).booleanValue()) {
                    key = "tv-max-angle";
                }
                SlidersMenu.this.setSetting(key, Float.valueOf(val));
            }
        });
        float curMaxHeight = ((Float)this.tv.getSetting("tv-max-height")).floatValue();
        this.slideMaxHeight = this.mkSlider(Settings.UI_HEIGHT_MIN, Settings.UI_HEIGHT_MAX, (int)curMaxHeight, whTable);
        this.slideMaxHeight.addChangeListener(new BatikChangeListener(){

            @Override
            public void stateChanged() {
                if (SlidersMenu.this.slideMaxHeight.getValueIsAdjusting()) {
                    return;
                }
                int val = SlidersMenu.this.slideMaxHeight.getValue();
                SlidersMenu.this.setSetting("tv-max-height", Float.valueOf(val));
            }
        });
        this.btnDefault = new JButton("Restore defaults");
        this.btnDefault.addActionListener(new BatikActionListener(){

            @Override
            public void actionPerformed() {
                boolean constAng = (Boolean)SlidersMenu.this.setDefVal("tv-set-constant-angle");
                boolean maxAng = (Boolean)SlidersMenu.this.setDefVal("tv-set-max-angle");
                boolean autoAng = !constAng && !maxAng;
                SlidersMenu.this.radioAutoAng.setSelected(autoAng);
                SlidersMenu.this.radioConstAng.setSelected(constAng);
                SlidersMenu.this.radioMaxAng.setSelected(maxAng);
                boolean maxHeight = (Boolean)SlidersMenu.this.setDefVal("tv-set-max-height");
                SlidersMenu.this.checkMaxHeight.setSelected(maxHeight);
                SlidersMenu.this.slideWidth.setValue(Math.round(((Float)SlidersMenu.this.setDefVal("tv-horizontal-perc")).floatValue()));
                SlidersMenu.this.slideHeight.setValue(Math.round(((Float)SlidersMenu.this.setDefVal("tv-vertical-perc")).floatValue()));
                float angConst = ((Float)SlidersMenu.this.setDefVal("tv-constant-angle")).floatValue();
                float angMax = ((Float)SlidersMenu.this.setDefVal("tv-max-angle")).floatValue();
                SlidersMenu.this.slideAngle.setValue(Math.round(angConst));
                if (maxAng) {
                    SlidersMenu.this.slideAngle.setValue(Math.round(angMax));
                }
                SlidersMenu.this.slideAngle.setEnabled(!autoAng);
                SlidersMenu.this.slideMaxHeight.setValue(Math.round(((Float)SlidersMenu.this.setDefVal("tv-max-height")).floatValue()));
                SlidersMenu.this.slideMaxHeight.setEnabled(maxHeight);
            }
        });
        JPanel radios = new JPanel(new BorderLayout());
        radios.add((Component)this.radioAutoAng, "West");
        radios.add((Component)this.radioConstAng, "Center");
        radios.add((Component)this.radioMaxAng, "East");
        radios.add((Component)this.slideAngle, "South");
        JLabel lab = new JLabel("Margins");
        lab.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add(lab);
        this.addSeparator();
        this.add(this.mkPanel(new JLabel("Width"), this.slideWidth));
        this.addSeparator();
        this.add(this.mkPanel(new JLabel("Height"), this.slideHeight));
        this.addSeparator();
        lab = new JLabel("Constraints");
        lab.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add(lab);
        this.addSeparator();
        this.add(this.mkPanel(new JLabel("Angle"), radios));
        this.addSeparator();
        this.add(this.mkPanel(this.checkMaxHeight, this.slideMaxHeight));
        this.addSeparator();
        this.add(this.mkPanel(new JLabel(""), this.btnDefault));
        this.radioAutoAng.setSelected(true);
        this.radioConstAng.setSelected((Boolean)this.getSetting("tv-set-constant-angle"));
        this.radioMaxAng.setSelected((Boolean)this.getSetting("tv-set-max-angle"));
        this.checkMaxHeight.setSelected((Boolean)this.getSetting("tv-set-max-height"));
        boolean en = (Boolean)this.getSetting("tv-set-constant-angle") != false || (Boolean)this.getSetting("tv-set-max-angle") != false;
        this.slideAngle.setEnabled(en);
        this.slideMaxHeight.setEnabled((Boolean)this.getSetting("tv-set-max-height"));
    }

    private abstract class BatikActionListener
    implements ActionListener {
        private BatikActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            SlidersMenu.this.tv.getController().invokeLater(new Runnable(){

                @Override
                public void run() {
                    BatikActionListener.this.actionPerformed();
                }
            });
        }

        public abstract void actionPerformed();
    }

    private abstract class BatikChangeListener
    implements ChangeListener {
        private BatikChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            SlidersMenu.this.tv.getController().invokeLater(new Runnable(){

                @Override
                public void run() {
                    BatikChangeListener.this.stateChanged();
                }
            });
        }

        public abstract void stateChanged();
    }
}

