/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.Properties;
import javax.swing.JPanel;
import nl.rug.syntree.hierarchicalmodel.exporters.BatikAbstractExportFileType;
import org.apache.batik.swing.JSVGCanvas;

public class UIBatikPreviewComponent
extends JPanel {
    public static final String KEY_PAPER_SIZE = "PaperSize";
    public static final String KEY_PAPER_ORIENTATION = "PaperOrientation";
    public static final String PREVIEW_MEDIA_SCREEN = "Screen (1:1)";
    public static final int DEFAULT_DPI_SETTING = 96;
    public static final float PREVIEW_BORDER_WIDTH = 2.0f;
    public static final float BACKGROUND_PREVIEW_BORDER_WIDTH = 2.0f;
    public static final float MARGINS_STROKE_WIDTH = 1.0f;
    protected String paperSizeKey = null;
    protected String paperOrientationKey = null;
    protected BatikAbstractExportFileType previewGenerator = null;
    protected PageFormat paper = null;
    protected BufferedImage preview = null;
    protected BufferedImage previewBackground = null;
    protected int dotsPerInch = 0;

    public UIBatikPreviewComponent(BatikAbstractExportFileType theGenerator, String theSizeKey, String theOrientationKey, int DPI) {
        this.previewGenerator = theGenerator;
        this.paperSizeKey = theSizeKey;
        this.paperOrientationKey = theOrientationKey;
        this.dotsPerInch = DPI;
        this.setBackground(new Color(128, 128, 128));
        this.setDotsPerInch(this.dotsPerInch);
    }

    public UIBatikPreviewComponent(BatikAbstractExportFileType theGenerator, String theSizeKey, String theOrientationKey) {
        this(theGenerator, theSizeKey, theOrientationKey, 96);
    }

    public double generatePreview(Component theSource, Properties renderingProps, boolean scaleToFit) throws Exception {
        if (this.preview != null) {
            this.preview.flush();
            this.preview = null;
        }
        if (this.previewBackground != null) {
            this.previewBackground.flush();
            this.previewBackground = null;
        }
        Dimension preferredSize = this.getPreviewViewportSize();
        int previewWidth = -1;
        int previewHeight = -1;
        String width = renderingProps.getProperty(BatikAbstractExportFileType.class.getName() + "." + "ImageSize");
        if (width != null) {
            String[] dimensions = width.split(", ");
            previewWidth = Integer.parseInt(dimensions[0]);
            previewHeight = Integer.parseInt(dimensions[1]);
        }
        double usedScaleFactor = 0.0;
        if (this.previewGenerator == null) {
            if (width == null && theSource instanceof JSVGCanvas) {
                JSVGCanvas canvas = (JSVGCanvas)theSource;
                Rectangle sourceDimensions = canvas.getGraphicsNode().getBounds().getBounds();
                previewWidth = sourceDimensions.width;
                previewHeight = sourceDimensions.height;
            } else if (previewWidth == -1 && previewHeight == -1) {
                throw new Exception("Error: No width and height were found for generating the preview image.\nSynTree will continue without the preview.\nThis is an application error, please contact SynTree developers with this error message and the below cause.");
            }
            if (previewWidth > -1 && previewHeight > -1) {
                double previewAspectRatio = (double)previewHeight / (double)previewWidth;
                String paperSize = renderingProps.getProperty(this.paperSizeKey);
                String paperOrientation = renderingProps.getProperty(this.paperOrientationKey);
                if (paperSize != null && paperOrientation != null) {
                    if (!paperSize.equals(PREVIEW_MEDIA_SCREEN)) {
                        this.paper = PaperSizes.getPaper(paperSize, this.dotsPerInch);
                        this.setPaperOrientation(paperOrientation);
                        Dimension paperDimension = new Dimension();
                        paperDimension.setSize(this.paper.getWidth(), this.paper.getHeight());
                        double viewportScale = this.determineViewportScale(paperDimension, preferredSize);
                        Dimension viewportPaperSize = new Dimension();
                        viewportPaperSize.setSize(this.paper.getImageableWidth() / viewportScale, this.paper.getImageableHeight() / viewportScale);
                        double paperWidthScale = 1.0;
                        paperWidthScale = viewportPaperSize.getWidth() > this.paper.getImageableWidth() ? viewportPaperSize.getWidth() / this.paper.getWidth() : this.paper.getImageableWidth() / viewportPaperSize.getWidth();
                        previewWidth = (int)((double)previewWidth / paperWidthScale);
                        previewHeight = (int)((double)previewWidth * previewAspectRatio);
                        double paperScale = 1.0;
                        if (scaleToFit) {
                            paperScale = this.determinePreviewScale(new Dimension((int)(this.paper.getImageableWidth() / paperWidthScale), (int)(this.paper.getImageableHeight() / paperWidthScale)), new Dimension(previewWidth, previewHeight), scaleToFit);
                        }
                        usedScaleFactor = paperScale;
                        previewWidth = (int)((double)previewWidth / paperScale);
                        previewHeight = (int)((double)previewHeight / paperScale);
                        if (previewWidth <= 0) {
                            previewWidth = 1;
                        }
                        if (previewHeight <= 0) {
                            previewHeight = 1;
                        }
                    } else {
                        this.paper = null;
                        if (paperOrientation.equals(PaperOrientations.LANDSCAPE.getName())) {
                            int oldWidth = previewWidth;
                            previewWidth = previewHeight;
                            previewHeight = oldWidth;
                        }
                    }
                } else {
                    String message = "Error: No ";
                    if (paperSize == null) {
                        message = message + "paper size ";
                    }
                    if (paperOrientation == null) {
                        if (paperSize == null) {
                            message = message + "and ";
                        }
                        message = message + "paper orientation ";
                    }
                    message = paperSize == null && paperOrientation == null ? message + "values were " : message + "value was ";
                    message = message + "found required to generate a preview. Export continues without preview.\nThis is an application error, please contact SynTree development with this error and below cause.";
                    throw new Exception(message);
                }
                this.preview = new BufferedImage(previewWidth, previewHeight, 2);
                Graphics2D g2d = this.preview.createGraphics();
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.setColor(Color.black);
                g2d.drawRect((int)Math.floor(1.0), (int)Math.floor(1.0), (int)((float)previewWidth - 2.0f), (int)((float)previewHeight - 2.0f));
            }
        }
        double scaleFactor = 1.0;
        if (this.paper != null) {
            Dimension paperDimension = new Dimension();
            paperDimension.setSize(this.paper.getWidth(), this.paper.getHeight());
            scaleFactor = this.determineViewportScale(paperDimension, preferredSize);
            if (this.previewBackground == null) {
                double backgroundWidth = this.paper.getWidth() / scaleFactor;
                double backgroundHeight = this.paper.getHeight() / scaleFactor;
                if (backgroundWidth <= 0.0) {
                    backgroundWidth = 1.0;
                }
                if (backgroundHeight <= 0.0) {
                    backgroundHeight = 1.0;
                }
                this.previewBackground = new BufferedImage((int)(Math.ceil(backgroundWidth) - 1.0), (int)(Math.ceil(backgroundHeight) - 1.0), 2);
            }
        } else if (this.previewBackground == null) {
            this.previewBackground = new BufferedImage(this.preview.getWidth(), this.preview.getHeight(), 2);
        }
        Graphics2D backgroundGraphics = this.previewBackground.createGraphics();
        if (this.paper != null) {
            backgroundGraphics.setStroke(new BasicStroke(2.0f));
            backgroundGraphics.setColor(Color.black);
            backgroundGraphics.drawRect(1, 1, (int)((float)this.previewBackground.getWidth() - 2.0f), (int)((float)this.previewBackground.getHeight() - 2.0f));
            backgroundGraphics.setColor(Color.white);
            backgroundGraphics.fillRect(2, 2, (int)((float)this.previewBackground.getWidth() - 4.0f), (int)((float)this.previewBackground.getHeight() - 4.0f));
            if (this.paper != null) {
                backgroundGraphics.setColor(Color.black);
                backgroundGraphics.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f}, 0.0f));
                double scaledImgX = this.paper.getImageableX() / scaleFactor;
                double scaledImgY = this.paper.getImageableY() / scaleFactor;
                backgroundGraphics.drawLine((int)Math.floor(scaledImgX), (int)Math.floor(2.0), (int)Math.floor(scaledImgX), (int)Math.floor((float)this.previewBackground.getHeight() - 2.0f));
                backgroundGraphics.drawLine((int)Math.floor((double)this.previewBackground.getWidth() - scaledImgX), (int)Math.floor(2.0), (int)Math.floor((double)this.previewBackground.getWidth() - scaledImgX), (int)Math.floor((float)this.previewBackground.getHeight() - 2.0f));
                backgroundGraphics.drawLine((int)Math.floor(2.0), (int)Math.floor(scaledImgY), (int)Math.floor((float)this.previewBackground.getWidth() - 2.0f), (int)Math.floor(scaledImgY));
                backgroundGraphics.drawLine((int)Math.floor(2.0), (int)Math.floor((double)this.previewBackground.getHeight() - scaledImgY), (int)Math.floor((float)this.previewBackground.getWidth() - 2.0f), (int)Math.floor((double)this.previewBackground.getHeight() - scaledImgY));
            }
        } else {
            backgroundGraphics.setColor(Color.white);
            backgroundGraphics.fillRect(0, 0, this.previewBackground.getWidth(), this.previewBackground.getHeight());
        }
        return usedScaleFactor;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Dimension preferredSize = this.getPreviewViewportSize();
        double previewX = 0.0;
        double previewY = 0.0;
        if (this.paper != null) {
            Dimension paperDimension = new Dimension();
            paperDimension.setSize(this.paper.getWidth(), this.paper.getHeight());
            double scaleFactor = this.determineViewportScale(paperDimension, preferredSize);
            previewX = this.paper.getImageableX() / scaleFactor;
            previewY = this.paper.getImageableY() / scaleFactor;
        }
        AffineTransform oldTransform = g2d.getTransform();
        double translateX = 1.0;
        double translateY = 1.0;
        if (preferredSize.getWidth() > (double)this.previewBackground.getWidth()) {
            translateX = Math.floor(0.5 * preferredSize.getWidth() - 0.5 * (double)this.previewBackground.getWidth());
        }
        if (preferredSize.getHeight() > (double)this.previewBackground.getHeight()) {
            translateY = Math.floor(0.5 * preferredSize.getHeight() - 0.5 * (double)this.previewBackground.getHeight());
        }
        g2d.translate(translateX, translateY);
        g.drawImage(this.previewBackground, 0, 0, this.previewBackground.getWidth(), this.previewBackground.getHeight(), null);
        if (this.preview != null) {
            g.drawImage(this.preview, (int)previewX, (int)previewY, this.preview.getWidth(), this.preview.getHeight(), null);
        }
        g2d.setTransform(oldTransform);
    }

    public double determineViewportScale(Dimension mediaSize, Dimension viewportSize) {
        double scale = 1.0;
        if (viewportSize.getWidth() > mediaSize.getWidth() && viewportSize.getHeight() > mediaSize.getHeight()) {
            double scaleHeights;
            double scaleWidths = viewportSize.getWidth() / mediaSize.getWidth();
            scale = scaleWidths > (scaleHeights = viewportSize.getHeight() / mediaSize.getHeight()) ? scaleWidths : scaleHeights;
        } else if (viewportSize.getWidth() > mediaSize.getWidth() && viewportSize.getHeight() <= mediaSize.getHeight()) {
            scale = mediaSize.getHeight() / viewportSize.getHeight();
        } else if (viewportSize.getWidth() <= mediaSize.getWidth() && viewportSize.getHeight() > mediaSize.getHeight()) {
            scale = mediaSize.getWidth() / viewportSize.getWidth();
        } else if (viewportSize.getWidth() <= mediaSize.getWidth() && viewportSize.getHeight() <= mediaSize.getHeight()) {
            double scaleHeights;
            double scaleWidths = mediaSize.getWidth() / viewportSize.getWidth();
            scale = scaleWidths > (scaleHeights = mediaSize.getHeight() / viewportSize.getHeight()) ? scaleWidths : scaleHeights;
        }
        return scale;
    }

    public double determinePreviewScale(Dimension mediaSize, Dimension previewSize, boolean scaleToFit) {
        double scale = 1.0;
        if (previewSize.getWidth() > mediaSize.getWidth() && previewSize.getHeight() <= mediaSize.getHeight()) {
            scale = previewSize.getWidth() / mediaSize.getWidth();
        } else if (previewSize.getWidth() <= mediaSize.getWidth() && previewSize.getHeight() > mediaSize.getHeight()) {
            scale = previewSize.getHeight() / mediaSize.getHeight();
        } else if (previewSize.getWidth() > mediaSize.getWidth() && previewSize.getHeight() > mediaSize.getHeight()) {
            double diffHeights;
            double diffWidths = previewSize.getWidth() - mediaSize.getWidth();
            scale = diffWidths > (diffHeights = previewSize.getHeight() - mediaSize.getHeight()) ? previewSize.getWidth() / mediaSize.getWidth() : previewSize.getHeight() / mediaSize.getHeight();
        } else if (scaleToFit) {
            // empty if block
        }
        return scale;
    }

    public void setPaperOrientation(String orientation) throws Exception {
        int javaOrientation = -1;
        if (orientation.equals(PaperOrientations.PORTRAIT.getName())) {
            javaOrientation = 1;
        } else if (orientation.equals(PaperOrientations.LANDSCAPE.getName())) {
            javaOrientation = 0;
        }
        if (javaOrientation > -1) {
            if (this.paper != null && this.paper.getOrientation() != javaOrientation) {
                if (this.paper.getOrientation() == 1 && javaOrientation == 0) {
                    this.paper.setOrientation(0);
                } else if (this.paper.getOrientation() == 0 && javaOrientation == 1) {
                    this.paper.setOrientation(1);
                }
                Paper paperFormat = this.paper.getPaper();
                paperFormat.setSize(paperFormat.getHeight(), paperFormat.getWidth());
                paperFormat.setImageableArea(paperFormat.getImageableY(), paperFormat.getImageableX(), paperFormat.getImageableHeight(), paperFormat.getImageableWidth());
            }
        } else {
            throw new Exception("Error: Found unknown page orientation '" + orientation + "' while configuring preview.\nPreview will not be available.\nThis is an application error, please contact SynTree development with this message and the below cause.");
        }
    }

    public void setDotsPerInch(int newDPI) {
        this.dotsPerInch = newDPI;
    }

    public Dimension getPreviewViewportSize() {
        Dimension size = this.getPreferredSize();
        if (this.getParent() != null) {
            Dimension parentSize = this.getParent().getSize();
            Insets parentBorder = this.getParent().getInsets();
            parentSize.setSize(parentSize.getWidth() - (double)parentBorder.left - (double)parentBorder.right, parentSize.getHeight() - (double)parentBorder.top - (double)parentBorder.bottom);
            if (parentSize.width <= 0) {
                parentSize.setSize(1.0, parentSize.getHeight());
            }
            if (parentSize.height <= 0) {
                parentSize.setSize(parentSize.getWidth(), 1.0);
            }
            size = parentSize;
        }
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.previewBackground != null) {
            preferredSize = new Dimension(this.previewBackground.getWidth() + 1, this.previewBackground.getHeight() + 1);
        }
        return preferredSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public static enum PaperOrientations {
        PORTRAIT("Portrait"),
        LANDSCAPE("Landscape");

        protected String name = null;

        private PaperOrientations(String theName) {
            this.name = theName;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum PaperSizes {
        A0("A0", new PageFormat()),
        A1("A1", new PageFormat()),
        A2("A2", new PageFormat()),
        A3("A3", new PageFormat()),
        A4("A4", new PageFormat()),
        A5("A5", new PageFormat()),
        LETTER("(US) Letter", new PageFormat());

        protected String name = null;
        protected PageFormat paper = null;

        private PaperSizes(String theName, PageFormat thePaper) {
            this.name = theName;
            this.paper = thePaper;
        }

        protected void setPaper(Paper paperSize) {
            this.paper.setPaper(paperSize);
        }

        public String getName() {
            return this.name;
        }

        public PageFormat getPaper(int DPI) {
            return this.getPaper(DPI, 1.0, 1.0, 1.0, 1.0);
        }

        public PageFormat getPaper(int DPI, double marginTop, double marginLeft, double marginBottom, double marginRight) {
            PageFormat convertedFormat = new PageFormat();
            Paper paperSizePx = new Paper();
            paperSizePx.setSize(this.paper.getWidth() * (double)DPI, this.paper.getHeight() * (double)DPI);
            paperSizePx.setImageableArea(marginLeft * (double)DPI, marginTop * (double)DPI, paperSizePx.getWidth() - (marginLeft + marginRight) * (double)DPI, paperSizePx.getHeight() - (marginTop + marginBottom) * (double)DPI);
            convertedFormat.setPaper(paperSizePx);
            return convertedFormat;
        }

        public static PageFormat getPaper(String theName, int DPI) {
            PageFormat thePaper = null;
            if (A0.getName().equals(theName)) {
                thePaper = A0.getPaper(DPI);
            } else if (A1.getName().equals(theName)) {
                thePaper = A1.getPaper(DPI);
            } else if (A2.getName().equals(theName)) {
                thePaper = A2.getPaper(DPI);
            } else if (A3.getName().equals(theName)) {
                thePaper = A3.getPaper(DPI);
            } else if (A4.getName().equals(theName)) {
                thePaper = A4.getPaper(DPI);
            } else if (A5.getName().equals(theName)) {
                thePaper = A5.getPaper(DPI);
            } else if (LETTER.getName().equals(theName)) {
                thePaper = LETTER.getPaper(DPI);
            }
            return thePaper;
        }

        static {
            Paper paper = new Paper();
            paper.setSize(33.11, 46.81);
            A0.setPaper(paper);
            paper = new Paper();
            paper.setSize(23.39, 33.11);
            A1.setPaper(paper);
            paper = new Paper();
            paper.setSize(16.54, 23.39);
            A2.setPaper(paper);
            paper.setSize(11.69, 16.54);
            A3.setPaper(paper);
            paper = new Paper();
            paper.setSize(8.27, 11.69);
            A4.setPaper(paper);
            paper = new Paper();
            paper.setSize(5.83, 8.27);
            A5.setPaper(paper);
            paper = new Paper();
            paper.setSize(8.5, 11.0);
            LETTER.setPaper(paper);
        }
    }
}

