/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.rug.syntree.hierarchicalmodel.exporters.BatikAbstractExportFileType;
import nl.rug.syntree.hierarchicalmodel.exporters.freehep.graphicsio.emf.BatikEMFExportFileType;
import nl.rug.syntree.hierarchicalmodel.exporters.rastergraphics.BatikJPEGExportFileType;
import nl.rug.syntree.hierarchicalmodel.exporters.rastergraphics.BatikPNGExportFileType;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.ExportPresetOptionsPanel;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.ImageSizeUnitsPanel;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.PreviewOptionsPanel;
import nl.rug.syntree.hierarchicalmodel.exporters.vectorgraphics.BatikEPSExportFileType;
import nl.rug.syntree.hierarchicalmodel.exporters.vectorgraphics.BatikPDFExportFileType;
import nl.rug.syntree.hierarchicalmodel.exporters.vectorgraphics.BatikPSExportFileType;
import nl.rug.syntree.mainview.UIUtilities;
import nl.rug.syntree.mainview.components.NavigatableDialog;
import nl.rug.syntree.mainview.components.UIBatikPreviewComponent;
import nl.rug.syntree.mainview.components.UIIcons;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.swing.ErrorDialog;
import org.freehep.swing.layout.TableLayout;

public class UIExportDialog
extends JOptionPane {
    protected static final String rootKey = UIExportDialog.class.getName();
    public static final String SAVE_AS_TYPE = rootKey + ".SaveAsType";
    protected static final String SAVE_AS_FILE = rootKey + ".SaveAsFile";
    protected String creator = null;
    protected JButton browse = null;
    protected JTextField fileName = null;
    protected JTextField filePath = null;
    protected UIBatikPreviewComponent previewComponent = null;
    protected PreviewOptionsPanel previewOptions = null;
    protected JScrollPane previewScrollPane = null;
    protected ExportPresetOptionsPanel presetOptionsPanel = null;
    protected OptionPanel exportOptions = null;
    protected Component component = null;
    protected boolean trusted = true;
    protected Properties props = new Properties();
    protected String baseDir = null;
    protected JCheckBox openExportedFile = null;
    protected JCheckBox openContainingFolder = null;
    private String filePathMemory = new String();
    private ImageSizeUnitsPanel imageSize = null;

    public UIExportDialog() {
        this(null);
    }

    public UIExportDialog(String creator) {
        this(creator, true, null);
    }

    public UIExportDialog(String creator, boolean addAllExportFileTypes, String[] notToAdd) {
        super(null, -1, 2);
        this.creator = creator;
        this.initComponent(addAllExportFileTypes, notToAdd);
    }

    protected void initComponent(boolean addAllExportFileTypes, String[] notToAdd) {
        this.browse = new JButton("Browse...");
        this.fileName = new JTextField(30);
        this.filePath = new JTextField(30);
        this.setBorder(BorderFactory.createEmptyBorder(7, 10, 10, 10));
        try {
            this.baseDir = System.getProperty("user.home");
        }
        catch (SecurityException x) {
            this.trusted = false;
        }
        ChangeFilePathListener bl = new ChangeFilePathListener();
        JPanel panel = new JPanel(new TableLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        this.previewComponent = new UIBatikPreviewComponent(null, BatikAbstractExportFileType.class.getName() + "." + "PaperSize", BatikAbstractExportFileType.class.getName() + "." + "PaperOrientation");
        this.previewComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                try {
                    UIExportDialog.this.previewComponent.generatePreview(UIExportDialog.this.component, UIExportDialog.this.props, false);
                    UIExportDialog.this.previewComponent.repaint();
                }
                catch (Exception e) {
                    UIUtilities.handleException(e, SwingUtilities.getWindowAncestor(ce.getComponent()), null);
                }
            }
        });
        this.previewScrollPane = new JScrollPane(this.previewComponent);
        this.previewScrollPane.setHorizontalScrollBarPolicy(31);
        this.previewScrollPane.setVerticalScrollBarPolicy(21);
        this.previewScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.previewScrollPane.getViewport().setOpaque(true);
        this.previewScrollPane.getViewport().setBackground(new Color(128, 128, 128));
        this.previewScrollPane.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        panel.add((Component)this.previewScrollPane, "0 1 1 1 [0 0 10 10] {0.4 1.0} wh");
        this.previewOptions = new PreviewOptionsPanel(this.props, BatikAbstractExportFileType.class.getName(), null, this.component, this.previewComponent, this.previewScrollPane);
        panel.add((Component)this.previewOptions, "0 0 1 1 [3 0 5 10] {0.4 0.0} w");
        if (this.trusted) {
            JPanel fileDetails = new JPanel(new TableLayout());
            fileDetails.add((Component)new JLabel("Name:"), "0 1 1 1 [0 0 0 2] l");
            fileDetails.add((Component)this.fileName, "1 1 1 1 [0 0 4 0] w");
            fileDetails.add((Component)new JLabel("Path:"), "0 2 1 1 [0 0 0 0] l");
            fileDetails.add((Component)this.filePath, "1 2 1 1 [1 0 0 0] w");
            fileDetails.add((Component)this.browse, "2 2 1 1 [0 5 0 0] l");
            panel.add((Component)fileDetails, "0 2 2 1 [0 0 10 0] w");
        }
        this.browse.addActionListener(bl);
        this.exportOptions = new OptionPanel(null);
        this.presetOptionsPanel = new ExportPresetOptionsPanel(this.props, BatikAbstractExportFileType.class.getName());
        this.exportOptions.add((Component)this.presetOptionsPanel, "0 0 1 1 (0 0) [0 0 10 0] wh");
        panel.add((Component)this.exportOptions, "1 0 1 2 [0 0 10 0] {0.6 1.0} wh");
        OptionPanel openOptionPanel = new OptionPanel(null);
        this.openContainingFolder = new JCheckBox("Open folder containing exported file");
        this.openExportedFile = new JCheckBox("Open file after export, in associated application (if any)");
        if (System.getProperty("os.name").toLowerCase().contains("mac") || System.getProperty("os.name").toLowerCase().contains("windows")) {
            this.openContainingFolder.setSelected(true);
        }
        if (!Desktop.isDesktopSupported()) {
            this.openContainingFolder.setEnabled(false);
            this.openExportedFile.setEnabled(false);
            this.openContainingFolder.setToolTipText("Unfortunately, this option is not supported by SynTree on this operating system.");
            this.openExportedFile.setToolTipText("Unfortunately, this option is not supported by SynTree on this operating system.");
        }
        openOptionPanel.add((Component)this.openContainingFolder, "0 0 1 1 [0 0 -3 0] wh");
        openOptionPanel.add((Component)this.openExportedFile, "0 1 1 1 [0 0 0 0] wh");
        panel.add((Component)openOptionPanel, "0 3 1 1 [0 0 8 0] w");
        this.setMessage(panel);
        if (addAllExportFileTypes) {
            this.addAllExportFileTypes(notToAdd);
        }
    }

    public String getFilePathMemory() {
        return this.filePathMemory;
    }

    public void setFilePathMemory(String filePathMemory) {
        this.filePathMemory = filePathMemory;
    }

    public void showExportDialog(Component parent, String title, Component target, Rectangle2D aoi, String defFile) {
        this.props.setProperty("size-x", "" + (int)Math.ceil(aoi.getX()));
        this.props.setProperty("size-y", "" + (int)Math.ceil(aoi.getY()));
        this.props.setProperty("size-w", "" + (int)Math.ceil(aoi.getWidth()));
        this.props.setProperty("size-h", "" + (int)Math.ceil(aoi.getHeight()));
        this.props.setProperty(BatikAbstractExportFileType.class.getName() + "." + "ImageSize", (int)(-aoi.getX() + aoi.getWidth()) + ", " + (int)(-aoi.getY() + aoi.getHeight()));
        this.showExportDialog(parent, title, target, defFile);
    }

    public void showExportDialog(Component parent, String title, Component target, String defFile) {
        this.component = target;
        Color defaultBackground = UIManager.getColor("Panel.background");
        float[] hsbVals = Color.RGBtoHSB(defaultBackground.getRed(), defaultBackground.getGreen(), defaultBackground.getBlue(), null);
        Color darkerBackground = Color.getHSBColor(hsbVals[0], hsbVals[1], 0.925f * hsbVals[2]);
        this.presetOptionsPanel.setBackground(darkerBackground);
        OptionPanel sizeOptions = new OptionPanel(null);
        sizeOptions.setBackground(darkerBackground);
        if (this.imageSize == null) {
            this.imageSize = new ImageSizeUnitsPanel(this.props, BatikAbstractExportFileType.class.getName(), true, 96);
        } else {
            this.imageSize.applyChangedOptions(this.props);
        }
        this.imageSize.setLockButtonToolTipText("Image width - height ratio (i.e. aspect ratio) is locked");
        this.imageSize.setOpaque(false);
        this.imageSize.addSizeChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                try {
                    UIExportDialog.this.previewComponent.generatePreview(UIExportDialog.this.component, UIExportDialog.this.props, false);
                    UIExportDialog.this.previewComponent.repaint();
                }
                catch (Exception e) {
                    UIUtilities.handleException(e, SwingUtilities.getWindowAncestor(UIExportDialog.this), null);
                }
            }
        });
        sizeOptions.add((Component)this.imageSize, "0 0 1 1 [5 10 5 10] w");
        this.exportOptions.add((Component)sizeOptions, "0 1 1 1 [0 0 0 0] w");
        this.presetOptionsPanel.showExportPresetOptionsPanel();
        if (this.trusted) {
            if (this.filePathMemory.isEmpty()) {
                String saveFile = this.props.getProperty(SAVE_AS_FILE);
                if (saveFile != null) {
                    this.baseDir = new File(saveFile).getParent();
                    defFile = saveFile;
                } else {
                    defFile = this.baseDir + File.separator + defFile;
                }
                File f = new File(defFile);
                int extensionStart = f.getName().lastIndexOf(".");
                String name = null;
                name = extensionStart > -1 ? f.getName().substring(0, extensionStart) : f.getName();
                this.fileName.setText(name);
                this.filePath.setText(f.getParent());
            } else {
                this.filePath.setText(this.filePathMemory);
            }
        } else {
            this.fileName.setEnabled(false);
            this.filePath.setEnabled(false);
            this.browse.setEnabled(false);
        }
        final JDialog dlg = this.createDialog(SwingUtilities.getWindowAncestor(parent), title);
        Image[] iconArray = new Image[]{UIIcons.addImage("icons/syntree_new.png"), UIIcons.addImage("icons/syntree-new-new.png")};
        List<Image> iconList = Arrays.asList(iconArray);
        dlg.setIconImages(iconList);
        dlg.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                try {
                    UIExportDialog.this.previewComponent.generatePreview(UIExportDialog.this.component, UIExportDialog.this.props, false);
                    UIExportDialog.this.previewComponent.repaint();
                    UIExportDialog.this.previewOptions.revalidate();
                }
                catch (Exception e) {
                    UIUtilities.handleException(e, SwingUtilities.getWindowAncestor(dlg), null);
                }
            }
        });
        dlg.setResizable(true);
        dlg.pack();
        dlg.setLocationRelativeTo(SwingUtilities.getWindowAncestor(parent));
        try {
            double scaleFactor = this.previewComponent.generatePreview(this.component, this.props, true);
            String sizeKey = BatikAbstractExportFileType.class.getName() + "." + "ImageSize";
            String size = this.props.getProperty(sizeKey);
            if (size != null) {
                String[] sizes = size.split(", ");
                int fitWidth = (int)Math.round((double)Integer.parseInt(sizes[0]) / scaleFactor);
                int fitHeight = (int)Math.round((double)Integer.parseInt(sizes[1]) / scaleFactor);
                this.imageSize.setSize(fitWidth, fitHeight);
            }
        }
        catch (Exception e) {
            UIUtilities.handleException(e, SwingUtilities.getWindowAncestor(dlg), null);
        }
        dlg.setVisible(true);
    }

    public void setUserProperties(Properties properties) {
        this.props = properties;
    }

    public void addExportFileType(ExportFileType fileType) {
        this.presetOptionsPanel.getExportFileTypeList().addElement(fileType);
    }

    public void addAllExportFileTypes(String[] notToAdd) {
        this.addExportFileType(new BatikPDFExportFileType());
        this.addExportFileType(new BatikPSExportFileType());
        this.addExportFileType(new BatikEPSExportFileType());
        this.addExportFileType(new BatikJPEGExportFileType());
        this.addExportFileType(new BatikPNGExportFileType());
        this.addExportFileType(new BatikEMFExportFileType());
    }

    protected void filterExportFileTypeGroup(List<ExportFileType> exportFileTypesGroup, String[] removeFrom) {
        int i;
        ExportFileType fileType = null;
        ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
        for (i = 0; i < exportFileTypesGroup.size(); ++i) {
            fileType = exportFileTypesGroup.get(i);
            boolean stop = false;
            for (int j = 0; j < removeFrom.length && !stop; ++j) {
                if (!fileType.getClass().getName().equals(removeFrom[j])) continue;
                indicesToRemove.add(i);
                stop = true;
            }
        }
        for (i = indicesToRemove.size(); i > 0; --i) {
            exportFileTypesGroup.remove((Integer)indicesToRemove.get(i - 1));
        }
    }

    protected ExportFileType currentType() {
        return (ExportFileType)this.presetOptionsPanel.getSelectedExportFileType();
    }

    protected String selectFile() {
        JFileChooser dlg = new JFileChooser();
        dlg.setCurrentDirectory(new File(this.filePathMemory.equals("") ? System.getProperty("user.home") : this.filePathMemory));
        String f = this.filePath.getText() + File.separator + this.fileName.getText();
        if (f != null && !this.fileName.getText().equals("")) {
            dlg.setSelectedFile(new File(f));
        }
        dlg.setFileFilter(this.currentType().getFileFilter());
        if (dlg.showDialog(this, "Select") == 0) {
            return dlg.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    protected boolean writeFile(Component theComponent, Component theParent, ExportFileType t) throws IOException {
        ExportFileType currentType = this.currentType();
        this.currentType().applyChangedOptions(this.exportOptions, this.props);
        File exportFile = new File(this.filePath.getText() + File.separator + this.fileName.getText());
        if (!currentType.fileHasValidExtension(exportFile)) {
            exportFile = new File(this.filePath.getText() + File.separator + this.fileName.getText() + "." + currentType.getExtensions()[0]);
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(exportFile);
            t.exportToFile((OutputStream)outputStream, theComponent, theParent, this.props, this.creator);
            outputStream.flush();
            outputStream.close();
        }
        catch (FileNotFoundException fnfe) {
            UIUtilities.handleException(fnfe, this.component, null);
        }
        catch (IOException e) {
            UIUtilities.handleException(e, this.component, null);
        }
        this.props.put(SAVE_AS_FILE, this.filePath.getText() + File.separator + this.fileName.getText());
        this.props.put(SAVE_AS_TYPE, this.currentType().getFileFilter().getDescription());
        return true;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Integer && (Integer)value == 0) {
            JOptionPane confirmationPane;
            NavigatableDialog dialog;
            int ok;
            ExportFileType currentType;
            try {
                currentType = this.currentType();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Please select an image format for the selected image type category.");
                return;
            }
            this.fileName.setText(this.fileName.getText().replace("/", ""));
            if (this.fileName.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Please enter a file name.");
                return;
            }
            if (this.filePath.getText().isEmpty() || !new File(this.filePath.getText()).exists()) {
                JOptionPane.showMessageDialog(this, "Please enter a valid file path or use the \"Browse\" button.");
                return;
            }
            File f = new File(this.filePath.getText() + File.separator + this.fileName.getText());
            if (!currentType.fileHasValidExtension(f)) {
                f = new File(this.filePath.getText() + File.separator + this.fileName.getText() + "." + currentType.getExtensions()[0]);
            }
            if (f.exists() && (ok = ((Integer)(dialog = new NavigatableDialog(this, confirmationPane = new JOptionPane("Replace existing file?", 3, 2), "File exists")).getResult()).intValue()) != 0) {
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String fileName;
                        if (!UIExportDialog.this.writeFile(UIExportDialog.this.component, SwingUtilities.getWindowAncestor(UIExportDialog.this.component), UIExportDialog.this.currentType())) {
                            return;
                        }
                        if (UIExportDialog.this.openContainingFolder.isSelected()) {
                            if (Desktop.isDesktopSupported()) {
                                try {
                                    String exportedAs = (String)UIExportDialog.this.props.get(SAVE_AS_FILE);
                                    fileName = exportedAs.substring(0, exportedAs.lastIndexOf(File.separator));
                                    Desktop.getDesktop().open(new File(fileName));
                                }
                                catch (IOException ex) {
                                    UIUtilities.handleException(new Exception("Error: Could not open folder containing exported file.\nThe Operating System's file explorer could not be determined."), SwingUtilities.getWindowAncestor(UIExportDialog.this), null);
                                }
                            } else {
                                UIUtilities.handleException(new Exception("Error: Could not show exported file.\nSynTree does not support opening the exported file on this operating system."), SwingUtilities.getWindowAncestor(UIExportDialog.this), null);
                            }
                        }
                        if (UIExportDialog.this.openExportedFile.isSelected()) {
                            if (Desktop.isDesktopSupported()) {
                                try {
                                    String extension = "." + UIExportDialog.this.currentType().getExtensions()[0];
                                    fileName = (String)UIExportDialog.this.props.get(SAVE_AS_FILE);
                                    if (!fileName.endsWith(extension)) {
                                        fileName = fileName + extension;
                                    }
                                    Desktop.getDesktop().open(new File(fileName));
                                }
                                catch (IOException ex) {
                                    UIUtilities.handleException(new Exception("Error: Could not show exported file.\nThe Operating System (OS) has no application associated to view files of type '" + UIExportDialog.this.currentType().getExtensions()[0] + "'.\nAssociate one (usually through the OS's file explorer) to enable this function."), SwingUtilities.getWindowAncestor(UIExportDialog.this), null);
                                }
                            } else {
                                UIUtilities.handleException(new Exception("Error: Could not show exported file.\nSynTree does not support opening the exported file on this operating system."), SwingUtilities.getWindowAncestor(UIExportDialog.this), null);
                            }
                        }
                    }
                    catch (Throwable x) {
                        ErrorDialog.showErrorDialog(UIExportDialog.this, "Error writing graphics file", x);
                        return;
                    }
                }
            }).start();
        }
        UIExportDialog.super.setValue(value);
    }

    public void suggestFileName(String baseName) {
        this.fileName.setText(baseName);
    }

    public String getFileName() {
        return this.fileName.getText();
    }

    class TypeComboBoxListener
    implements ActionListener {
        private ExportFileType previousType = null;

        TypeComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (UIExportDialog.this.presetOptionsPanel.getSelectedExportFileType() instanceof ExportFileType) {
                File f2;
                File f1;
                if (this.previousType == null) {
                    this.previousType = UIExportDialog.this.currentType();
                }
                if (!(f1 = new File(UIExportDialog.this.filePath.getText() + File.separator + UIExportDialog.this.fileName.getText())).equals(f2 = UIExportDialog.this.currentType().adjustFilename(f1, this.previousType.getFileExtension(f1), UIExportDialog.this.props)) && UIExportDialog.this.filePath.isEnabled()) {
                    UIExportDialog.this.fileName.setText(f2.getName());
                }
                this.previousType = UIExportDialog.this.currentType();
                UIExportDialog.this.props.setProperty(BatikAbstractExportFileType.EMBED_FONTS, Boolean.TRUE.toString());
            } else {
                UIExportDialog.this.presetOptionsPanel.setSelectedExportFileType(this.previousType);
            }
        }
    }

    class ChangeFilePathListener
    implements ActionListener {
        ChangeFilePathListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newPath;
            Object source = e.getSource();
            if (source == UIExportDialog.this.browse && (newPath = UIExportDialog.this.selectFile()) != null) {
                File f = new File(newPath);
                if (UIExportDialog.this.currentType() != null) {
                    UIExportDialog.this.currentType().adjustFilename(f, UIExportDialog.this.currentType().getFileExtension(f), UIExportDialog.this.props);
                }
                UIExportDialog.this.fileName.setText(f.getName());
                UIExportDialog.this.filePath.setText(f.getParent());
                UIExportDialog.this.filePathMemory = f.getParent();
            }
        }
    }
}

