/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;

public class UIJToggleButtonWithIcon
extends JPanel
implements ItemListener {
    private JLabel image;
    boolean isEnabled = false;
    public JToggleButton button;

    public UIJToggleButtonWithIcon(final JToggleButton button, Icon icon) {
        this.setLayout(new GridBagLayout());
        this.button = button;
        button.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 15));
        this.image = new JLabel(icon);
        this.add(button);
        button.addItemListener(this);
        this.add(this.image);
        Border outerBorder = BorderFactory.createLineBorder(Color.lightGray);
        Border innerBorder = BorderFactory.createEmptyBorder(10, 30, 10, 30);
        this.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                button.doClick();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!UIJToggleButtonWithIcon.this.isSelected()) {
                    UIJToggleButtonWithIcon.this.backGroundColor(Color.lightGray);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (UIJToggleButtonWithIcon.this.isSelected()) {
                    UIJToggleButtonWithIcon.this.backGroundColor(new Color(12111845));
                } else {
                    UIJToggleButtonWithIcon.this.backGroundColor(null);
                }
            }
        });
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!UIJToggleButtonWithIcon.this.isSelected()) {
                    UIJToggleButtonWithIcon.this.backGroundColor(Color.lightGray);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (UIJToggleButtonWithIcon.this.isSelected()) {
                    UIJToggleButtonWithIcon.this.backGroundColor(new Color(12111845));
                } else {
                    UIJToggleButtonWithIcon.this.backGroundColor(null);
                }
            }
        });
    }

    public void setToolTip(String text) {
        this.setToolTipText(text);
        this.button.setToolTipText(text);
    }

    public void backGroundColor(Color bg) {
        this.setBackground(bg);
        this.button.setBackground(bg);
    }

    public void setAllEnabled(boolean b) {
        this.isEnabled = b;
        this.button.setEnabled(b);
        this.setEnabled(b);
    }

    public boolean isSelected() {
        return this.button.isSelected();
    }

    public void addToButtonGroup(ButtonGroup group) {
        group.add(this.button);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.backGroundColor(new Color(12111845));
        } else if (e.getStateChange() == 2) {
            this.backGroundColor(null);
        }
    }

    public void addItemListener(ItemListener listener) {
        this.button.addItemListener(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.button.addActionListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.button.addChangeListener(listener);
    }

    public Icon getImage() {
        return this.image.getIcon();
    }

    public void setImage(Icon icon) {
        this.image.setIcon(icon);
    }

    public void setSelected(boolean b) {
        this.button.setSelected(b);
    }
}

