/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.exporters.SerialExporter;
import nl.rug.syntree.mainview.components.UIIcons;

public class UIMessagePane
extends JPanel {
    public static final String WARNING = "Warning: ";
    public static final String ERROR = "Error: ";
    public static final String QUESTION = "Question: ";
    public static final String INFO = "Info: ";
    public static String SHOW_DETAILS_BUTTON_LABEL = "Show details";
    public static String HIDE_DETAILS_BUTTON_LABEL = "Hide details";
    public static String COPY_BUTTON_LABEL = "Copy text";
    public static String CLOSE_BUTTON_LABEL = "Close";
    public static Throwable lastThrownException = null;
    protected String abbrMsg = null;
    protected String detailMsg = null;
    protected Icon icon = null;
    protected JTextArea details = null;
    protected JComponent detailsArea = null;
    protected JButton showDetailButton = null;
    protected JButton copyButton = null;
    protected boolean isDetailShown = false;
    protected JPanel subpanel = null;
    protected JButton closeButton = null;
    protected static final Map<String, Icon> icons = new HashMap<String, Icon>();

    public static Icon getIcon(String exceptionType) {
        return icons.get(exceptionType);
    }

    public UIMessagePane(String abbrMessage, String detailMessage, Icon icon) {
        this.initComponent(abbrMessage, detailMessage, icon);
    }

    public UIMessagePane(Throwable e, HierarchicalModel model) {
        StringWriter writer = new StringWriter();
        writer.append("======\nTrace:\n======\n\n");
        if (e.getCause() != null) {
            e.getCause().printStackTrace(new PrintWriter(writer));
        } else {
            e.printStackTrace(new PrintWriter(writer));
        }
        writer.append("\n======\nModel:\n======\n\n");
        try {
            writer.append(model == null ? "N/A" : SerialExporter.modelToBase64(model));
        }
        catch (Exception ex) {
            writer.append(ex.getMessage());
        }
        writer.flush();
        String exceptionType = ERROR;
        if (e.getMessage() != null && e.getMessage().indexOf(" ") > -1) {
            exceptionType = e.getMessage().substring(0, e.getMessage().indexOf(" ") + 1);
        }
        String message = "Whoops! Something double-plus ungood happened\nYou can help us fix this by sending an email to incompleteparenthesis@rug.nl\nunder a subject starting with '[Syntree Bug]', containing the following:\n- A description of what you were doing, what you expected and what actually happened.\n- Any save-files that you used during the session that lead to this error.\n- The text in the box below (use the copy-button to get in on your clipboard).";
        this.initComponent(message + "\n\nMessage: " + e.getMessage(), writer.toString(), UIMessagePane.getIcon(exceptionType));
    }

    protected void initComponent(String abbrMessage, String detailMessage, Icon theIcon) {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.abbrMsg = abbrMessage;
        this.detailMsg = detailMessage;
        this.icon = theIcon;
        MessagePaneGridBagConstraints constraints = new MessagePaneGridBagConstraints();
        JPanel topPanel = new JPanel(new BorderLayout(6, 0));
        topPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        topPanel.add((Component)new JLabel(this.icon), "West");
        JTextArea msgArea = new JTextArea();
        msgArea.setText(this.abbrMsg);
        msgArea.setColumns(40);
        msgArea.setFont(new JLabel().getFont());
        msgArea.setForeground(new JLabel().getForeground());
        msgArea.setOpaque(false);
        msgArea.setEditable(false);
        msgArea.setLineWrap(true);
        msgArea.setWrapStyleWord(true);
        constraints.setWeight(0.0, 0.0);
        constraints.anchor = 10;
        constraints.fill = 2;
        constraints.setGridBounds(0, 0, 1, 1);
        topPanel.add((Component)msgArea, "East");
        this.add((Component)topPanel, constraints);
        constraints.setWeight(1.0, 0.0);
        constraints.anchor = 10;
        constraints.fill = 2;
        constraints.setGridBounds(0, 1, 2, 1);
        this.add((Component)this.createButtonsPanel(), constraints);
        this.details = new JTextArea();
        this.details.setColumns(50);
        this.details.setRows(8);
        this.details.setText(this.detailMsg);
        this.details.setEditable(false);
        this.detailsArea = new JPanel(new BorderLayout(0, 10));
        this.detailsArea.setBorder(BorderFactory.createEmptyBorder(10, 4, 4, 4));
        this.detailsArea.add((Component)new JSeparator(), "North");
        this.detailsArea.add((Component)new JScrollPane(this.details), "Center");
        this.subpanel = new JPanel(new BorderLayout());
        constraints.setWeight(1.0, 1.0);
        constraints.anchor = 10;
        constraints.fill = 1;
        constraints.setGridBounds(0, 2, 2, 1);
        this.add((Component)this.subpanel, constraints);
    }

    public JDialog createDialog(Component owner) {
        JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(owner));
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                lastThrownException = null;
            }
        });
        dialog.setIconImage(UIIcons.addImage("icons/syntree_new.png"));
        dialog.pack();
        if (owner == null) {
            dialog.setLocationRelativeTo(null);
        }
        dialog.getRootPane().setDefaultButton(this.closeButton);
        return dialog;
    }

    protected JPanel createButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout(2));
        this.copyButton = new JButton(COPY_BUTTON_LABEL);
        this.copyButton.addActionListener(new CopyButtonAction());
        this.copyButton.setMnemonic('C');
        panel.add(this.copyButton);
        this.showDetailButton = new JButton(SHOW_DETAILS_BUTTON_LABEL);
        this.showDetailButton.addActionListener(new ShowDetailButtonAction());
        this.showDetailButton.setMnemonic('D');
        panel.add(this.showDetailButton);
        this.closeButton = new JButton(CLOSE_BUTTON_LABEL);
        this.closeButton.addActionListener(new CloseButtonAction());
        this.closeButton.setMnemonic('X');
        panel.add(this.closeButton);
        return panel;
    }

    static {
        icons.put(WARNING, UIManager.getIcon("OptionPane.warningIcon"));
        icons.put(ERROR, UIManager.getIcon("OptionPane.errorIcon"));
        icons.put(QUESTION, UIManager.getIcon("OptionPane.questionIcon"));
        icons.put(INFO, UIManager.getIcon("OptionPane.informationIcon"));
    }

    protected class MessagePaneGridBagConstraints
    extends GridBagConstraints {
        protected MessagePaneGridBagConstraints() {
        }

        public void setGridBounds(int x, int y, int width, int height) {
            this.gridx = x;
            this.gridy = y;
            this.gridwidth = width;
            this.gridheight = height;
        }

        public void setWeight(double weightx, double weighty) {
            this.weightx = weightx;
            this.weighty = weighty;
        }
    }

    protected class CopyButtonAction
    extends AbstractAction {
        protected CopyButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            UIMessagePane.this.details.selectAll();
            UIMessagePane.this.details.copy();
        }
    }

    protected class ShowDetailButtonAction
    extends AbstractAction {
        protected ShowDetailButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (UIMessagePane.this.isDetailShown) {
                UIMessagePane.this.subpanel.remove(UIMessagePane.this.detailsArea);
                UIMessagePane.this.isDetailShown = false;
                UIMessagePane.this.showDetailButton.setText(SHOW_DETAILS_BUTTON_LABEL);
            } else {
                UIMessagePane.this.subpanel.add((Component)UIMessagePane.this.detailsArea, "Center");
                UIMessagePane.this.showDetailButton.setText(HIDE_DETAILS_BUTTON_LABEL);
                UIMessagePane.this.isDetailShown = true;
            }
            ((JDialog)UIMessagePane.this.getTopLevelAncestor()).pack();
        }
    }

    protected class CloseButtonAction
    extends AbstractAction {
        protected CloseButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ((JDialog)UIMessagePane.this.getTopLevelAncestor()).dispose();
        }
    }
}

