/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.components.UIMessagePane;

public class UIProgressStatusDialog
extends UIMessagePane
implements Accessible {
    protected JDialog dialog = null;
    protected JProgressBar myBar = null;
    protected JTextArea noteLabel = null;
    protected Component parentComponent = null;
    protected String progressNote = null;
    protected JButton cancel = null;
    protected boolean isCanceled = false;
    protected boolean hasWarnings = false;
    protected boolean hasErrors = false;
    protected long T0 = 0L;
    protected int millisToDecideToPopup = 500;
    protected int millisToPopup = 2000;
    protected int min = 0;
    protected int max = 0;
    protected int progress = 0;

    public UIProgressStatusDialog(Component theParent, String abbreviatedMsg, String progressNoteMessage, Icon theIcon, int minVal, int maxVal) {
        super(abbreviatedMsg, "", theIcon);
        this.parentComponent = theParent;
        this.progressNote = progressNoteMessage;
        this.min = minVal;
        this.max = maxVal;
        this.T0 = System.currentTimeMillis();
    }

    @Override
    protected void initComponent(String abbreviatedMsg, String detailedMsg, Icon theIcon) {
        this.abbrMsg = abbreviatedMsg;
        this.detailMsg = detailedMsg;
        this.icon = theIcon;
    }

    @Override
    public JDialog createDialog(Component owner) {
        JDialog dialog = super.createDialog(owner);
        dialog.setTitle("SynTree export dialog");
        dialog.getRootPane().setDefaultButton(this.showDetailButton);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                UIProgressStatusDialog.this.isCanceled = true;
            }
        });
        return dialog;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public JButton getCancelButton() {
        return this.cancel;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int nv) {
        this.progress = nv;
        if (this.progress >= this.max) {
            if (!this.isCanceled && !this.hasWarnings) {
                this.close();
            } else if (this.myBar != null) {
                this.myBar.setValue(this.progress);
            }
        } else if (this.myBar != null) {
            this.myBar.setValue(this.progress);
        } else {
            long T = System.currentTimeMillis();
            long dT = (int)(T - this.T0);
            if (dT >= (long)this.millisToDecideToPopup) {
                int predictedCompletionTime = 0;
                predictedCompletionTime = this.progress > this.min ? (int)(dT * (long)(this.max - this.min) / (long)(this.progress - this.min)) : this.millisToPopup;
                if (predictedCompletionTime >= this.millisToPopup) {
                    this.showDialog();
                }
            }
        }
    }

    public void showDialog() {
        this.myBar = new JProgressBar();
        this.myBar.setMinimum(this.min);
        this.myBar.setMaximum(this.max);
        this.myBar.setValue(this.progress);
        if (this.progressNote != null) {
            this.noteLabel = new JTextArea(this.progressNote);
            this.noteLabel.setColumns(45);
            this.noteLabel.setFont(new JLabel().getFont());
            this.noteLabel.setForeground(new JLabel().getForeground());
            this.noteLabel.setOpaque(false);
            this.noteLabel.setEditable(false);
            this.noteLabel.setLineWrap(true);
        }
        super.initComponent(this.abbrMsg, this.detailMsg, this.icon);
        this.closeButton.setEnabled(false);
        JPanel topPanel = (JPanel)this.getComponent(0);
        topPanel.removeAll();
        topPanel.setLayout(new GridBagLayout());
        UIMessagePane.MessagePaneGridBagConstraints constraints = new UIMessagePane.MessagePaneGridBagConstraints();
        constraints.setWeight(0.0, 0.0);
        constraints.anchor = 10;
        constraints.fill = 1;
        constraints.setGridBounds(0, 0, 1, 3);
        JLabel iconLabel = new JLabel(this.icon);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        topPanel.add((Component)iconLabel, constraints);
        constraints.anchor = 17;
        constraints.setGridBounds(1, 0, 1, 1);
        JLabel abbrLabel = new JLabel(this.abbrMsg);
        abbrLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        topPanel.add((Component)abbrLabel, constraints);
        constraints.setGridBounds(1, 1, 1, 1);
        constraints.fill = 2;
        this.myBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        topPanel.add((Component)this.myBar, constraints);
        constraints.setGridBounds(2, 1, 1, 1);
        this.cancel = new JButton(UIIcons.addImageIcon("icons/lc_delete_18.png"));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIProgressStatusDialog.this.isCanceled = true;
            }
        });
        this.cancel.setPreferredSize(new Dimension(26, 26));
        topPanel.add((Component)this.cancel, constraints);
        constraints.setGridBounds(1, 2, 1, 1);
        topPanel.add((Component)this.noteLabel, constraints);
        this.dialog = this.createDialog(this.parentComponent);
        this.dialog.setVisible(true);
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.myBar = null;
            this.cancel = null;
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int m) {
        if (this.myBar != null) {
            this.myBar.setMinimum(m);
        }
        this.min = m;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int m) {
        if (this.myBar != null) {
            this.myBar.setMaximum(m);
        }
        this.max = m;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public void setMillisToDecideToPopup(int millisToDecideToPopup) {
        this.millisToDecideToPopup = millisToDecideToPopup;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String note) {
        this.progressNote = note;
        this.detailMsg = this.detailMsg + "Info: " + note + "\n";
        if (this.noteLabel != null) {
            this.noteLabel.setText(note);
            JScrollPane scrollPane = (JScrollPane)this.detailsArea.getComponent(1);
            JTextArea details = (JTextArea)scrollPane.getViewport().getView();
            details.append("Info: " + note + "\n");
        }
    }

    public String getNote() {
        return this.progressNote;
    }

    public void showWarning(String message) {
        if (this.myBar == null) {
            this.showDialog();
        }
        if (!this.isDetailShown) {
            new UIMessagePane.ShowDetailButtonAction().actionPerformed(null);
        }
        JScrollPane scrollPane = (JScrollPane)this.detailsArea.getComponent(1);
        JTextArea details = (JTextArea)scrollPane.getViewport().getView();
        details.append("Warning: " + message + "\n");
        this.detailMsg = this.detailMsg + message + "\n";
        this.hasWarnings = true;
    }

    public void showException(Exception error) {
        if (this.myBar == null) {
            this.showDialog();
        }
        if (!this.isDetailShown) {
            new UIMessagePane.ShowDetailButtonAction().actionPerformed(null);
        }
        this.progressNote = "An error occurred and exporting was aborted. See below for details.";
        this.noteLabel.setText(this.progressNote);
        String errorMessage = "Error: ";
        if (error.getMessage() == null) {
            errorMessage = errorMessage + "Unknown cause\n";
        }
        this.detailMsg = this.detailMsg + errorMessage;
        StringWriter writer = new StringWriter();
        error.printStackTrace(new PrintWriter(writer));
        writer.flush();
        errorMessage = errorMessage + writer.toString();
        this.detailMsg = this.detailMsg + errorMessage;
        JScrollPane scrollPane = (JScrollPane)this.detailsArea.getComponent(1);
        JTextArea details = (JTextArea)scrollPane.getViewport().getView();
        details.append(errorMessage + "\n");
        this.isCanceled = true;
        this.cancel.setEnabled(false);
        this.closeButton.setEnabled(true);
        this.hasErrors = true;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleProgressStatusDialog();
        }
        if (this.myBar != null && this.accessibleContext instanceof AccessibleProgressStatusDialog) {
            ((AccessibleProgressStatusDialog)this.accessibleContext).progressBarCreated();
        }
        return this.accessibleContext;
    }

    protected class AccessibleProgressStatusDialog
    extends AccessibleContext
    implements AccessibleText,
    ChangeListener,
    PropertyChangeListener {
        private Object oldModelValue;

        protected AccessibleProgressStatusDialog() {
        }

        private void progressBarCreated() {
            if (UIProgressStatusDialog.this.myBar != null) {
                UIProgressStatusDialog.this.myBar.addChangeListener(this);
            }
            if (UIProgressStatusDialog.this.noteLabel != null) {
                UIProgressStatusDialog.this.noteLabel.addPropertyChangeListener(this);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e == null) {
                return;
            }
            if (UIProgressStatusDialog.this.myBar != null) {
                Integer newModelValue = UIProgressStatusDialog.this.myBar.getValue();
                this.firePropertyChange("AccessibleValue", this.oldModelValue, newModelValue);
                this.oldModelValue = newModelValue;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == UIProgressStatusDialog.this.noteLabel && e.getPropertyName() == "text") {
                this.firePropertyChange("AccessibleText", null, 0);
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_MONITOR;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet set = null;
            if (UIProgressStatusDialog.this.dialog != null) {
                set = UIProgressStatusDialog.this.dialog.getAccessibleContext().getAccessibleStateSet();
            }
            return set;
        }

        @Override
        public int getAccessibleIndexInParent() {
            int index = -1;
            if (UIProgressStatusDialog.this.dialog != null) {
                index = UIProgressStatusDialog.this.dialog.getAccessibleContext().getAccessibleIndexInParent();
            }
            return index;
        }

        @Override
        public int getAccessibleChildrenCount() {
            AccessibleContext ac = this.getPanelAccessibleContext();
            if (ac != null) {
                return ac.getAccessibleChildrenCount();
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            AccessibleContext ac = this.getPanelAccessibleContext();
            if (ac != null) {
                return ac.getAccessibleChild(i);
            }
            return null;
        }

        private AccessibleContext getPanelAccessibleContext() {
            Container c;
            if (UIProgressStatusDialog.this.myBar != null && (c = UIProgressStatusDialog.this.myBar.getParent()) instanceof Accessible) {
                return ((Accessible)((Object)c)).getAccessibleContext();
            }
            return null;
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return UIProgressStatusDialog.this.getLocale();
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            AccessibleComponent component = null;
            if (UIProgressStatusDialog.this.dialog != null) {
                component = UIProgressStatusDialog.this.dialog.getAccessibleContext().getAccessibleComponent();
            }
            return component;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            if (UIProgressStatusDialog.this.myBar != null) {
                return UIProgressStatusDialog.this.myBar.getAccessibleContext().getAccessibleValue();
            }
            return null;
        }

        @Override
        public AccessibleText getAccessibleText() {
            if (this.getNoteLabelAccessibleText() != null) {
                return this;
            }
            return null;
        }

        private AccessibleText getNoteLabelAccessibleText() {
            if (UIProgressStatusDialog.this.noteLabel != null) {
                return UIProgressStatusDialog.this.noteLabel.getAccessibleContext().getAccessibleText();
            }
            return null;
        }

        @Override
        public int getIndexAtPoint(Point p) {
            Point noteLabelPoint;
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null && this.sameWindowAncestor(UIProgressStatusDialog.this, UIProgressStatusDialog.this.noteLabel) && (noteLabelPoint = SwingUtilities.convertPoint(UIProgressStatusDialog.this, p, UIProgressStatusDialog.this.noteLabel)) != null) {
                return at.getIndexAtPoint(noteLabelPoint);
            }
            return -1;
        }

        @Override
        public Rectangle getCharacterBounds(int i) {
            Rectangle noteLabelRect;
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null && this.sameWindowAncestor(UIProgressStatusDialog.this, UIProgressStatusDialog.this.noteLabel) && (noteLabelRect = at.getCharacterBounds(i)) != null) {
                return SwingUtilities.convertRectangle(UIProgressStatusDialog.this.noteLabel, noteLabelRect, UIProgressStatusDialog.this);
            }
            return null;
        }

        private boolean sameWindowAncestor(Component src, Component dest) {
            if (src == null || dest == null) {
                return false;
            }
            return SwingUtilities.getWindowAncestor(src) == SwingUtilities.getWindowAncestor(dest);
        }

        @Override
        public int getCharCount() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getCharCount();
            }
            return -1;
        }

        @Override
        public int getCaretPosition() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getCaretPosition();
            }
            return -1;
        }

        @Override
        public String getAtIndex(int part, int index) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getAtIndex(part, index);
            }
            return null;
        }

        @Override
        public String getAfterIndex(int part, int index) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getAfterIndex(part, index);
            }
            return null;
        }

        @Override
        public String getBeforeIndex(int part, int index) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getBeforeIndex(part, index);
            }
            return null;
        }

        @Override
        public AttributeSet getCharacterAttribute(int i) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getCharacterAttribute(i);
            }
            return null;
        }

        @Override
        public int getSelectionStart() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getSelectionStart();
            }
            return -1;
        }

        @Override
        public int getSelectionEnd() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getSelectionEnd();
            }
            return -1;
        }

        @Override
        public String getSelectedText() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getSelectedText();
            }
            return null;
        }
    }
}

