/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class UISymbolChooser
extends JFrame {
    private Font font = null;
    protected JLabel[][] chars;
    protected JTable charTable;
    protected JScrollPane scrollTable;
    protected JComboBox selectBlocks;
    protected int end = 65535;
    protected int columns = 8;
    protected String selectedSymbol;
    protected JPanel buttonPanel;
    protected JButton closeButton = new JButton("Close");
    protected JButton insertButton = new JButton("Insert");
    protected ActionListener okAction;

    public void setInsertAction(ActionListener al) {
        if (this.okAction != null) {
            this.insertButton.removeActionListener(this.okAction);
        }
        this.okAction = al;
        this.insertButton.addActionListener(al);
    }

    public UISymbolChooser(String title, String theFont, ActionListener okAction) {
        this.setTitle(title);
        ActionListener closeChooserFrame = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UISymbolChooser.this.setVisible(false);
                        UISymbolChooser.this.dispose();
                    }
                });
            }
        };
        this.closeButton.addActionListener(closeChooserFrame);
        this.insertButton.addActionListener(okAction);
        this.buttonPanel = new JPanel(new FlowLayout());
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(this.insertButton);
        this.changeFont(theFont);
        this.scrollTable.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Rectangle viewRect = UISymbolChooser.this.scrollTable.getViewport().getViewRect();
                int first = UISymbolChooser.this.charTable.rowAtPoint(new Point(0, viewRect.y));
                int last = UISymbolChooser.this.charTable.rowAtPoint(new Point(0, viewRect.y + viewRect.height - 1));
                if (first > UISymbolChooser.this.charTable.getSelectedRow()) {
                    UISymbolChooser.this.selectBlocks.setSelectedItem(UISymbolChooser.this.getReadableBlockName(Character.UnicodeBlock.of(UISymbolChooser.this.chars[first][UISymbolChooser.this.charTable.getSelectedColumn()].getText().charAt(0))));
                    UISymbolChooser.this.charTable.changeSelection(first, UISymbolChooser.this.charTable.getSelectedColumn(), false, false);
                }
                if (last < UISymbolChooser.this.charTable.getSelectedRow()) {
                    UISymbolChooser.this.selectBlocks.setSelectedItem(UISymbolChooser.this.getReadableBlockName(Character.UnicodeBlock.of(UISymbolChooser.this.chars[last][UISymbolChooser.this.charTable.getSelectedColumn()].getText().charAt(0))));
                    UISymbolChooser.this.charTable.changeSelection(last, UISymbolChooser.this.charTable.getSelectedColumn(), false, false);
                }
            }
        });
        this.add((Component)this.buttonPanel, "South");
        this.add((Component)this.scrollTable, "Center");
        this.add((Component)this.selectBlocks, "North");
        this.setPreferredSize(new Dimension(600, 515));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UISymbolChooser.this.scrollTable.requestFocusInWindow();
            }
        });
        this.pack();
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UISymbolChooser.this.setVisible(false);
                UISymbolChooser.this.dispose();
            }
        });
    }

    public void changeFont(String nwFont) {
        this.font = new Font(nwFont, 0, 18);
        ArrayList<Character> charsInFont = this.getCharsInFont();
        this.charTable = this.initCharacterTable(charsInFont);
        this.charTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    UISymbolChooser.this.okAction.actionPerformed(null);
                }
            }
        });
        if (this.scrollTable == null) {
            this.scrollTable = new JScrollPane(this.charTable);
        } else {
            this.scrollTable.getViewport().removeAll();
            this.scrollTable.getViewport().add(this.charTable);
            this.scrollTable.getViewport().revalidate();
        }
        ArrayList<String> unicodeBlocksInFont = this.getUnicodeBlocks(charsInFont);
        if (this.selectBlocks == null) {
            this.selectBlocks = new JComboBox<Object>(new DefaultComboBoxModel<Object>(unicodeBlocksInFont.toArray()));
        } else {
            this.selectBlocks.removeAllItems();
            this.selectBlocks.setModel(new DefaultComboBoxModel<Object>(unicodeBlocksInFont.toArray()));
            this.selectBlocks.revalidate();
        }
        this.selectBlocks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!UISymbolChooser.this.selectBlocks.hasFocus()) {
                    return;
                }
                String selectedBlock = UISymbolChooser.this.selectBlocks.getSelectedItem().toString();
                Boolean row = true;
                Boolean column = true;
                for (int i = 0; i < UISymbolChooser.this.chars.length && row.booleanValue(); ++i) {
                    for (int j = 0; j < UISymbolChooser.this.chars[i].length && column.booleanValue(); ++j) {
                        Character c = Character.valueOf(UISymbolChooser.this.chars[i][j].getText().charAt(0));
                        String thisBlock = UISymbolChooser.this.getReadableBlockName(Character.UnicodeBlock.of(c.charValue()));
                        if (!thisBlock.equals(selectedBlock)) continue;
                        UISymbolChooser.this.charTable.changeSelection(i, j, false, false);
                        row = false;
                        column = false;
                    }
                }
            }
        });
        this.selectBlocks.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UISymbolChooser.this.scrollTable.requestFocusInWindow();
                    }
                });
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }
        });
    }

    protected ArrayList<Character> getCharsInFont() {
        ArrayList<Character> charsInFont = new ArrayList<Character>();
        for (int i = 0; i <= this.end; ++i) {
            if (!this.font.canDisplay(i) || Character.isISOControl(i) || Character.isWhitespace(i)) continue;
            charsInFont.add(Character.valueOf((char)i));
        }
        return charsInFont;
    }

    protected ArrayList<String> getUnicodeBlocks(ArrayList<Character> chars) {
        ArrayList<String> unicodeBlocks = new ArrayList<String>();
        for (int i = 0; i <= chars.size() - 1; ++i) {
            String blockName = this.getReadableBlockName(Character.UnicodeBlock.of(chars.get(i).charValue()));
            if (unicodeBlocks.contains(blockName)) continue;
            unicodeBlocks.add(blockName);
        }
        return unicodeBlocks;
    }

    protected String getReadableBlockName(Character.UnicodeBlock block) {
        if (block == null) {
            return "<null>";
        }
        String blockName = block.toString();
        String readableBlockName = Character.toUpperCase(blockName.charAt(0)) + blockName.toLowerCase().replace("_", " ").substring(1);
        return readableBlockName;
    }

    protected JTable initCharacterTable(ArrayList<Character> charsInFont) {
        int length = charsInFont.size();
        int rows = length / this.columns;
        this.chars = new JLabel[rows][this.columns];
        int n = 0;
        for (int i = 0; i < this.chars.length; ++i) {
            for (int j = 0; j < this.chars[i].length; ++j) {
                String s = "" + charsInFont.get(n);
                this.chars[i][j] = new JLabel(s, 0);
                this.chars[i][j].setFont(this.font);
                ++n;
            }
        }
        Object[] columnNames = new String[this.columns];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = "" + i;
        }
        final Renderer renderer = new Renderer();
        JTable table = new JTable(this.chars, columnNames){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                return renderer;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        table.setRowHeight(50);
        table.setTableHeader(null);
        table.setRowSelectionAllowed(true);
        table.setColumnSelectionAllowed(true);
        table.setSelectionMode(0);
        table.changeSelection(0, 0, false, false);
        return table;
    }

    public String getSymbol() {
        return this.selectedSymbol;
    }

    public void setSymbol(String s) {
        this.selectedSymbol = s;
    }

    public JButton getInsertButton() {
        return this.insertButton;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public class Renderer
    extends DefaultTableCellRenderer {
        public void checkSelection(JTable t, JLabel l, boolean isSelected) {
            if (isSelected) {
                l.setBackground(t.getSelectionBackground());
                l.setForeground(t.getSelectionForeground());
                UISymbolChooser.this.setSymbol(l.getText());
                UISymbolChooser.this.selectBlocks.setSelectedItem(UISymbolChooser.this.getReadableBlockName(Character.UnicodeBlock.of(l.getText().charAt(0))));
            } else {
                l.setBackground(t.getBackground());
                l.setForeground(t.getForeground());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof JLabel) {
                JLabel label = (JLabel)value;
                label.setOpaque(true);
                this.checkSelection(table, label, isSelected);
                return label;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

