/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.rug.syntree.Settings;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.components.UIJToggleButtonWithIcon;

public class UITreeVisPane
extends JPanel
implements ActionListener,
ChangeListener {
    private HierarchicalController control;
    private JPanel visualizationPane;
    private JPanel optionPane;
    private JPanel optionLeftPane;
    private JPanel optionLeftUpperPane;
    private JPanel optionLeftLowerPane;
    private JPanel optionRightPane;
    private UIJToggleButtonWithIcon defaultRadio;
    private UIJToggleButtonWithIcon angulated1Radio;
    private UIJToggleButtonWithIcon angulated2Radio;
    private UIJToggleButtonWithIcon linkedRadio;
    private UIJToggleButtonWithIcon dendroRadio;
    private UIJToggleButtonWithIcon triangleRadio;
    ButtonGroup group;
    private UIJToggleButtonWithIcon lowerCheck;
    private UIJToggleButtonWithIcon angleCheck;
    private UIJToggleButtonWithIcon invertedCheck;
    private UIJToggleButtonWithIcon maxAngleCheck;
    private UIJToggleButtonWithIcon maxHeightCheck;
    private JSlider widthSlider;
    private JSlider heightSlider;
    private JSlider constantAngleSlider;
    private JSlider maxAngleSlider;
    private JSlider maxHeightSlider;
    private JLabel widthLabel;
    private JLabel heightLabel;
    private JLabel constantAngleLabel;
    private JLabel minHeightLabel;
    private JLabel maxHeightLabel;

    public UITreeVisPane(HierarchicalController control) {
        this.control = control;
        this.setLayout(new BoxLayout(this, 3));
        this.visualizationPane = new JPanel(new GridLayout(1, 5, 10, 0));
        this.optionPane = new JPanel(new GridLayout(1, 2));
        this.optionLeftPane = new JPanel(new GridLayout(2, 1, 10, 10));
        this.optionLeftUpperPane = new JPanel(new GridLayout(1, 2, 10, 10));
        this.optionLeftLowerPane = new JPanel(new GridLayout(1, 3, 10, 10));
        this.optionRightPane = new JPanel(new GridLayout(5, 1, 0, 10));
        this.add(this.visualizationPane);
        this.add(this.optionPane);
        this.optionPane.add(this.optionLeftPane);
        this.optionPane.add(this.optionRightPane);
        this.optionLeftPane.add(this.optionLeftUpperPane);
        this.optionLeftPane.add(this.optionLeftLowerPane);
        Border marginsBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Options");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.visualizationPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.optionPane.setBorder(new CompoundBorder(titleBorder, marginsBorder));
        this.optionRightPane.setBorder(BorderFactory.createEmptyBorder(0, 11, 17, 0));
        this.defaultRadio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_default.png"));
        this.defaultRadio.setToolTip("Default branches");
        this.angulated1Radio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_angulated1.png"));
        this.angulated1Radio.setToolTip("Angulated branches 1");
        this.angulated2Radio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_angulated2.png"));
        this.angulated2Radio.setToolTip("Angulated branches 2");
        this.linkedRadio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_linkedsister.png"));
        this.linkedRadio.setToolTip("Linked sister branches");
        this.dendroRadio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_dendrogram.png"));
        this.dendroRadio.setToolTip("Dendrogram branches");
        this.triangleRadio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/branch_triangle.png"));
        this.triangleRadio.setToolTip("Triangular branches");
        this.group = new ButtonGroup();
        this.defaultRadio.addToButtonGroup(this.group);
        this.angulated1Radio.addToButtonGroup(this.group);
        this.angulated2Radio.addToButtonGroup(this.group);
        this.linkedRadio.addToButtonGroup(this.group);
        this.dendroRadio.addToButtonGroup(this.group);
        this.triangleRadio.addToButtonGroup(this.group);
        this.visualizationPane.add(this.defaultRadio);
        this.visualizationPane.add(this.angulated1Radio);
        this.visualizationPane.add(this.angulated2Radio);
        this.visualizationPane.add(this.linkedRadio);
        this.visualizationPane.add(this.dendroRadio);
        this.visualizationPane.add(this.triangleRadio);
        this.defaultRadio.addActionListener(this);
        this.angulated1Radio.addActionListener(this);
        this.angulated2Radio.addActionListener(this);
        this.linkedRadio.addActionListener(this);
        this.dendroRadio.addActionListener(this);
        this.triangleRadio.addActionListener(this);
        this.lowerCheck = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/tree_lower_endnodes.png"));
        this.lowerCheck.setToolTip("Lower end nodes to the deepest level");
        this.invertedCheck = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/tree_inverted.png"));
        this.invertedCheck.setToolTip("Invert the tree");
        this.angleCheck = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/tree_anglify.png"));
        this.angleCheck.setToolTip("Set a constant angle between branches");
        this.maxAngleCheck = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/tree_max_angle.png"));
        this.maxAngleCheck.setToolTip("Set a maximum angle between branches, for wide (sub)trees");
        this.maxHeightCheck = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/tree_max_height.png"));
        this.maxHeightCheck.setToolTip("Set a maximum height margin between branches, for high (sub)trees");
        this.optionLeftUpperPane.add(this.lowerCheck);
        this.optionLeftUpperPane.add(this.invertedCheck);
        this.optionLeftLowerPane.add(this.angleCheck);
        this.optionLeftLowerPane.add(this.maxAngleCheck);
        this.optionLeftLowerPane.add(this.maxHeightCheck);
        this.lowerCheck.addActionListener(this);
        this.invertedCheck.addActionListener(this);
        this.angleCheck.addActionListener(this);
        this.maxAngleCheck.addActionListener(this);
        this.maxHeightCheck.addActionListener(this);
        Hashtable<Integer, JLabel> whTable = new Hashtable<Integer, JLabel>();
        for (int labelValue : new int[]{0, 100, 200, 300, 400, 500}) {
            JLabel label = new JLabel(Integer.toString(labelValue) + "%");
            whTable.put(labelValue, label);
            label.setFont(label.getFont().deriveFont(10.0f));
        }
        this.widthSlider = new JSlider(0, 500, Math.round(((Float)Settings.get("tv-horizontal-perc")).floatValue()));
        this.widthSlider.setToolTipText("Adjust the width margin % relative to the default width margin");
        this.widthSlider.setMajorTickSpacing(100);
        this.widthSlider.setMinorTickSpacing(50);
        this.widthSlider.setSnapToTicks(true);
        this.widthSlider.setPaintTicks(true);
        this.widthSlider.setLabelTable(whTable);
        this.widthSlider.setPaintLabels(true);
        this.heightSlider = new JSlider(0, 500, Math.round(((Float)Settings.get("tv-vertical-perc")).floatValue()));
        this.heightSlider.setToolTipText("Adjust the height margin % relative to the default height margin");
        this.heightSlider.setMajorTickSpacing(100);
        this.heightSlider.setMinorTickSpacing(50);
        this.heightSlider.setSnapToTicks(true);
        this.heightSlider.setPaintTicks(true);
        this.heightSlider.setLabelTable(whTable);
        this.heightSlider.setPaintLabels(true);
        this.constantAngleSlider = new JSlider(20, 180, Math.round(((Float)Settings.get("tv-constant-angle")).floatValue()));
        this.constantAngleSlider.setToolTipText("Adjust the angle in degrees");
        this.constantAngleSlider.setMajorTickSpacing(10);
        this.constantAngleSlider.setMinorTickSpacing(5);
        this.constantAngleSlider.setSnapToTicks(true);
        this.constantAngleSlider.setPaintTicks(true);
        Hashtable<Integer, JLabel> angTable = new Hashtable<Integer, JLabel>();
        for (int labelValue : new int[]{20, 40, 60, 80, 100, 120, 140, 160, 180}) {
            JLabel label = new JLabel(Integer.toString(labelValue));
            angTable.put(labelValue, label);
            label.setFont(label.getFont().deriveFont(9.0f));
        }
        this.constantAngleSlider.setLabelTable(angTable);
        this.constantAngleSlider.setPaintLabels(true);
        this.maxAngleSlider = new JSlider(20, 180, Math.round(((Float)Settings.get("tv-max-angle")).floatValue()));
        this.maxAngleSlider.setToolTipText("Adjust the maximum angle in degrees");
        this.maxAngleSlider.setMajorTickSpacing(10);
        this.maxAngleSlider.setMinorTickSpacing(5);
        this.maxAngleSlider.setSnapToTicks(true);
        this.maxAngleSlider.setPaintTicks(true);
        this.maxAngleSlider.setLabelTable(angTable);
        this.maxAngleSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> maxTable = new Hashtable<Integer, JLabel>();
        for (int labelValue : new int[]{100, 200, 300, 300, 400, 500}) {
            JLabel label = new JLabel(Integer.toString(labelValue) + "%");
            maxTable.put(labelValue, label);
            label.setFont(label.getFont().deriveFont(10.0f));
        }
        this.maxHeightSlider = new JSlider(100, 500, Math.round(((Float)Settings.get("tv-max-height")).floatValue()));
        this.maxHeightSlider.setToolTipText("Adjust the maximum height margin % relative to the current height margin");
        this.maxHeightSlider.setMajorTickSpacing(100);
        this.maxHeightSlider.setMinorTickSpacing(50);
        this.maxHeightSlider.setSnapToTicks(true);
        this.maxHeightSlider.setPaintTicks(true);
        this.maxHeightSlider.setLabelTable(maxTable);
        this.maxHeightSlider.setPaintLabels(true);
        this.widthLabel = new JLabel("width", 0);
        this.widthLabel.setAlignmentX(0.5f);
        this.widthLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.heightLabel = new JLabel("height", 0);
        this.heightLabel.setAlignmentX(0.5f);
        this.heightLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.constantAngleLabel = new JLabel("constant angle", 0);
        this.constantAngleLabel.setAlignmentX(0.5f);
        this.constantAngleLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.minHeightLabel = new JLabel("maximum angle", 0);
        this.minHeightLabel.setAlignmentX(0.5f);
        this.minHeightLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.maxHeightLabel = new JLabel("maximum height", 0);
        this.maxHeightLabel.setAlignmentX(0.5f);
        this.maxHeightLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.constantAngleSlider.setEnabled(false);
        this.constantAngleLabel.setEnabled(false);
        this.maxHeightSlider.setEnabled(false);
        this.maxHeightLabel.setEnabled(false);
        this.maxAngleSlider.setEnabled(false);
        this.minHeightLabel.setEnabled(false);
        this.optionRightPane.add(this.widthLabel);
        this.optionRightPane.add(this.widthSlider);
        this.optionRightPane.add(this.heightLabel);
        this.optionRightPane.add(this.heightSlider);
        this.optionRightPane.add(this.constantAngleLabel);
        this.optionRightPane.add(this.constantAngleSlider);
        this.optionRightPane.add(this.minHeightLabel);
        this.optionRightPane.add(this.maxAngleSlider);
        this.optionRightPane.add(this.maxHeightLabel);
        this.optionRightPane.add(this.maxHeightSlider);
        this.widthSlider.addChangeListener(this);
        this.heightSlider.addChangeListener(this);
        this.constantAngleSlider.addChangeListener(this);
        this.maxAngleSlider.addChangeListener(this);
        this.maxHeightSlider.addChangeListener(this);
        if (((Boolean)Settings.get("tv-set-constant-angle")).booleanValue()) {
            this.angleCheck.button.doClick();
        }
        if (((Boolean)Settings.get("tv-set-max-height")).booleanValue()) {
            this.maxHeightCheck.button.doClick();
        }
        if (((Boolean)Settings.get("tv-set-max-angle")).booleanValue()) {
            this.maxAngleCheck.button.doClick();
        }
        if (((Boolean)Settings.get("tv-inverted")).booleanValue()) {
            this.invertedCheck.button.doClick();
        }
        if (((Boolean)Settings.get("tv-lower-endnodes")).booleanValue()) {
            this.lowerCheck.button.doClick();
        }
        switch ((Settings.BranchType)((Object)Settings.get("tv-branch-type"))) {
            case DEFAULT: {
                this.defaultRadio.button.doClick();
                break;
            }
            case ANGULATED1: {
                this.angulated1Radio.button.doClick();
                break;
            }
            case ANGULATED2: {
                this.angulated2Radio.button.doClick();
                break;
            }
            case LINKEDSISTER: {
                this.linkedRadio.button.doClick();
                break;
            }
            case DENDROGRAM: {
                this.dendroRadio.button.doClick();
                break;
            }
            case TRIANGLE: {
                this.triangleRadio.button.doClick();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.defaultRadio.button) {
            Settings.set("tv-branch-type", (Serializable)((Object)Settings.BranchType.DEFAULT));
        } else if (e.getSource() == this.angulated1Radio.button) {
            Settings.set("tv-branch-type", (Serializable)((Object)Settings.BranchType.ANGULATED1));
        } else if (e.getSource() == this.angulated2Radio.button) {
            Settings.set("tv-branch-type", (Serializable)((Object)Settings.BranchType.ANGULATED2));
        } else if (e.getSource() == this.linkedRadio.button) {
            Settings.set("tv-branch-type", (Serializable)((Object)Settings.BranchType.LINKEDSISTER));
        } else if (e.getSource() == this.dendroRadio.button) {
            Settings.set("tv-branch-type", (Serializable)((Object)Settings.BranchType.DENDROGRAM));
        } else if (e.getSource() == this.triangleRadio.button) {
            Settings.set("tv-branch-type", (Serializable)((Object)Settings.BranchType.TRIANGLE));
        } else if (e.getSource() == this.lowerCheck.button) {
            if (this.lowerCheck.isSelected()) {
                Settings.set("tv-lower-endnodes", Boolean.valueOf(true));
            } else {
                Settings.set("tv-lower-endnodes", Boolean.valueOf(false));
            }
        } else if (e.getSource() == this.angleCheck.button) {
            if (this.angleCheck.isSelected()) {
                this.constantAngleSlider.setEnabled(true);
                this.constantAngleLabel.setEnabled(true);
                Settings.set("tv-set-constant-angle", Boolean.valueOf(true));
                this.heightSlider.setValue(this.widthSlider.getValue());
            } else {
                this.constantAngleSlider.setEnabled(false);
                this.constantAngleLabel.setEnabled(false);
                Settings.set("tv-set-constant-angle", Boolean.valueOf(false));
            }
        } else if (e.getSource() == this.invertedCheck.button) {
            if (this.invertedCheck.isSelected()) {
                Settings.set("tv-inverted", Boolean.valueOf(true));
                this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_default.png"));
            } else {
                Settings.set("tv-inverted", Boolean.valueOf(false));
                this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_inverted.png"));
            }
        } else if (e.getSource() == this.maxAngleCheck.button) {
            if (this.maxAngleCheck.isSelected()) {
                Settings.set("tv-set-max-angle", Boolean.valueOf(true));
                this.maxAngleSlider.setEnabled(true);
                this.minHeightLabel.setEnabled(true);
            } else {
                Settings.set("tv-set-max-angle", Boolean.valueOf(false));
                this.maxAngleSlider.setEnabled(false);
                this.minHeightLabel.setEnabled(false);
            }
        } else if (e.getSource() == this.maxHeightCheck.button) {
            if (this.maxHeightCheck.isSelected()) {
                Settings.set("tv-set-max-height", Boolean.valueOf(true));
                this.maxHeightSlider.setEnabled(true);
                this.maxHeightLabel.setEnabled(true);
            } else {
                Settings.set("tv-set-max-height", Boolean.valueOf(false));
                this.maxHeightSlider.setEnabled(false);
                this.maxHeightLabel.setEnabled(false);
            }
        }
        if (e.getSource() == this.defaultRadio.button) {
            this.angleCheck.setAllEnabled(true);
            this.maxAngleCheck.setAllEnabled(true);
            this.maxHeightCheck.setAllEnabled(true);
        } else if (e.getSource() == this.angulated1Radio.button || e.getSource() == this.angulated2Radio.button || e.getSource() == this.linkedRadio.button || e.getSource() == this.dendroRadio.button || e.getSource() == this.triangleRadio.button) {
            if (this.angleCheck.isSelected()) {
                this.angleCheck.button.doClick();
            }
            if (this.maxAngleCheck.isSelected()) {
                this.maxAngleCheck.button.doClick();
            }
            if (this.maxHeightCheck.isSelected()) {
                this.maxHeightCheck.button.doClick();
            }
            this.angleCheck.setAllEnabled(false);
            this.maxAngleCheck.setAllEnabled(false);
            this.maxHeightCheck.setAllEnabled(false);
        }
        this.control.update(null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (source == this.widthSlider) {
            if (((Boolean)Settings.get("tv-constant-angle")).booleanValue()) {
                this.heightSlider.removeChangeListener(this);
                this.heightSlider.setValue(source.getValue());
                this.heightSlider.addChangeListener(this);
            }
            if (!source.getValueIsAdjusting()) {
                Settings.set("tv-horizontal-perc", Float.valueOf(source.getValue()));
                this.control.update(null);
            }
        } else if (source == this.heightSlider) {
            if (((Boolean)Settings.get("tv-set-constant-angle")).booleanValue()) {
                this.widthSlider.removeChangeListener(this);
                this.widthSlider.setValue(source.getValue());
                this.widthSlider.addChangeListener(this);
            }
            if (!source.getValueIsAdjusting()) {
                if (((Boolean)Settings.get("tv-set-constant-angle")).booleanValue()) {
                    Settings.set("tv-horizontal-perc", Float.valueOf(source.getValue()));
                } else {
                    Settings.set("tv-vertical-perc", Float.valueOf(source.getValue()));
                }
                this.control.update(null);
            }
        } else if (source == this.constantAngleSlider) {
            if (!source.getValueIsAdjusting()) {
                Settings.set("tv-constant-angle", Float.valueOf(source.getValue()));
                this.control.update(null);
            }
        } else if (source == this.maxAngleSlider) {
            if (!source.getValueIsAdjusting()) {
                Settings.set("tv-max-angle", Float.valueOf(source.getValue()));
                this.control.update(null);
            }
        } else if (source == this.maxHeightSlider && !source.getValueIsAdjusting()) {
            Settings.set("tv-max-height", Float.valueOf(source.getValue()));
            this.control.update(null);
        }
    }
}

