/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.components;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import nl.rug.syntree.Settings;
import nl.rug.syntree.mainview.components.ActionSupport;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.treediagram.TreeView;

public class VisMenu
extends JMenu {
    private TreeView tv;

    private Object getSetting(String key) {
        return this.tv.getSetting(key);
    }

    private void setSetting(String key, Serializable val) {
        this.tv.setSetting(key, val);
    }

    public VisMenu(TreeView tv) {
        this.tv = tv;
        this.setText("");
        this.setIcon(UIIcons.addImageIcon(((Settings.BranchType)((Object)this.tv.getSetting("tv-branch-type"))).icon()));
        for (Settings.BranchType bt : Settings.BranchType.values()) {
            this.add(ActionSupport.makeMenuItem(new VisAction(this.tv, bt)));
        }
    }

    private class VisAction
    extends AbstractAction
    implements Observer {
        private TreeView tv;
        private Settings.BranchType bt;

        public VisAction(TreeView tv, Settings.BranchType bt) {
            this.tv = tv;
            this.bt = bt;
            this.putValue("Name", bt.title());
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon(bt.icon()));
            this.putValue("SmallIcon", UIIcons.addImageIcon(bt.icon()));
            this.putValue("ActionSupport-choosable", true);
            this.putValue("SwingSelectedKey", VisMenu.this.getSetting("tv-branch-type").equals((Object)this.bt));
            if (this.tv == null) {
                throw new Error("this.tv");
            }
            if (this.tv.getModel() == null) {
                throw new Error("this.tv.getModel()");
            }
            this.tv.getModel().addObserver(this);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.tv.getController().invokeLater(new Runnable(){

                @Override
                public void run() {
                    VisMenu.this.setSetting("tv-branch-type", (Serializable)((Object)VisAction.this.bt));
                }
            });
        }

        @Override
        public void update(Observable obs, Object arg) {
            Settings.BranchType bt = (Settings.BranchType)((Object)VisMenu.this.getSetting("tv-branch-type"));
            VisMenu.this.setIcon(UIIcons.addImageIcon(bt.icon()));
            this.putValue("SwingSelectedKey", bt.equals((Object)this.bt));
        }
    }
}

