/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.menus;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import nl.rug.syntree.Settings;
import nl.rug.syntree.bracketstructure.BracketView;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.components.UIToolbarButton;

public class BracketVisMenu
extends JMenuBar
implements ActionListener {
    private BracketView bview;
    private HierarchicalController controller;
    private JMenu bracketMenu;
    private JPanel notationPanel;
    private JPanel bracketTypePanel;
    private JPanel subscriptPanel;
    private JRadioButton bracketOption1Btn;
    private JRadioButton bracketOption2Btn;
    private JRadioButton bracketOption3Btn;
    private JRadioButton bracketOption4Btn;
    private JCheckBox subscriptChBx;
    private JCheckBox nodeBackgroundColourChBx;
    private JCheckBox branchBackgroundColourChBx;

    public BracketVisMenu(BracketView bview) {
        this.bview = bview;
        this.controller = this.bview.getController();
        this.bracketMenu = new JMenu();
        this.bracketMenu.setIcon(UIIcons.addImageIcon("icons/preferences.png"));
        this.add(this.bracketMenu);
        this.bracketMenu.setBorder(BorderFactory.createEmptyBorder());
        this.bracketMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                BracketVisMenu.this.setBackground(Settings.UI_BTN_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                BracketVisMenu.this.setBackground(Settings.UI_BTN_BG);
            }
        });
        this.notationPanel = new JPanel(new GridLayout(3, 1));
        Border marginsBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Notation");
        this.notationPanel.setBorder(new CompoundBorder(titleBorder, marginsBorder));
        this.bracketTypePanel = new JPanel(new FlowLayout(3, 10, 10));
        this.bracketTypePanel.add(new JLabel("Bracket type"));
        ButtonGroup bracketGroup = new ButtonGroup();
        this.bracketOption1Btn = new JRadioButton("[,]");
        bracketGroup.add(this.bracketOption1Btn);
        this.bracketTypePanel.add(this.bracketOption1Btn);
        this.bracketOption2Btn = new JRadioButton("{,}");
        bracketGroup.add(this.bracketOption2Btn);
        this.bracketTypePanel.add(this.bracketOption2Btn);
        this.bracketOption3Btn = new JRadioButton("(,)");
        bracketGroup.add(this.bracketOption3Btn);
        this.bracketTypePanel.add(this.bracketOption3Btn);
        this.bracketOption4Btn = new JRadioButton("<,>");
        bracketGroup.add(this.bracketOption4Btn);
        this.bracketTypePanel.add(this.bracketOption4Btn);
        this.notationPanel.add(this.bracketTypePanel);
        this.subscriptPanel = new JPanel(new FlowLayout(3, 10, 10));
        this.subscriptPanel.add(new JLabel("Parent node subscript"));
        this.subscriptChBx = new JCheckBox();
        this.subscriptPanel.add(this.subscriptChBx);
        this.subscriptPanel.add(new JLabel("Show background colour of nodes"));
        this.nodeBackgroundColourChBx = new JCheckBox();
        this.subscriptPanel.add(this.nodeBackgroundColourChBx);
        this.subscriptPanel.add(new JLabel("Show background colour of branches"));
        this.branchBackgroundColourChBx = new JCheckBox();
        this.subscriptPanel.add(this.branchBackgroundColourChBx);
        this.notationPanel.add(this.subscriptPanel);
        this.initializeComponents();
        this.bracketOption1Btn.addActionListener(this);
        this.bracketOption2Btn.addActionListener(this);
        this.bracketOption3Btn.addActionListener(this);
        this.bracketOption4Btn.addActionListener(this);
        this.subscriptChBx.addActionListener(this);
        this.nodeBackgroundColourChBx.addActionListener(this);
        this.branchBackgroundColourChBx.addActionListener(this);
        this.setBackground(Settings.UI_BTN_BG);
        this.setBorder(UIToolbarButton.BTNBORDER);
    }

    private void initializeComponents() {
        String bracketType = (String)this.bview.getSetting("bv-bracket-type-open");
        if (bracketType.equals("[")) {
            this.bracketOption1Btn.setSelected(true);
        } else if (bracketType.equals("{")) {
            this.bracketOption2Btn.setSelected(true);
        } else if (bracketType.equals("(")) {
            this.bracketOption3Btn.setSelected(true);
        } else {
            this.bracketOption4Btn.setSelected(true);
        }
        this.subscriptChBx.setSelected((Boolean)this.bview.getSetting("bv-bracket-parent-subscript"));
        this.nodeBackgroundColourChBx.setSelected((Boolean)this.bview.getSetting("bv-show-node-background-colour-enabled"));
        this.branchBackgroundColourChBx.setSelected((Boolean)this.bview.getSetting("bv-show-branches-background-colour-enabled"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.bracketOption1Btn)) {
            this.changeBracketType("[", "]");
        } else if (e.getSource().equals(this.bracketOption2Btn)) {
            this.changeBracketType("{", "}");
        } else if (e.getSource().equals(this.bracketOption3Btn)) {
            this.changeBracketType("(", ")");
        } else if (e.getSource().equals(this.bracketOption4Btn)) {
            this.changeBracketType("<", ">");
        } else if (e.getSource().equals(this.subscriptChBx)) {
            this.bview.setSetting("bv-bracket-parent-subscript", Boolean.valueOf(this.subscriptChBx.isSelected()));
        } else if (e.getSource().equals(this.nodeBackgroundColourChBx)) {
            this.bview.setSetting("bv-show-node-background-colour-enabled", Boolean.valueOf(this.subscriptChBx.isSelected()));
        } else if (e.getSource().equals(this.branchBackgroundColourChBx)) {
            this.bview.setSetting("bv-show-branches-background-colour-enabled", Boolean.valueOf(this.subscriptChBx.isSelected()));
        }
        this.controller.update(null);
    }

    private void changeBracketType(String open, String close) {
        this.bview.setSetting("bv-bracket-type-open", (Serializable)((Object)open));
        this.bview.setSetting("bv-bracket-type-close", (Serializable)((Object)close));
    }
}

