/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.menus;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import nl.rug.syntree.bracketstructure.BracketView;
import nl.rug.syntree.mainview.components.ActionSupport;
import nl.rug.syntree.mainview.components.UIIcons;

public class ParentMenu
extends JMenu {
    private BracketView bv;

    public ParentMenu(BracketView bv) {
        this.bv = bv;
        this.setIcon(UIIcons.addImageIcon("icons/brackets-parent-sub.png"));
        this.add(ActionSupport.makeMenuItem(new BaselineAction("Baseline", false, false)));
        this.add(ActionSupport.makeMenuItem(new BaselineAction("Superscript", false, true)));
        this.add(ActionSupport.makeMenuItem(new BaselineAction("Subscript", true, false)));
        this.add(ActionSupport.makeMenuItem(new BoldAction()));
        this.add(ActionSupport.makeMenuItem(new ItalicAction()));
    }

    private class ItalicAction
    extends AbstractAction
    implements Observer {
        public ItalicAction() {
            this.putValue("Name", "Italic");
            this.putValue("ActionSupport-togglable", true);
            this.putValue("SwingSelectedKey", ParentMenu.this.bv.getSetting("bv-parent-italic"));
            ParentMenu.this.bv.getModel().addObserver(this);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ParentMenu.this.bv.setSetting("bv-parent-italic", (Boolean)this.getValue("SwingSelectedKey"));
        }

        @Override
        public void update(Observable obs, Object arg) {
            this.putValue("SwingSelectedKey", ParentMenu.this.bv.getSetting("bv-parent-italic"));
        }
    }

    private class BoldAction
    extends AbstractAction
    implements Observer {
        public BoldAction() {
            this.putValue("Name", "Bold");
            this.putValue("ActionSupport-togglable", true);
            this.putValue("SwingSelectedKey", ParentMenu.this.bv.getSetting("bv-parent-bold"));
            ParentMenu.this.bv.getModel().addObserver(this);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ParentMenu.this.bv.setSetting("bv-parent-bold", (Boolean)this.getValue("SwingSelectedKey"));
        }

        @Override
        public void update(Observable obs, Object arg) {
            this.putValue("SwingSelectedKey", ParentMenu.this.bv.getSetting("bv-parent-bold"));
        }
    }

    private class BaselineAction
    extends AbstractAction
    implements Observer {
        private boolean sub;
        private boolean sup;

        public BaselineAction(String title, boolean sub, boolean sup) {
            this.sub = sub;
            this.sup = sup;
            this.putValue("Name", title);
            this.putValue("ActionSupport-choosable", true);
            ParentMenu.this.bv.getModel().addObserver(this);
            this.update(null, null);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ParentMenu.this.bv.getModel().setSetting("bv-parent-sub", Boolean.valueOf(this.sub));
            ParentMenu.this.bv.getModel().setSetting("bv-parent-super", Boolean.valueOf(this.sup));
            ParentMenu.this.bv.getController().update(null);
        }

        @Override
        public void update(Observable obj, Object arg) {
            boolean sub = (Boolean)ParentMenu.this.bv.getSetting("bv-parent-sub");
            boolean sup = (Boolean)ParentMenu.this.bv.getSetting("bv-parent-super");
            this.putValue("SwingSelectedKey", sub == this.sub && sup == this.sup);
        }
    }
}

