/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.rug.syntree.Settings;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.components.UIJToggleButtonWithIcon;
import nl.rug.syntree.mainview.components.UIToolbarButton;
import nl.rug.syntree.treediagram.TreeView;

public class TreeVisMenu
extends JMenuBar
implements ActionListener,
ChangeListener {
    private JMenu optionMenu;
    private JMenu visMenu;
    public UIJToggleButtonWithIcon defaultRadio;
    public UIJToggleButtonWithIcon angulated1Radio;
    public UIJToggleButtonWithIcon angulated2Radio;
    public UIJToggleButtonWithIcon linkedRadio;
    public UIJToggleButtonWithIcon dendroRadio;
    public UIJToggleButtonWithIcon triangleRadio;
    private ButtonGroup group;
    private UIJToggleButtonWithIcon vertRadio;
    private UIJToggleButtonWithIcon horizRadio;
    private ButtonGroup vhGroup;
    public UIJToggleButtonWithIcon lowerCheck;
    public UIJToggleButtonWithIcon angleCheck;
    public UIJToggleButtonWithIcon invertedCheck;
    public UIJToggleButtonWithIcon maxAngleCheck;
    public UIJToggleButtonWithIcon maxHeightCheck;
    private JPanel angleMenuItem;
    private JPanel minHMenuItem;
    private JPanel maxHMenuItem;
    private JPanel ilMenuItem;
    private JPanel vhMenuItem;
    private JPanel wMenuItem;
    private JPanel hMenuItem;
    public JSlider widthSlider;
    public JSlider heightSlider;
    public JSlider constantAngleSlider;
    public JSlider maxAngleSlider;
    public JSlider maxHeightSlider;
    private JLabel widthLabel;
    private JLabel heightLabel;
    private HierarchicalController control;
    private TreeView tv;

    private Object getSetting(String key) {
        return this.tv.getSetting(key);
    }

    private void setSetting(String key, Serializable value) {
        this.tv.setSetting(key, value);
    }

    public TreeVisMenu(TreeView tv) {
        this.tv = tv;
        this.control = tv.getController();
        this.visMenu = new JMenu("");
        this.visMenu.setIcon(UIIcons.addImageIcon("icons/tree_default.png"));
        this.optionMenu = new JMenu("Options");
        this.optionMenu.setToolTipText("Options for the selected tree visualization");
        this.add(this.optionMenu);
        this.setBorder(UIToolbarButton.BTNBORDER);
        this.visMenu.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(Settings.UI_BTN_BG);
        this.visMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                TreeVisMenu.this.setBackground(Settings.UI_BTN_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                TreeVisMenu.this.setBackground(Settings.UI_BTN_BG);
            }
        });
        this.defaultRadio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_default.png"));
        this.defaultRadio.setToolTip("Default branches");
        this.defaultRadio.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.angulated1Radio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_angulated1.png"));
        this.angulated1Radio.setToolTip("Angulated branches 1");
        this.angulated1Radio.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.angulated2Radio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_angulated2.png"));
        this.angulated2Radio.setToolTip("Angulated branches 2");
        this.angulated2Radio.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.linkedRadio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_linkedsister.png"));
        this.linkedRadio.setToolTip("Linked sister branches");
        this.linkedRadio.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.dendroRadio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_dendrogram.png"));
        this.dendroRadio.setToolTip("Dendrogram branches");
        this.dendroRadio.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.triangleRadio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/branch_triangle.png"));
        this.triangleRadio.setToolTip("Triangular branches");
        this.triangleRadio.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.vertRadio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_default.png"));
        this.vertRadio.setToolTip("Vertical trees");
        this.vertRadio.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.horizRadio = new UIJToggleButtonWithIcon(new JRadioButton(), UIIcons.addImageIcon("icons/tree_left.png"));
        this.horizRadio.setToolTip("Horizontal trees");
        this.horizRadio.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.group = new ButtonGroup();
        this.defaultRadio.addToButtonGroup(this.group);
        this.angulated1Radio.addToButtonGroup(this.group);
        this.angulated2Radio.addToButtonGroup(this.group);
        this.linkedRadio.addToButtonGroup(this.group);
        this.dendroRadio.addToButtonGroup(this.group);
        this.triangleRadio.addToButtonGroup(this.group);
        this.vhGroup = new ButtonGroup();
        this.vertRadio.addToButtonGroup(this.vhGroup);
        this.horizRadio.addToButtonGroup(this.vhGroup);
        this.defaultRadio.addActionListener(this);
        this.angulated1Radio.addActionListener(this);
        this.angulated2Radio.addActionListener(this);
        this.linkedRadio.addActionListener(this);
        this.dendroRadio.addActionListener(this);
        this.triangleRadio.addActionListener(this);
        this.vertRadio.addActionListener(this);
        this.horizRadio.addActionListener(this);
        this.lowerCheck = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/tree_lower_endnodes.png"));
        this.lowerCheck.setToolTip("Lower end nodes to the deepest level");
        this.lowerCheck.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.invertedCheck = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/tree_inverted.png"));
        this.invertedCheck.setToolTip("Invert the tree");
        this.invertedCheck.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.angleCheck = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/tree_anglify.png"));
        this.angleCheck.setToolTip("Set a constant angle between branches");
        this.angleCheck.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.maxAngleCheck = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/tree_max_angle.png"));
        this.maxAngleCheck.setToolTip("Set a maximum angle between branches, for wide (sub)trees");
        this.maxAngleCheck.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.maxHeightCheck = new UIJToggleButtonWithIcon(new JCheckBox(), UIIcons.addImageIcon("icons/tree_max_height.png"));
        this.maxHeightCheck.setToolTip("Set a maximum height margin between branches, for high (sub)trees");
        this.maxHeightCheck.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.lowerCheck.addActionListener(this);
        this.invertedCheck.addActionListener(this);
        this.angleCheck.addActionListener(this);
        this.maxAngleCheck.addActionListener(this);
        this.maxHeightCheck.addActionListener(this);
        Hashtable<Integer, JLabel> whTable = new Hashtable<Integer, JLabel>();
        for (int labelValue : new int[]{0, 100, 200, 300, 400, 500}) {
            JLabel label = new JLabel(Integer.toString(labelValue) + "%");
            whTable.put(labelValue, label);
            label.setFont(label.getFont().deriveFont(10.0f));
        }
        this.widthSlider = new JSlider(0, 500, Math.round(((Float)this.getSetting("tv-horizontal-perc")).floatValue()));
        this.widthSlider.setToolTipText("Adjust the width margin % relative to the default width margin");
        this.widthSlider.setMajorTickSpacing(100);
        this.widthSlider.setMinorTickSpacing(50);
        this.widthSlider.setSnapToTicks(true);
        this.widthSlider.setPaintTicks(true);
        this.widthSlider.setLabelTable(whTable);
        this.widthSlider.setPaintLabels(true);
        this.heightSlider = new JSlider(0, 500, Math.round(((Float)this.getSetting("tv-vertical-perc")).floatValue()));
        this.heightSlider.setToolTipText("Adjust the height margin % relative to the default height margin");
        this.heightSlider.setMajorTickSpacing(100);
        this.heightSlider.setMinorTickSpacing(50);
        this.heightSlider.setSnapToTicks(true);
        this.heightSlider.setPaintTicks(true);
        this.heightSlider.setLabelTable(whTable);
        this.heightSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> angTable = new Hashtable<Integer, JLabel>();
        for (int labelValue : new int[]{20, 40, 60, 80, 100, 120, 140, 160, 180}) {
            JLabel label = new JLabel(Integer.toString(labelValue));
            angTable.put(labelValue, label);
            label.setFont(label.getFont().deriveFont(9.0f));
        }
        this.constantAngleSlider = new JSlider(20, 180, Math.round(((Float)this.getSetting("tv-constant-angle")).floatValue()));
        this.constantAngleSlider.setToolTipText("Adjust the angle in degrees");
        this.constantAngleSlider.setMajorTickSpacing(10);
        this.constantAngleSlider.setMinorTickSpacing(5);
        this.constantAngleSlider.setSnapToTicks(true);
        this.constantAngleSlider.setPaintTicks(true);
        this.constantAngleSlider.setLabelTable(angTable);
        this.constantAngleSlider.setPaintLabels(true);
        this.maxAngleSlider = new JSlider(20, 180, Math.round(((Float)this.getSetting("tv-max-angle")).floatValue()));
        this.maxAngleSlider.setToolTipText("Adjust the maximum angle in degrees");
        this.maxAngleSlider.setMajorTickSpacing(10);
        this.maxAngleSlider.setMinorTickSpacing(5);
        this.maxAngleSlider.setSnapToTicks(true);
        this.maxAngleSlider.setPaintTicks(true);
        this.maxAngleSlider.setLabelTable(angTable);
        this.maxAngleSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> maxTable = new Hashtable<Integer, JLabel>();
        for (int labelValue : new int[]{100, 200, 300, 300, 400, 500}) {
            JLabel label = new JLabel(Integer.toString(labelValue) + "%");
            maxTable.put(labelValue, label);
            label.setFont(label.getFont().deriveFont(10.0f));
        }
        this.maxHeightSlider = new JSlider(100, 500, Math.round(((Float)this.getSetting("tv-max-height")).floatValue()));
        this.maxHeightSlider.setToolTipText("Adjust the maximum height margin % relative to the current height margin");
        this.maxHeightSlider.setMajorTickSpacing(100);
        this.maxHeightSlider.setMinorTickSpacing(50);
        this.maxHeightSlider.setSnapToTicks(true);
        this.maxHeightSlider.setPaintTicks(true);
        this.maxHeightSlider.setLabelTable(maxTable);
        this.maxHeightSlider.setPaintLabels(true);
        this.constantAngleSlider.setEnabled(false);
        this.maxHeightSlider.setEnabled(false);
        this.maxAngleSlider.setEnabled(false);
        this.widthSlider.addChangeListener(this);
        this.heightSlider.addChangeListener(this);
        this.constantAngleSlider.addChangeListener(this);
        this.maxAngleSlider.addChangeListener(this);
        this.maxHeightSlider.addChangeListener(this);
        this.widthLabel = new JLabel("width", 0);
        this.widthLabel.setAlignmentX(0.5f);
        this.widthLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.heightLabel = new JLabel("height", 0);
        this.heightLabel.setAlignmentX(0.5f);
        this.heightLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.vhMenuItem = new JPanel();
        this.vhMenuItem.add(this.vertRadio);
        this.vhMenuItem.add(this.horizRadio);
        this.ilMenuItem = new JPanel();
        this.ilMenuItem.add(this.invertedCheck);
        this.ilMenuItem.add(this.lowerCheck);
        this.wMenuItem = new JPanel();
        this.wMenuItem.add(this.widthLabel);
        this.wMenuItem.add(this.widthSlider);
        this.hMenuItem = new JPanel();
        this.hMenuItem.add(this.heightLabel);
        this.hMenuItem.add(this.heightSlider);
        this.angleMenuItem = new JPanel();
        this.angleMenuItem.add(this.angleCheck);
        this.angleMenuItem.add(this.constantAngleSlider);
        this.minHMenuItem = new JPanel();
        this.minHMenuItem.add(this.maxAngleCheck);
        this.minHMenuItem.add(this.maxAngleSlider);
        this.maxHMenuItem = new JPanel();
        this.maxHMenuItem.add(this.maxHeightCheck);
        this.maxHMenuItem.add(this.maxHeightSlider);
        this.optionMenu.add(this.vhMenuItem);
        this.optionMenu.add(this.ilMenuItem);
        this.optionMenu.addSeparator();
        this.optionMenu.add(this.wMenuItem);
        this.optionMenu.add(this.hMenuItem);
        this.optionMenu.addSeparator();
        this.optionMenu.add(this.angleMenuItem);
        this.optionMenu.add(this.minHMenuItem);
        this.optionMenu.add(this.maxHMenuItem);
        this.visMenu.add(this.defaultRadio);
        this.visMenu.add(this.angulated1Radio);
        this.visMenu.add(this.angulated2Radio);
        this.visMenu.add(this.linkedRadio);
        this.visMenu.add(this.dendroRadio);
        this.visMenu.add(this.triangleRadio);
        this.visMenu.addSeparator();
        this.visMenu.add(this.optionMenu);
        if (((Boolean)this.getSetting("tv-horizontal")).booleanValue()) {
            this.horizRadio.button.doClick();
        } else {
            this.vertRadio.button.doClick();
        }
        if (((Boolean)this.getSetting("tv-set-constant-angle")).booleanValue()) {
            this.angleCheck.button.doClick();
        }
        if (((Boolean)this.getSetting("tv-set-max-height")).booleanValue()) {
            this.maxHeightCheck.button.doClick();
        }
        if (((Boolean)this.getSetting("tv-set-max-angle")).booleanValue()) {
            this.maxAngleCheck.button.doClick();
        }
        if (((Boolean)this.getSetting("tv-inverted")).booleanValue()) {
            this.invertedCheck.button.doClick();
        }
        if (((Boolean)this.getSetting("tv-lower-endnodes")).booleanValue()) {
            this.lowerCheck.button.doClick();
        }
        switch ((Settings.BranchType)((Object)this.getSetting("tv-branch-type"))) {
            case DEFAULT: {
                this.defaultRadio.button.doClick();
                break;
            }
            case ANGULATED1: {
                this.angulated1Radio.button.doClick();
                break;
            }
            case ANGULATED2: {
                this.angulated2Radio.button.doClick();
                break;
            }
            case LINKEDSISTER: {
                this.linkedRadio.button.doClick();
                break;
            }
            case DENDROGRAM: {
                this.dendroRadio.button.doClick();
                break;
            }
            case TRIANGLE: {
                this.triangleRadio.button.doClick();
            }
        }
        boolean invert = (Boolean)this.getSetting("tv-inverted");
        boolean horiz = (Boolean)this.getSetting("tv-horizontal");
        if (horiz && invert) {
            this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_right.png"));
        } else if (horiz && !invert) {
            this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_left.png"));
        } else if (!horiz && invert) {
            this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_inverted.png"));
        } else if (!horiz && !invert) {
            this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_default.png"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.defaultRadio.button) {
            this.setSetting("tv-branch-type", (Serializable)((Object)Settings.BranchType.DEFAULT));
        } else if (e.getSource() == this.angulated1Radio.button) {
            this.setSetting("tv-branch-type", (Serializable)((Object)Settings.BranchType.ANGULATED1));
        } else if (e.getSource() == this.angulated2Radio.button) {
            this.setSetting("tv-branch-type", (Serializable)((Object)Settings.BranchType.ANGULATED2));
        } else if (e.getSource() == this.linkedRadio.button) {
            this.setSetting("tv-branch-type", (Serializable)((Object)Settings.BranchType.LINKEDSISTER));
        } else if (e.getSource() == this.dendroRadio.button) {
            this.setSetting("tv-branch-type", (Serializable)((Object)Settings.BranchType.DENDROGRAM));
        } else if (e.getSource() == this.triangleRadio.button) {
            this.setSetting("tv-branch-type", (Serializable)((Object)Settings.BranchType.TRIANGLE));
        } else if (e.getSource() == this.lowerCheck.button) {
            this.setSetting("tv-lower-endnodes", Boolean.valueOf(this.lowerCheck.isSelected()));
        } else if (e.getSource() == this.angleCheck.button) {
            this.constantAngleSlider.setEnabled(this.angleCheck.isSelected());
            this.setSetting("tv-set-constant-angle", Boolean.valueOf(this.angleCheck.isSelected()));
            if (this.angleCheck.isSelected()) {
                this.heightSlider.setValue(this.widthSlider.getValue());
            }
        } else if (e.getSource() == this.invertedCheck.button) {
            this.setSetting("tv-inverted", Boolean.valueOf(this.invertedCheck.isSelected()));
            if (this.invertedCheck.isSelected()) {
                this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_default.png"));
            } else {
                this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_inverted.png"));
            }
        } else if (e.getSource() == this.maxAngleCheck.button) {
            this.setSetting("tv-set-max-angle", Boolean.valueOf(this.maxAngleCheck.isSelected()));
            this.maxAngleSlider.setEnabled(this.maxAngleCheck.isSelected());
        } else if (e.getSource() == this.maxHeightCheck.button) {
            this.setSetting("tv-set-max-height", Boolean.valueOf(this.maxHeightCheck.isSelected()));
            this.maxHeightSlider.setEnabled(this.maxHeightCheck.isSelected());
        } else if (e.getSource() == this.vertRadio.button) {
            this.setSetting("tv-horizontal", Boolean.valueOf(false));
        } else if (e.getSource() == this.horizRadio.button) {
            this.setSetting("tv-horizontal", Boolean.valueOf(true));
        }
        boolean invert = (Boolean)this.getSetting("tv-inverted");
        boolean horiz = (Boolean)this.getSetting("tv-horizontal");
        if (horiz && invert) {
            this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_right.png"));
        } else if (horiz && !invert) {
            this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_left.png"));
        } else if (!horiz && invert) {
            this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_inverted.png"));
        } else if (!horiz && !invert) {
            this.invertedCheck.setImage(UIIcons.addImageIcon("icons/tree_default.png"));
        }
        if (e.getSource() == this.defaultRadio.button) {
            this.angleCheck.setAllEnabled(true);
            this.maxAngleCheck.setAllEnabled(true);
            this.maxHeightCheck.setAllEnabled(true);
        } else if (e.getSource() == this.angulated1Radio.button || e.getSource() == this.angulated2Radio.button || e.getSource() == this.linkedRadio.button || e.getSource() == this.dendroRadio.button || e.getSource() == this.triangleRadio.button) {
            if (this.angleCheck.isSelected()) {
                this.angleCheck.button.doClick();
            }
            if (this.maxAngleCheck.isSelected()) {
                this.maxAngleCheck.button.doClick();
            }
            if (this.maxHeightCheck.isSelected()) {
                this.maxHeightCheck.button.doClick();
            }
            this.angleCheck.setAllEnabled(false);
            this.maxAngleCheck.setAllEnabled(false);
            this.maxHeightCheck.setAllEnabled(false);
        }
        switch ((Settings.BranchType)((Object)this.getSetting("tv-branch-type"))) {
            case DEFAULT: {
                this.visMenu.setIcon(UIIcons.addImageIcon("icons/tree_default.png"));
                break;
            }
            case ANGULATED1: {
                this.visMenu.setIcon(UIIcons.addImageIcon("icons/tree_angulated1.png"));
                break;
            }
            case ANGULATED2: {
                this.visMenu.setIcon(UIIcons.addImageIcon("icons/tree_angulated2.png"));
                break;
            }
            case LINKEDSISTER: {
                this.visMenu.setIcon(UIIcons.addImageIcon("icons/tree_linkedsister.png"));
                break;
            }
            case DENDROGRAM: {
                this.visMenu.setIcon(UIIcons.addImageIcon("icons/tree_dendrogram.png"));
                break;
            }
            case TRIANGLE: {
                this.visMenu.setIcon(UIIcons.addImageIcon("icons/branch_triangle.png"));
            }
        }
        this.control.update(null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (source == this.widthSlider) {
            if (((Boolean)this.getSetting("tv-set-constant-angle")).booleanValue()) {
                this.heightSlider.removeChangeListener(this);
                this.heightSlider.setValue(source.getValue());
                this.heightSlider.addChangeListener(this);
            }
            if (!source.getValueIsAdjusting()) {
                this.setSetting("tv-horizontal-perc", Float.valueOf(source.getValue()));
                this.control.update(null);
            }
        } else if (source == this.heightSlider) {
            if (((Boolean)this.getSetting("tv-set-constant-angle")).booleanValue()) {
                this.widthSlider.removeChangeListener(this);
                this.widthSlider.setValue(source.getValue());
                this.widthSlider.addChangeListener(this);
            }
            if (!source.getValueIsAdjusting()) {
                if (((Boolean)this.getSetting("tv-set-constant-angle")).booleanValue()) {
                    this.setSetting("tv-horizontal-perc", Float.valueOf(source.getValue()));
                } else {
                    this.setSetting("tv-vertical-perc", Float.valueOf(source.getValue()));
                }
                this.control.update(null);
            }
        } else if (source == this.constantAngleSlider) {
            if (!source.getValueIsAdjusting()) {
                this.setSetting("tv-constant-angle", Float.valueOf(source.getValue()));
                this.control.update(null);
            }
        } else if (source == this.maxAngleSlider) {
            if (!source.getValueIsAdjusting()) {
                this.setSetting("tv-max-angle", Float.valueOf(source.getValue()));
                this.control.update(null);
            }
        } else if (source == this.maxHeightSlider && !source.getValueIsAdjusting()) {
            this.setSetting("tv-max-height", Float.valueOf(source.getValue()));
            this.control.update(null);
        }
    }
}

