/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.toolbars;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import nl.rug.syntree.Settings;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.mainview.components.FormatActions;
import nl.rug.syntree.mainview.components.UIToggleToolbarButton;
import nl.rug.syntree.mainview.components.UIToolbarButton;

public class FormatToolBar
extends JToolBar {
    private JComboBox<String> fontFaceBox;
    private JComboBox<Integer> fontSizeBox;

    public FormatToolBar(HierarchicalController control) {
        this.initButtons();
    }

    private void initButtons() {
        this.fontFaceBox = new JComboBox();
        for (String f : FormatActions.getFontFaces()) {
            this.fontFaceBox.addItem(f);
        }
        this.fontFaceBox.setSelectedItem(Settings.get("font-face"));
        this.fontFaceBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String f = (String)FormatToolBar.this.fontFaceBox.getSelectedItem();
                Action act = FormatActions.getFontFaceAction(f);
                if (act != null) {
                    act.actionPerformed(ae);
                }
            }
        });
        this.fontFaceBox.setBackground(Settings.UI_BTN_BG);
        this.fontFaceBox.setBorder(UIToolbarButton.BTNBORDER);
        this.fontFaceBox.setFocusable(false);
        this.fontFaceBox.setMaximumSize(this.fontFaceBox.getPreferredSize());
        this.add(this.fontFaceBox);
        this.fontSizeBox = new JComboBox();
        for (Integer i : FormatActions.getFontSizes()) {
            this.fontSizeBox.addItem(i);
        }
        this.fontSizeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Integer i = (Integer)FormatToolBar.this.fontSizeBox.getSelectedItem();
                Action act = FormatActions.getFontSizeAction(i);
                if (act != null) {
                    act.actionPerformed(ae);
                }
            }
        });
        this.fontSizeBox.setSelectedItem(32);
        this.fontSizeBox.setBackground(Settings.UI_BTN_BG);
        this.fontSizeBox.setBorder(UIToolbarButton.BTNBORDER);
        this.fontSizeBox.setFocusable(false);
        this.fontSizeBox.setMaximumSize(this.fontSizeBox.getPreferredSize());
        this.add(this.fontSizeBox);
        this.add(this.mkBtn(FormatActions.getFontColourAction()));
        this.add(this.mkBtn(FormatActions.getBackgroundColourAction()));
        this.add(this.mkToggleBtn(FormatActions.getBoldAction()));
        this.add(this.mkToggleBtn(FormatActions.getItalicAction()));
        this.add(this.mkToggleBtn(FormatActions.getUnderlineAction()));
        this.add(this.mkToggleBtn(FormatActions.getStrikethroughAction()));
        this.add(this.mkToggleBtn(FormatActions.getSubscriptAction()));
        this.add(this.mkToggleBtn(FormatActions.getSuperscriptAction()));
        this.add(this.mkBtn(FormatActions.getSmallCapsAction()));
        this.add(this.mkBtn(FormatActions.getInsertSymbolAction()));
        this.add(this.mkToggleBtn(FormatActions.getAlignLeftAction()));
        this.add(this.mkToggleBtn(FormatActions.getAlignCenterAction()));
        this.add(this.mkToggleBtn(FormatActions.getAlignRightAction()));
    }

    private UIToolbarButton mkBtn(Action act) {
        UIToolbarButton ret = new UIToolbarButton(act);
        ret.setText("");
        ret.setFocusable(false);
        return ret;
    }

    private UIToggleToolbarButton mkToggleBtn(Action act) {
        UIToggleToolbarButton ret = new UIToggleToolbarButton(act);
        ret.setText("");
        ret.setFocusable(false);
        return ret;
    }
}

