/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.toolbars;

import java.util.Collection;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.actions.AddTreeAction;
import nl.rug.syntree.hierarchicalmodel.actions.BranchShapeAction;
import nl.rug.syntree.hierarchicalmodel.actions.BranchStyleAction;
import nl.rug.syntree.mainview.components.UIToggleToolbarButton;
import nl.rug.syntree.mainview.components.UIToolbarButton;
import nl.rug.syntree.treediagram.TreeControl;

public class ModelToolBar
extends JToolBar {
    private HierarchicalController controller;
    private TreeControl treeControl;
    private JButton undoBtn;
    private JButton redoBtn;
    private JToggleButton branchTypeBtn;
    private JButton branchStyleBtn;

    public ModelToolBar(HierarchicalController controller, TreeControl treeControl) {
        this.controller = controller;
        this.treeControl = treeControl;
        this.initButtons();
    }

    private void addAll(Collection<Action> col) {
        for (Action act : col) {
            UIToolbarButton btn = new UIToolbarButton(act);
            this.add(btn);
        }
    }

    private void initButtons() {
        for (Action action : this.controller.getModelActions()) {
            UIToolbarButton btn = new UIToolbarButton(action);
            this.add(btn);
            if (!(action instanceof AddTreeAction)) continue;
            this.addSeparator();
        }
        this.add(new UIToolbarButton(this.controller.getStyleActions().get(0)));
        this.addSeparator();
        this.addAll(this.controller.getEditActions());
        this.addSeparator();
        this.branchStyleBtn = new UIToolbarButton(new BranchStyleAction(this.controller));
        this.add(this.branchStyleBtn);
        this.branchTypeBtn = new UIToggleToolbarButton(new BranchShapeAction(this.controller));
        this.add(this.branchTypeBtn);
        this.addSeparator();
        this.add(new UIToggleToolbarButton(this.treeControl.getHideAction()));
    }
}

