/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.mainview.toolbars;

import java.awt.Color;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeListener;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.toolbars.UIColorChooserFrame;

public class UIColourChooserJButton
extends JButton {
    protected JDialog jColourChooserDialog = null;
    protected CompoundBorder highlightedBorder = null;
    protected JColorChooser jColourChooser = null;
    protected boolean isModalColourChooser = false;
    protected String colourChooserTitle = null;
    protected UIColorChooserFrame chooserFrame = null;
    private Color defaultColor = null;

    public UIColourChooserJButton(String jColourChooserTitle, String icon, Color color) {
        super(jColourChooserTitle, UIIcons.addImageIcon(icon));
        this.colourChooserTitle = jColourChooserTitle;
        this.defaultColor = color;
        this.jColourChooser = new JColorChooser(this.defaultColor);
        this.isModalColourChooser = true;
    }

    public Color getColor() {
        return this.jColourChooser.getColor();
    }

    public void setColor(Color theColor) {
        this.jColourChooser.setColor(theColor);
    }

    public boolean isColorChooserDialogModal() {
        return this.isModalColourChooser;
    }

    public void setModalColorChooserDialog(boolean isModal) {
        this.isModalColourChooser = isModal;
    }

    public String getHexadecimalColor() {
        return "#" + Integer.toHexString(this.jColourChooser.getColor().getRGB()).substring(2, 8);
    }

    public void setHexadecimalColor(String hexadecimalColor) {
        int r = Integer.parseInt(hexadecimalColor.substring(1, 3), 16);
        int g = Integer.parseInt(hexadecimalColor.substring(3, 5), 16);
        int b = Integer.parseInt(hexadecimalColor.substring(5, 7), 16);
        Color color = new Color(r, g, b);
        this.jColourChooser.setColor(color);
    }

    public void addColorChangeListener(ChangeListener listener) {
        this.jColourChooser.getSelectionModel().addChangeListener(listener);
    }

    public void removeColorChangeListener(ChangeListener listener) {
        this.jColourChooser.getSelectionModel().addChangeListener(listener);
    }

    public String getChooserDialogTitle() {
        return this.colourChooserTitle;
    }

    public JColorChooser getJColourChooser() {
        return this.jColourChooser;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color color) {
        this.defaultColor = color;
    }

    public UIColorChooserFrame getChooserFrame() {
        return this.chooserFrame;
    }

    public void setChooserFrame(UIColorChooserFrame frame) {
        this.chooserFrame = frame;
    }
}

