/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram;

import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import nl.rug.syntree.hierarchicalmodel.nodecontent.DocumentContent;
import nl.rug.syntree.hierarchicalmodel.undoableedits.LabelEdit;
import nl.rug.syntree.mainview.Editor;
import nl.rug.syntree.treediagram.TreeInteractor;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.texteditor.SVGEditorPane;
import nl.rug.syntree.treediagram.texteditor.SVGScrollPane;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.Overlay;

public class EditLabelOverlay
extends InteractorAdapter
implements Overlay,
Editor,
TreeInteractor {
    private SVGEditorPane editorPane;
    private SVGScrollPane scrollPane;
    private TreeView tv;
    private SVGOMElement elm;
    private DocumentContent oldContent;
    private DocumentContent content;

    public EditLabelOverlay(TreeView tv, SVGOMElement elm, DocumentContent content) {
        this.tv = tv;
        this.elm = elm;
        this.content = content;
        this.oldContent = content.createCopy();
        GraphicsNode gnode = this.tv.getUpdateManager().getBridgeContext().getGraphicsNode(this.elm);
        Shape shape = gnode.getGlobalTransform().createTransformedShape(gnode.getBounds());
        shape = this.tv.getRenderingTransform().createTransformedShape(shape);
        this.scrollPane = new SVGScrollPane(this.tv, shape.getBounds2D());
        this.editorPane = new SVGEditorPane(tv, this.scrollPane, content);
        this.scrollPane.setEditor(this.editorPane);
        this.scrollPane.add(this.editorPane, 0, 0);
    }

    @Override
    public void end() {
        System.out.println("Invoking editorend " + Thread.currentThread().getName());
        System.out.println("Ending Editlabeloverlay");
        this.tv.removeJGVTComponentListener(this.scrollPane);
        this.editorPane.end();
        this.scrollPane.remove(this.editorPane);
        this.tv.remove(this.scrollPane);
        this.scrollPane.repaint();
        this.tv.getOverlays().remove(this);
        this.tv.getInteractors().remove(this);
        this.elm.removeAttributeNS(null, "visibility");
        this.tv.requestFocusInWindow();
        this.tv.getMainframe().setCurrentEditor(null);
        this.content.layoutCharacters();
        this.tv.getController().invokeLater(new Runnable(){

            @Override
            public void run() {
                EditLabelOverlay.this.tv.getController().update(new LabelEdit(EditLabelOverlay.this.content, EditLabelOverlay.this.oldContent));
            }
        });
        System.out.println("current Editer " + this.tv.getMainframe().getCurrentEditor());
        System.out.println("ELO end");
    }

    @Override
    public boolean endInteraction() {
        return true;
    }

    @Override
    public void focus() {
        this.editorPane.requestFocusInWindow();
    }

    public DocumentContent getContent() {
        return this.editorPane.getContent();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        System.out.println("Mouseclicked");
        this.end();
    }

    @Override
    public void paint(Graphics g) {
        if (this.scrollPane != null) {
            // empty if block
        }
    }

    public void start() {
        this.content.layoutParagraphs();
        this.tv.addJGVTComponentListener(this.scrollPane);
        this.scrollPane.resize();
        this.scrollPane.reposition();
        this.tv.add(this.scrollPane);
        this.tv.repaint();
        this.tv.getMainframe().setCurrentEditor(this);
        this.editorPane.requestFocusInWindow();
        this.editorPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isShiftDown() && e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                    e.consume();
                    EditLabelOverlay.this.end();
                }
            }
        });
        this.editorPane.setCaretPosition(this.editorPane.getDocument().getLength());
        this.elm.setAttributeNS(null, "visibility", "hidden");
    }

    @Override
    public boolean startInteraction(InputEvent ie) {
        return true;
    }
}

