/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram;

import java.util.ArrayList;
import java.util.Vector;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.treediagram.TreePositioner;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.DrawableObject;

public class HorizontalPositioner
extends TreePositioner {
    public HorizontalPositioner(TreeView tv) {
        super(tv);
    }

    private float computeHeight(HierarchicalNode node, float offset, float margin) {
        DrawableObject dro = this.tv.getDrawable(node);
        float ownHeight = dro.getBounds().height;
        float height = 0.0f;
        float y = 0.0f;
        if (node.hasChildren()) {
            Vector<HierarchicalNode> nextNodes = this.getNextNodes(node);
            float localMargin = node.isCollapsed() ? 0.0f : margin;
            for (HierarchicalNode next : nextNodes) {
                height += this.computeHeight(next, offset + height, margin) + localMargin;
            }
            height -= localMargin;
            float lastChildY = this.getPos((HierarchicalNode)nextNodes.lastElement()).y;
            float firstChildY = this.getPos((HierarchicalNode)nextNodes.firstElement()).y;
            float subHeight = lastChildY - firstChildY;
            if (ownHeight > subHeight) {
                HierarchicalNode firstOffspring = node.getTerminals().firstElement();
                float shiftHeight = this.getPos((HierarchicalNode)nextNodes.firstElement()).y - this.getPos((HierarchicalNode)firstOffspring).y;
                float firstChildHeight = this.getBounds((HierarchicalNode)firstOffspring).height;
                for (HierarchicalNode next : nextNodes) {
                    this.shiftTreeY(next, (ownHeight - subHeight) / 2.0f - shiftHeight - firstChildHeight / 2.0f);
                }
                y = offset + ownHeight / 2.0f;
                height = ownHeight;
            } else {
                y = subHeight / 2.0f + firstChildY;
            }
        } else {
            height = ownHeight;
            y = height / 2.0f + offset;
        }
        Position.Pnt pos = this.getPos(node);
        pos.y = y + this.getOffset((HierarchicalNode)node).x;
        return height;
    }

    private ArrayList<Float> computeMaxWidths(HierarchicalNode root) {
        ArrayList<Float> ret = new ArrayList<Float>();
        return this.computeMaxWidths(root, ret);
    }

    private ArrayList<Float> computeMaxWidths(HierarchicalNode node, ArrayList<Float> maxWidths) {
        float ownWidth = this.getBounds((HierarchicalNode)node).width;
        int depth = node.getDepth();
        while (maxWidths.size() < depth + 1) {
            maxWidths.add(Float.valueOf(0.0f));
        }
        maxWidths.set(depth, Float.valueOf(Math.max(ownWidth, maxWidths.get(depth).floatValue())));
        for (HierarchicalNode child : this.getNextNodes(node)) {
            this.computeMaxWidths(child, maxWidths);
        }
        return maxWidths;
    }

    private void invertTree(HierarchicalNode node, boolean inverted) {
        Position.Pnt p = this.getPos(node);
        if (inverted) {
            p.x *= -1.0f;
        } else {
            p.y *= -1.0f;
        }
        for (HierarchicalNode child : this.getNextNodes(node)) {
            this.invertTree(child, inverted);
        }
    }

    private void shiftTreeY(HierarchicalNode node, float delta) {
        this.getPos((HierarchicalNode)node).y += delta;
        for (HierarchicalNode child : this.getNextNodes(node)) {
            this.shiftTreeY(child, delta);
        }
    }

    @Override
    public float computeHeight() {
        float ret = ((Float)this.tv.getSetting("tv-offset-x")).floatValue();
        for (HierarchicalNode root : this.tv.getModel().getRootNodes()) {
            ret += this.computeHeight(root, ret, this.getVerticalMargin()) + this.getVerticalMargin();
        }
        return ret - this.getVerticalMargin();
    }

    @Override
    public float computeWidth() {
        float width = 0.0f;
        for (HierarchicalNode root : this.tv.getModel().getRootNodes()) {
            ArrayList<Float> maxWidths = this.computeMaxWidths(root);
            width = Math.max(this.computeWidth(root, maxWidths, ((Float)this.tv.getSetting("tv-offset-y")).floatValue(), this.getHorizontalMargin()), width);
        }
        return width;
    }

    public float computeWidth(HierarchicalNode node, ArrayList<Float> maxWidths, float offset, float margin) {
        int depth = node.getDepth();
        float ownWidth = this.tv.getDrawable((HierarchicalObject)node).getBounds().width;
        float width = offset + ownWidth;
        for (HierarchicalNode child : this.getNextNodes(node)) {
            width = Math.max(this.computeWidth(child, maxWidths, offset + margin + maxWidths.get(depth).floatValue(), margin), width);
        }
        float x = ownWidth / 2.0f + offset;
        this.getPos((HierarchicalNode)node).x = x + this.getOffset((HierarchicalNode)node).y;
        return width;
    }

    @Override
    public void invertTree(boolean inverted) {
        for (HierarchicalNode root : this.tv.getModel().getRootNodes()) {
            this.invertTree(root, inverted);
        }
    }

    @Override
    public void lowerEndNodes() {
        boolean invert = this.tv.isInverted();
        for (HierarchicalNode root : this.tv.getModel().getRootNodes()) {
            Position.Pnt p;
            Vector<HierarchicalNode> endNodes = root.getTerminals();
            float tgtX = invert ? Float.MAX_VALUE : Float.MIN_VALUE;
            for (HierarchicalNode node : endNodes) {
                p = this.getPos(node);
                if (invert) {
                    tgtX = Math.min(p.x, tgtX);
                    continue;
                }
                tgtX = Math.max(p.x, tgtX);
            }
            for (HierarchicalNode node : endNodes) {
                p = this.getPos(node);
                p.x = tgtX;
            }
        }
    }
}

