/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.undo.CompoundEdit;
import nl.rug.syntree.Settings;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.ArrowHead;
import nl.rug.syntree.hierarchicalmodel.annotations.Document;
import nl.rug.syntree.hierarchicalmodel.annotations.Hidden;
import nl.rug.syntree.hierarchicalmodel.annotations.Line;
import nl.rug.syntree.hierarchicalmodel.annotations.Mark;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.hierarchicalmodel.annotations.Strike;
import nl.rug.syntree.hierarchicalmodel.annotations.TreeOffset;
import nl.rug.syntree.hierarchicalmodel.undoableedits.CurvEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.StrikeEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.TweakEdit;
import nl.rug.syntree.mainview.components.ActionGroup;
import nl.rug.syntree.mainview.components.FormatActions;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.activities.Anchorizer;
import nl.rug.syntree.treediagram.activities.TreeMover;
import nl.rug.syntree.treediagram.drawables.DrawableDocument;
import nl.rug.syntree.treediagram.drawables.DrawableNode;
import nl.rug.syntree.treediagram.drawables.DrawableObject;

public class TreeControl {
    private TreeView tv;
    private Vector<ActionGroup> changeThicknessActions;
    private Vector<Action> toolbarActions;
    private ActionGroup addStrikeActions;
    private ActionGroup changeStrikeActions;
    private ActionGroup annotationActions;
    private ActionGroup curvActions;
    private ActionGroup arrowActions;
    private ActionGroup annoEditActions;
    private ActionGroup treeStyleActions;
    private AddPosAction addPosAct;
    private AnchorizeAction anchorizeAct;
    private ArrowEndAction arrowEndAct;
    private ArrowStartAction arrowStartAct;
    private ColourAction colourAct;
    private DocumentAction docAct;
    private EditLabelAction editLabAct;
    private HideAction hideAct;
    private LineAction lineAct;
    private MarkEllipsAction markEllipsAct;
    private MarkRectAction markRectAct;
    private MoveNodeAction moveNodeAct;
    private QuickLineAction quickLineAct;
    private ResetPositionAction resetPosAct;
    private FlipStrikeAction flipStrikeAct;
    private StrikeAction strikeLineAct;

    public TreeControl(TreeView tv) {
        this.tv = tv;
        this.initActions();
    }

    private void addAnnotation(HierarchicalObject an, Position.Pnt p) {
        this.tv.getController().startCompoundEdit();
        this.tv.getController().addAnnotation(an);
        if (p != null) {
            this.tv.startUserPositioning(an, p);
        } else {
            this.getController().update(this.getController().endCompoundEdit());
        }
    }

    private Position.Pnt getAnchor() {
        HierarchicalObject obj = this.tv.getController().getFirstSelectedObject();
        DrawableObject dro = null;
        Position.Pnt ret = null;
        System.out.println("TC gA: obj = " + obj + ", selPos = " + this.tv.getSelectedPos());
        ret = this.tv.getSelectedPos() != null ? new Position.Pnt(this.tv.getSelectedPos(), this.tv.getSelectedPosObj().that()) : (obj != null && (dro = this.tv.getDrawable(obj)) != null ? new Position.Pnt(dro.getPos().centerPos(), obj) : new Position.Pnt(null, null));
        return ret;
    }

    private void initActions() {
        this.changeThicknessActions = new Vector();
        for (int i = 2; i < 13; ++i) {
            this.changeThicknessActions.add(new ActionGroup(new LineThicknessAction(this, i)));
        }
        this.addStrikeActions = new ActionGroup("Add strike", null);
        this.strikeLineAct = new StrikeAction(this, Strike.StrikeStyles.Line);
        this.addStrikeActions.add("Add strike", this.strikeLineAct);
        this.addStrikeActions.add("Add strike", new StrikeAction(this, Strike.StrikeStyles.DoubleLine));
        this.addStrikeActions.add("Add strike", new StrikeAction(this, Strike.StrikeStyles.Cross));
        this.addStrikeActions.add("Add strike", new StrikeAction(this, Strike.StrikeStyles.CircledLine));
        this.changeStrikeActions = new ActionGroup("Change strike", null);
        this.changeStrikeActions.add("Change strike", new ChangeStrikeAction(this, Strike.StrikeStyles.Line));
        this.changeStrikeActions.add("Change strike", new ChangeStrikeAction(this, Strike.StrikeStyles.DoubleLine));
        this.changeStrikeActions.add("Change strike", new ChangeStrikeAction(this, Strike.StrikeStyles.Cross));
        this.changeStrikeActions.add("Change strike", new ChangeStrikeAction(this, Strike.StrikeStyles.CircledLine));
        this.curvActions = new ActionGroup("Curve", null);
        this.curvActions.add("Curve", new CurveNoneAction(this));
        this.curvActions.add("Curve", new CurveQuadraticAction(this));
        this.curvActions.add("Curve", new CurveCubicAction(this));
        this.addPosAct = new AddPosAction(this);
        this.anchorizeAct = new AnchorizeAction(this);
        this.arrowEndAct = new ArrowEndAction(this);
        this.arrowStartAct = new ArrowStartAction(this);
        this.colourAct = new ColourAction(this);
        this.docAct = new DocumentAction(this);
        this.editLabAct = new EditLabelAction(this);
        this.hideAct = new HideAction(this);
        this.lineAct = new LineAction(this);
        this.markEllipsAct = new MarkEllipsAction(this);
        this.markRectAct = new MarkRectAction(this);
        this.moveNodeAct = new MoveNodeAction(this);
        this.quickLineAct = new QuickLineAction(this);
        this.flipStrikeAct = new FlipStrikeAction(this);
        this.resetPosAct = new ResetPositionAction(this);
        this.arrowActions = new ActionGroup("Arrow-head", null);
        this.arrowActions.add("Arrow-head", this.arrowStartAct);
        this.arrowActions.add("Arrow-head", this.arrowEndAct);
        this.annotationActions = new ActionGroup("Add annotation", null);
        this.annotationActions.add("Add annotation", this.docAct);
        this.annotationActions.add("Add annotation", this.lineAct);
        this.annotationActions.add("Add annotation", this.markEllipsAct);
        this.annotationActions.add("Add annotation", this.markRectAct);
        this.annotationActions.add("Add annotation", this.quickLineAct);
        this.annotationActions.add("Add annotation", this.addStrikeActions);
        this.toolbarActions = new Vector();
        this.toolbarActions.add(this.docAct);
        this.toolbarActions.add(this.lineAct);
        this.toolbarActions.add(this.markEllipsAct);
        this.toolbarActions.add(this.markRectAct);
        this.toolbarActions.add(this.quickLineAct);
        this.toolbarActions.add(this.strikeLineAct);
        this.annoEditActions = new ActionGroup("Edit annotation", null);
        this.annoEditActions.add("Edit annotation", this.addPosAct);
        this.annoEditActions.add("Edit annotation", this.anchorizeAct);
        this.annoEditActions.add("Edit annotation", this.arrowActions);
        this.annoEditActions.add("Edit annotation", this.colourAct);
        this.annoEditActions.add("Edit annotation", this.curvActions);
        this.annoEditActions.add("Edit annotation", this.editLabAct);
        this.treeStyleActions = new ActionGroup("Tree style", null);
        this.treeStyleActions.add("Tree style", this.hideAct);
        this.treeStyleActions.add("Tree style", this.moveNodeAct);
        this.treeStyleActions.add("Tree style", this.resetPosAct);
    }

    private Position.Pnt makeCompositePosition(Position pos) {
        List<HierarchicalObject> objs = this.tv.getController().getSelection();
        Position.Pnt upos = null;
        if (objs.size() > 0) {
            for (HierarchicalObject obj : objs) {
                DrawableObject dro = this.tv.getDrawable(obj);
                if (dro == null) continue;
                pos.add(new Position.Pnt(dro.getPos().centerPos(), obj));
            }
        } else {
            upos = new Position.Pnt(null, null);
            pos.add(upos);
        }
        return upos;
    }

    private void setTVColour() {
        Color clr = Color.white;
        clr = JColorChooser.showDialog(this.tv, "Select colour", clr);
        this.tv.setBGColour(clr);
    }

    public void addDocument() {
        Document doc = new Document(this.tv.getController().getModel());
        Style s = doc.content.addStyle(null, null);
        Settings.defaultStyle(s, this.tv.getModel());
        try {
            doc.content.insertString(0, "test", s);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        Position.Pnt p = this.getAnchor();
        Position pos = new Position(p, doc);
        doc.addTweak(pos);
        this.addAnnotation(doc, p);
    }

    public void addLine() {
        Position.Pnt from = this.getAnchor();
        Position.Pnt to = new Position.Pnt(from, null);
        Line line = new Line(this.tv.getModel(), from, to);
        line.addTweak(new ArrowHead());
        this.addAnnotation(line, to);
    }

    public void addMark(boolean rect) {
        Position pos = new Position();
        Position.Pnt upos = this.makeCompositePosition(pos);
        Mark mark = new Mark(this.tv.getModel(), pos, rect);
        this.addAnnotation(mark, upos);
    }

    public void addPos() {
        HierarchicalObject obj = this.tv.getController().getFirstSelectedObject();
        if (obj == null) {
            return;
        }
        Position pos = this.tv.getDrawable(obj).getPos();
        if (pos == null) {
            return;
        }
        Position.Pnt anch = pos.size() > 0 ? pos.get(pos.size() - 1) : null;
        Position.Pnt p = new Position.Pnt(anch, obj);
        this.tv.getDrawable(obj).addPos(p);
        this.tv.startUserPositioning(obj, p);
    }

    public void addQuickLine() {
        Position.Pnt from = this.getAnchor();
        Position.Pnt to = new Position.Pnt(from, null);
        Position.Pnt fromAux = new Position.Pnt(from, null, 0.0f, ((Float)this.tv.getSetting("tv-vertical-margin")).floatValue());
        Position.Pnt toAux = new Position.Pnt(to, null, 0.0f, ((Float)this.tv.getSetting("tv-vertical-margin")).floatValue());
        Position pos = new Position(from, fromAux, toAux, to);
        Line line = new Line(this.tv.getModel(), pos);
        line.addTweak(new ArrowHead());
        this.addAnnotation(line, to);
    }

    public void addStrike(Strike.StrikeStyles style) {
        Position pos = new Position();
        Position.Pnt upos = this.makeCompositePosition(pos);
        Strike strike = new Strike(this.tv.getModel(), pos, style);
        this.addAnnotation(strike, upos);
    }

    public void anchorize() {
        HierarchicalObject obj;
        if (this.tv.getSelectedPos() != null) {
            this.tv.startActivity(new Anchorizer(this.tv, this.tv.getSelectedPos()));
        }
        if ((obj = this.tv.getController().getFirstSelectedObject()) == null) {
            return;
        }
        DrawableObject dro = this.tv.getDrawable(obj);
        if (dro == null) {
            return;
        }
        this.tv.startActivity(new Anchorizer(this.tv, dro.getPos().first()));
    }

    public void changeArrowHead(boolean atEnd) {
        CompoundEdit cp = this.getController().startCompoundEdit();
        for (HierarchicalObject obj : this.tv.getController().getSelection()) {
            if (!(obj instanceof Line)) continue;
            Line line = (Line)obj;
            ArrowHead ah = (ArrowHead)line.getTweakByType(ArrowHead.class);
            if (ah == null) {
                ah = new ArrowHead(false, false);
                line.addTweak(ah);
            }
            ArrowHead old = ah.createCopy();
            if (atEnd) {
                ah.atEnd = !ah.atEnd;
            } else {
                ah.atStart = !ah.atStart;
            }
            cp.addEdit(new TweakEdit(obj, old, ArrowHead.class));
        }
        this.tv.getController().update(this.getController().endCompoundEdit());
    }

    public void changeLineThickness(int thickness) {
        CompoundEdit cp = this.getController().startCompoundEdit();
        for (HierarchicalObject obj : this.tv.getController().getSelection()) {
            DrawableObject dro = this.tv.getDrawable(obj);
            if (dro == null) continue;
            nl.rug.syntree.hierarchicalmodel.annotations.Style old = (nl.rug.syntree.hierarchicalmodel.annotations.Style)dro.that().getTweakByType(nl.rug.syntree.hierarchicalmodel.annotations.Style.class);
            if (old != null) {
                old = old.createCopy();
            }
            dro.setThickness(thickness);
            cp.addEdit(new TweakEdit(dro.that(), old, nl.rug.syntree.hierarchicalmodel.annotations.Style.class));
        }
        this.tv.getController().update(this.getController().endCompoundEdit());
    }

    public void changeStrike(Strike.StrikeStyles style) {
        CompoundEdit cp = this.getController().startCompoundEdit();
        for (HierarchicalObject obj : this.tv.getController().getSelection()) {
            if (!(obj instanceof Strike)) continue;
            Strike st = (Strike)obj;
            Strike.StrikeStyles oldStyl = st.style();
            st.style(style);
            cp.addEdit(new StrikeEdit(st, st.northSouth(), oldStyl));
        }
        this.tv.getController().update(this.getController().endCompoundEdit());
    }

    public void curveCubic() {
        this.setCurving(3);
    }

    public void curveQuadratic() {
        this.setCurving(2);
    }

    public void delete() {
        this.tv.getController().removeObjects();
    }

    public void editLabel() {
        HierarchicalNode node = this.tv.getController().getFirstSelectedNode();
        if (node == null) {
            return;
        }
        DrawableNode drn = (DrawableNode)this.tv.getDrawable(node);
        drn.editLabel();
    }

    public void flipStrike() {
        CompoundEdit cp = this.getController().startCompoundEdit();
        for (HierarchicalObject obj : this.tv.getController().getSelection()) {
            if (!(obj instanceof Strike)) continue;
            Strike st = (Strike)obj;
            boolean ns = st.northSouth();
            st.flip();
            cp.addEdit(new StrikeEdit(st, ns, st.style()));
        }
        this.tv.getController().update(this.getController().endCompoundEdit());
    }

    public Action getAddPosAction() {
        return this.addPosAct;
    }

    public ActionGroup getAddStrikeActions() {
        return this.addStrikeActions;
    }

    public Action getAnchorizeAction() {
        return this.anchorizeAct;
    }

    public ActionGroup getAnnoEditActions() {
        return this.annoEditActions;
    }

    public ActionGroup getAnnotationActions() {
        return this.annotationActions;
    }

    public Vector<Action> getToolbarAnnotationActions() {
        return this.toolbarActions;
    }

    public Action getArrowEndAction() {
        return this.arrowEndAct;
    }

    public Action getArrowStartAction() {
        return this.arrowStartAct;
    }

    public ActionGroup getChangeStrikeActions() {
        return this.changeStrikeActions;
    }

    public ActionGroup getChangeThicknessActions() {
        return new ActionGroup("Line thickness", this.changeThicknessActions);
    }

    public Action getColourAction() {
        return this.colourAct;
    }

    public HierarchicalController getController() {
        return this.tv.getController();
    }

    public ActionGroup getCurveActions() {
        return this.curvActions;
    }

    public Action getDocumentAction() {
        return this.docAct;
    }

    public Action getEditLabelAction() {
        return this.editLabAct;
    }

    public Action getFlipStrikeAction() {
        return this.flipStrikeAct;
    }

    public Action getHideAction() {
        return this.hideAct;
    }

    public Action getLineAction() {
        return this.lineAct;
    }

    public Action getMarkAction(boolean rect) {
        if (rect) {
            return this.getMarkRectAction();
        }
        return this.getMarkEllipsAction();
    }

    public Action getMarkEllipsAction() {
        return this.markEllipsAct;
    }

    public Action getMarkRectAction() {
        return this.markRectAct;
    }

    public Action getMoveNodeAction() {
        return this.moveNodeAct;
    }

    public Action getQuickLineAction() {
        return this.quickLineAct;
    }

    public Action getResetPositionAction() {
        return this.resetPosAct;
    }

    public void hideNodes() {
        CompoundEdit cp = this.getController().startCompoundEdit();
        for (HierarchicalObject obj : this.tv.getController().getSelection()) {
            Hidden h = (Hidden)obj.getTweakByType(Hidden.class);
            if (h == null) {
                h = new Hidden();
                obj.addTweak(h);
                cp.addEdit(new TweakEdit(obj, null, Hidden.class));
                continue;
            }
            obj.removeTweaksByType(Hidden.class);
            cp.addEdit(new TweakEdit(obj, h, Hidden.class));
        }
        this.getController().update(this.getController().endCompoundEdit());
    }

    public void moveNode() {
        HierarchicalNode node = this.tv.getController().getFirstSelectedNode();
        if (node == null) {
            return;
        }
        this.tv.startActivity(new TreeMover(this.tv, (DrawableNode)this.tv.getDrawable(node)));
    }

    public void resetPositions() {
        CompoundEdit cp = this.getController().startCompoundEdit();
        for (HierarchicalObject obj : this.getController().getSelection()) {
            TreeOffset to = (TreeOffset)obj.getTweakByType(TreeOffset.class);
            if (to == null) continue;
            obj.removeTweaksByType(TreeOffset.class);
            cp.addEdit(new TweakEdit(obj, to, TreeOffset.class));
        }
        this.getController().update(this.getController().endCompoundEdit());
    }

    public void setColour() {
        nl.rug.syntree.hierarchicalmodel.annotations.Style style;
        if (this.tv.getController().getSelection().isEmpty()) {
            this.setTVColour();
            return;
        }
        Color clr = Color.black;
        DrawableObject dro = this.tv.getDrawable(this.tv.getController().getFirstSelectedObject());
        if (dro != null && (style = dro.getStyle()) != null) {
            clr = style.colour;
        }
        clr = FormatActions.getColour();
        CompoundEdit cp = this.getController().startCompoundEdit();
        for (HierarchicalObject obj : this.tv.getController().getSelection()) {
            dro = this.tv.getDrawable(obj);
            if (dro == null) continue;
            nl.rug.syntree.hierarchicalmodel.annotations.Style old = (nl.rug.syntree.hierarchicalmodel.annotations.Style)dro.that().getTweakByType(nl.rug.syntree.hierarchicalmodel.annotations.Style.class);
            if (old != null) {
                old = old.createCopy();
            }
            dro.setColour(clr);
            cp.addEdit(new TweakEdit(dro.that(), old, nl.rug.syntree.hierarchicalmodel.annotations.Style.class));
        }
        this.tv.getController().update(this.getController().endCompoundEdit());
    }

    public void setCurving(int curv) {
        CompoundEdit cp = this.getController().startCompoundEdit();
        for (HierarchicalObject obj : this.tv.getController().getSelection()) {
            if (!(obj instanceof Line)) continue;
            Line lin = (Line)obj;
            int oldCurv = lin.getCurving();
            lin.setCurving(curv);
            cp.addEdit(new CurvEdit(lin, oldCurv, curv));
        }
        cp = this.getController().endCompoundEdit();
        this.tv.getController().update(cp);
    }

    public ActionGroup getTreeStyleActions() {
        return this.treeStyleActions;
    }

    private static abstract class TreeAction
    extends AbstractAction {
        protected TreeControl tc;

        public TreeAction(TreeControl tc, String name, String icon, String descr) {
            this.tc = tc;
            this.putValue("Name", name);
            if (icon != null) {
                this.putValue("SwingLargeIconKey", UIIcons.addImageIcon(icon));
            }
            this.putValue("ShortDescription", descr);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tc.getController().invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.actionPerformed();
                }
            });
        }

        abstract void actionPerformed();

        protected void observe() {
            if (!(this instanceof Observer)) {
                return;
            }
            Observer obs = (Observer)((Object)this);
            this.tc.getController().getSelectionManager().addObserver(obs);
            this.tc.getController().getModel().addObserver(obs);
            obs.update(null, null);
        }
    }

    private static class StrikeAction
    extends TreeAction {
        private Strike.StrikeStyles style;

        public StrikeAction(TreeControl tc, Strike.StrikeStyles style) {
            super(tc, "Style: " + style.toString(), style == Strike.StrikeStyles.Line ? "icons/tree_add_strike.png" : null, "Add a " + style.toString() + "-strike");
            this.style = style;
        }

        @Override
        public void actionPerformed() {
            this.tc.addStrike(this.style);
        }
    }

    private static class ResetPositionAction
    extends TreeAction
    implements Observer {
        public ResetPositionAction(TreeControl tc) {
            super(tc, "Reset position", null, "Reset the selected node(s)' position");
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.resetPositions();
        }

        @Override
        public void update(Observable obs, Object arg) {
            boolean selected = false;
            for (HierarchicalObject obj : this.tc.getController().getSelection()) {
                selected |= obj.getTweakByType(TreeOffset.class) != null;
            }
            this.setEnabled(selected);
        }
    }

    private static class QuickLineAction
    extends TreeAction {
        public QuickLineAction(TreeControl tc) {
            super(tc, "Quick line", "icons/lc_quickline.png", "Add a line with two control points  (Alt + K)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt K"));
        }

        @Override
        public void actionPerformed() {
            this.tc.addQuickLine();
        }
    }

    private static class MoveNodeAction
    extends TreeAction
    implements Observer {
        public MoveNodeAction(TreeControl tc) {
            super(tc, "Move node", null, "Move the selected node (Alt + M)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt M"));
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.moveNode();
        }

        @Override
        public void update(Observable obs, Object arg) {
            this.setEnabled(this.tc.getController().getFirstSelectedNode() != null);
        }
    }

    private static class MarkRectAction
    extends MarkAction {
        public MarkRectAction(TreeControl tc) {
            super(tc, true);
        }
    }

    private static class MarkEllipsAction
    extends MarkAction {
        public MarkEllipsAction(TreeControl tc) {
            super(tc, false);
        }
    }

    private static class MarkAction
    extends TreeAction {
        private boolean rect;

        public MarkAction(TreeControl tc, boolean rect) {
            super(tc, "Add marker: " + (rect ? "rectangle" : "ellipse"), rect ? "icons/lc_rect_unfilled.png" : "icons/lc_ellipse_unfilled.png", "Add a" + (rect ? " rectangular" : "n elliptic") + " marker  (Alt " + (rect ? "S" : "O") + ")");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt " + (rect ? "S" : "O")));
            this.rect = rect;
        }

        @Override
        public void actionPerformed() {
            this.tc.addMark(this.rect);
        }
    }

    private static class LineThicknessAction
    extends TreeAction
    implements Observer {
        private int thickness;

        public LineThicknessAction(TreeControl tc, int thickness) {
            super(tc, "Line thickness: " + thickness, null, "Change the line thickness");
            this.putValue("ActionSupport-choosable", true);
            this.thickness = thickness;
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.changeLineThickness(this.thickness);
        }

        @Override
        public void update(Observable obs, Object arg) {
            boolean selected = false;
            boolean haveLine = false;
            for (HierarchicalObject obj : this.tc.getController().getSelection()) {
                if (!(obj instanceof Line)) continue;
                haveLine = true;
                Line line = (Line)obj;
                nl.rug.syntree.hierarchicalmodel.annotations.Style s = (nl.rug.syntree.hierarchicalmodel.annotations.Style)line.getTweakByType(nl.rug.syntree.hierarchicalmodel.annotations.Style.class);
                if (s == null || s.thickness == null) continue;
                selected = s.thickness == this.thickness;
            }
            this.putValue("SwingSelectedKey", selected);
            this.setEnabled(haveLine);
        }
    }

    private static class LineAction
    extends TreeAction {
        public LineAction(TreeControl tc) {
            super(tc, "Add line", "icons/lc_line.png", "Add a line  (Alt + I)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt I"));
        }

        @Override
        public void actionPerformed() {
            this.tc.addLine();
        }
    }

    public static class HideAction
    extends TreeAction
    implements Observer {
        public HideAction(TreeControl tc) {
            super(tc, "Show label", "icons/hide_nodes.png", "Show the labels of the selected nodes (Alt + H)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt H"));
            this.putValue("ActionSupport-togglable", true);
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.hideNodes();
        }

        @Override
        public void update(Observable obs, Object arg) {
            boolean selected = false;
            boolean haveNode = false;
            for (HierarchicalObject obj : this.tc.getController().getSelection()) {
                if (!(obj instanceof HierarchicalNode)) continue;
                haveNode = true;
                selected = obj.getTweakByType(Hidden.class) != null;
            }
            String icon = selected ? "icons/hide_nodes_hidden.png" : "icons/hide_nodes.png";
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon(icon));
            this.putValue("Name", selected ? "Show label" : "Hide label");
            this.putValue("ShortDescription", (selected ? "Show" : "Hide") + " the labels of the selected nodes (Alt + H)");
            this.putValue("SwingSelectedKey", selected);
            this.setEnabled(haveNode);
        }
    }

    private static class FlipStrikeAction
    extends TreeAction
    implements Observer {
        public FlipStrikeAction(TreeControl tc) {
            super(tc, "Flip strike", null, "Change the strike's orientation");
            this.putValue("ActionSupport-togglable", true);
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.flipStrike();
        }

        @Override
        public void update(Observable obs, Object arg) {
            boolean selected = false;
            boolean haveStrike = false;
            for (HierarchicalObject obj : this.tc.getController().getSelection()) {
                if (!(obj instanceof Strike)) continue;
                haveStrike = true;
                Strike strike = (Strike)obj;
                selected = strike.northSouth();
            }
            this.putValue("SwingSelectedKey", selected);
            this.setEnabled(haveStrike);
        }
    }

    private static class EditLabelAction
    extends TreeAction
    implements Observer {
        public EditLabelAction(TreeControl tc) {
            super(tc, "Edit label", null, "Edit the text in this label");
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.editLabel();
        }

        @Override
        public void update(Observable obs, Object arg) {
            boolean haveDoc = false;
            for (HierarchicalObject obj : this.tc.getController().getSelection()) {
                DrawableObject dro = this.tc.tv.getDrawable(obj);
                if (dro == null || !(dro instanceof DrawableDocument)) continue;
                haveDoc = true;
            }
            this.setEnabled(haveDoc);
        }
    }

    private static class DocumentAction
    extends TreeAction {
        public DocumentAction(TreeControl tc) {
            super(tc, "Add note", "icons/lc_showannotations.png", "Add a free-floating label  (Alt + D)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt D"));
        }

        @Override
        public void actionPerformed() {
            this.tc.addDocument();
        }
    }

    private static class CurveQuadraticAction
    extends CurveAction {
        public CurveQuadraticAction(TreeControl tc) {
            super(tc, 2, "quadratic", "with 1 control point  (Alt + Q)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt Q"));
        }
    }

    private static class CurveNoneAction
    extends CurveAction {
        public CurveNoneAction(TreeControl tc) {
            super(tc, 0, "none (straight)", "not");
        }
    }

    private static class CurveCubicAction
    extends CurveAction {
        public CurveCubicAction(TreeControl tc) {
            super(tc, 3, "cubic", "with 2 control points  (Alt + U)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt U"));
        }
    }

    private static class CurveAction
    extends TreeAction
    implements Observer {
        private int curve;

        public CurveAction(TreeControl tc, int curve, String nm, String desc) {
            super(tc, "Curve line: " + nm, null, "Curve the selected line(s) " + desc);
            this.curve = curve;
            this.putValue("ActionSupport-choosable", true);
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.setCurving(this.curve);
        }

        @Override
        public void update(Observable obs, Object arg) {
            boolean selected = true;
            boolean haveLine = false;
            for (HierarchicalObject obj : this.tc.getController().getSelection()) {
                if (!(obj instanceof Line)) continue;
                haveLine = true;
                Line line = (Line)obj;
                selected &= line.getCurving() == this.curve;
            }
            this.putValue("SwingSelectedKey", selected);
            this.setEnabled(haveLine);
        }
    }

    private static class ColourAction
    extends TreeAction {
        public ColourAction(TreeControl tc) {
            super(tc, "Change colour", null, "Change the colour of the selected objects  (Alt + C)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt C"));
        }

        @Override
        public void actionPerformed() {
            this.tc.setColour();
        }
    }

    private static class ChangeStrikeAction
    extends TreeAction
    implements Observer {
        private Strike.StrikeStyles style;

        public ChangeStrikeAction(TreeControl tc, Strike.StrikeStyles style) {
            super(tc, "Style: " + style.toString(), null, "Change to a " + style.toString() + "-strike");
            this.putValue("ActionSupport-choosable", true);
            this.style = style;
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.changeStrike(this.style);
        }

        @Override
        public void update(Observable obs, Object arg) {
            boolean selected = false;
            boolean haveStrike = false;
            for (HierarchicalObject obj : this.tc.getController().getSelection()) {
                if (!(obj instanceof Strike)) continue;
                haveStrike = true;
                Strike strike = (Strike)obj;
                selected = strike.style() == this.style;
            }
            this.putValue("SwingSelectedKey", selected);
            this.setEnabled(haveStrike);
        }
    }

    private static class ArrowStartAction
    extends TreeAction
    implements Observer {
        public ArrowStartAction(TreeControl tc) {
            super(tc, "Arrow at start", null, "Toggle arrow-head at start");
            this.putValue("ActionSupport-togglable", true);
            this.putValue("SwingSelectedKey", false);
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.changeArrowHead(false);
        }

        @Override
        public void update(Observable obs, Object arg) {
            boolean selected = false;
            boolean haveLine = false;
            for (HierarchicalObject obj : this.tc.getController().getSelection()) {
                if (!(obj instanceof Line)) continue;
                haveLine = true;
                Line line = (Line)obj;
                ArrowHead ah = (ArrowHead)line.getTweakByType(ArrowHead.class);
                if (ah != null) {
                    if (ah.atStart) {
                        selected = true;
                        continue;
                    }
                    selected = false;
                    continue;
                }
                selected = false;
            }
            this.putValue("SwingSelectedKey", selected);
            this.setEnabled(haveLine);
        }
    }

    private static class ArrowEndAction
    extends TreeAction
    implements Observer {
        public ArrowEndAction(TreeControl tc) {
            super(tc, "Arrow at end", null, "Toggle arrow-head at end");
            this.putValue("ActionSupport-togglable", true);
            this.putValue("SwingSelectedKey", false);
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.changeArrowHead(true);
        }

        @Override
        public void update(Observable obs, Object arg) {
            boolean selected = false;
            boolean haveLine = false;
            for (HierarchicalObject obj : this.tc.getController().getSelection()) {
                if (!(obj instanceof Line)) continue;
                haveLine = true;
                Line line = (Line)obj;
                ArrowHead ah = (ArrowHead)line.getTweakByType(ArrowHead.class);
                if (ah != null) {
                    if (ah.atEnd) {
                        selected = true;
                        continue;
                    }
                    selected = false;
                    continue;
                }
                selected = false;
            }
            this.putValue("SwingSelectedKey", selected);
            this.setEnabled(haveLine);
        }
    }

    private static class AnchorizeAction
    extends TreeAction
    implements Observer {
        public AnchorizeAction(TreeControl tc) {
            super(tc, "Change anchor", null, "Change the anchor point of this object  (Alt + Z)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt Z"));
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.anchorize();
        }

        @Override
        public void update(Observable obs, Object arg) {
            for (HierarchicalObject obj : this.tc.getController().getSelection()) {
                if (obj instanceof HierarchicalNode) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private static class AddPosAction
    extends TreeAction
    implements Observer {
        public AddPosAction(TreeControl tc) {
            super(tc, "Add point", null, "Add a position control point  (Ctrl + Alt + A)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control alt A"));
            super.observe();
        }

        @Override
        public void actionPerformed() {
            this.tc.addPos();
        }

        @Override
        public void update(Observable obs, Object arg) {
            for (HierarchicalObject obj : this.tc.getController().getSelection()) {
                if (!(obj instanceof Line) && !(obj instanceof Mark)) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }
}

