/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram;

import java.awt.Component;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.mainview.components.ActionGroup;
import nl.rug.syntree.mainview.components.ActionSupport;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.DrawableObject;

public class TreeMenu
extends JPopupMenu
implements PopupMenuListener {
    private TreeView tv;

    public TreeMenu(TreeView tv) {
        this.tv = tv;
        this.addPopupMenuListener(this);
    }

    private void clear() {
        this.removeAll();
    }

    private void defaultTreeActions() {
        this.add(this.tv.getControl().getColourAction());
    }

    private void makeMenu() {
        System.out.println("TV mkMenu");
        Vector objsDone = new Vector();
        for (HierarchicalObject obj : this.tv.getController().getSelection()) {
            DrawableObject dro = this.tv.getDrawable(obj);
            if (dro == null || objsDone.contains(dro.getClass())) continue;
            ActionGroup acts = dro.getActions();
            if (acts != null) {
                this.add(ActionSupport.makeMenuItem(acts));
            }
            objsDone.add(dro.getClass());
        }
        this.defaultTreeActions();
        this.addSeparator();
        for (ActionGroup ag : this.tv.getControl().getAnnotationActions()) {
            this.add(ActionSupport.makeMenuItem(ag));
        }
        this.addSeparator();
        for (Action act : this.tv.getController().getModelActions()) {
            this.add(new JMenuItem(act));
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent arg0) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
        this.clear();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
        this.makeMenu();
    }

    @Override
    public synchronized void show(Component comp, int x, int y) {
        super.show(comp, x, y);
    }
}

