/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import nl.rug.syntree.Settings;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.exporters.ImageExporter;
import nl.rug.syntree.hierarchicalmodel.exporters.SVGExporter;
import nl.rug.syntree.mainview.MainFrame;
import nl.rug.syntree.mainview.ViewPane;
import nl.rug.syntree.mainview.components.ActionSupport;
import nl.rug.syntree.mainview.components.OrientMenu;
import nl.rug.syntree.mainview.components.SlidersMenu;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.components.UIToolbarButton;
import nl.rug.syntree.mainview.components.VisMenu;
import nl.rug.syntree.treediagram.TreeView;

public class TreePane
extends ViewPane
implements PropertyChangeListener {
    private TreeView tv;
    private MainFrame mf;
    private HierarchicalController control;
    private boolean firstUpdate = true;

    public TreePane(final TreeView tv) {
        super(tv, "[view: tree diagram]");
        this.tv = tv;
        this.control = tv.getController();
        this.mf = tv.getMainframe();
        this.tv.addPropertyChangeListener("prop-first-update", this);
        this.tv.setTreePane(this);
        UIToolbarButton update = new UIToolbarButton("Update");
        UIToolbarButton dumpSVG = new UIToolbarButton("Dump SVG");
        AbstractButton centrate = ActionSupport.makeButton(new CentrateAction(this));
        AbstractButton scale = ActionSupport.makeButton(new ScaleAction(this));
        AbstractButton extraView = ActionSupport.makeButton(new SplitPaneAction(this));
        if (Settings.ENABLE_DUMP_SVG) {
            super.addButton(dumpSVG);
        }
        super.addZoomButton(scale);
        super.addZoomButton(centrate);
        super.addZoomButton(ActionSupport.makeButton(this.tv.getPanAction()));
        super.addButton(extraView);
        super.addButton(ActionSupport.makeButton(new LowerNodesAction(this)));
        super.addMenu(new VisMenu(this.tv));
        super.addMenu(new OrientMenu(this.tv));
        super.addMenu(new SlidersMenu(this.tv));
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(this.getSize().width, 600));
        System.out.println("Preferred size set!");
        update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                tv.update(tv.getModel(), null);
            }
        });
        dumpSVG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser();
                FileNameExtensionFilter filterSVG = new FileNameExtensionFilter("SVG image", "svg");
                FileNameExtensionFilter filterPNG = new FileNameExtensionFilter("PNG image", "png");
                FileNameExtensionFilter filterJPG = new FileNameExtensionFilter("JPEG image", "jpg", "jpeg");
                FileNameExtensionFilter filterPDF = new FileNameExtensionFilter("PDF document", "pdf");
                fc.setFileFilter(filterSVG);
                fc.addChoosableFileFilter(filterPNG);
                fc.addChoosableFileFilter(filterJPG);
                fc.addChoosableFileFilter(filterPDF);
                if (fc.showSaveDialog(TreePane.this) == 0) {
                    File f = fc.getSelectedFile();
                    if (fc.getFileFilter() == filterSVG) {
                        SVGExporter.documentToFile(((TreePane)TreePane.this).tv.doc, f);
                    } else if (fc.getFileFilter() == filterPNG) {
                        ImageExporter.SVGtoPNG(TreePane.this.tv, f);
                    } else if (fc.getFileFilter() == filterJPG) {
                        ImageExporter.SVGtoJPEG(TreePane.this.tv, f);
                    } else if (fc.getFileFilter() == filterPDF) {
                        ImageExporter.SVGtoPDF(TreePane.this.tv, f);
                    }
                }
            }
        });
    }

    private void centrate() {
        this.tv.centrate();
    }

    private void retranslate(AffineTransform zoomTransform) {
        AffineTransform at = this.tv.getRenderingTransform();
        double tvWidth = (double)this.tv.getCachedWidth() * at.getScaleX();
        double tvHeight = (double)this.tv.getCachedHeight() * at.getScaleY();
        double dx = tvWidth / 2.0 - (double)this.tv.getCachedWidth() * zoomTransform.getScaleX() / 2.0;
        double dy = tvHeight / 2.0 - (double)this.tv.getCachedHeight() * zoomTransform.getScaleY() / 2.0;
        at.setToTranslation(at.getTranslateX() + dx, at.getTranslateY() + dy);
        at.concatenate(zoomTransform);
        this.tv.setRenderingTransform(at);
    }

    public void scale() {
        Dimension d = this.tv.getSize();
        double scale = Math.min(d.getWidth() / (double)this.tv.getCachedWidth(), d.getHeight() / (double)this.tv.getCachedHeight());
        AffineTransform at = AffineTransform.getScaleInstance(scale, scale);
        this.tv.setRenderingTransform(at);
        this.centrate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("prop-first-update")) {
            this.tv.centrate();
        }
    }

    @Override
    public void zoomIn() {
        AffineTransform at = this.tv.getRenderingTransform();
        this.retranslate(AffineTransform.getScaleInstance(at.getScaleX() * 1.25, at.getScaleY() * 1.25));
    }

    @Override
    public void zoomOut() {
        AffineTransform at = this.tv.getRenderingTransform();
        this.retranslate(AffineTransform.getScaleInstance(at.getScaleX() * 0.75, at.getScaleY() * 0.75));
    }

    @Override
    public void zoomRestore() {
        this.retranslate(AffineTransform.getScaleInstance(0.75, 0.75));
    }

    private abstract class TPAction
    extends AbstractAction {
        protected TreePane tp;

        public TPAction(TreePane tp, String name, String icon, String descr) {
            this.tp = tp;
            if (icon != null) {
                this.putValue("SwingLargeIconKey", UIIcons.addImageIcon(icon));
            }
            this.putValue("ShortDescription", descr);
            this.setEnabled(true);
        }
    }

    private class LowerNodesAction
    extends TPAction {
        public LowerNodesAction(TreePane tp) {
            super(tp, "Lower end-nodes", "icons/tree_lower_endnodes.png", "Align all end-nodes (leaves) to the bottom");
            this.putValue("ActionSupport-togglable", true);
            this.putValue("SwingSelectedKey", TreePane.this.tv.isLowerEndNodes());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TreePane.this.control.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreePane.this.tv.setSetting("tv-lower-endnodes", Boolean.valueOf(!TreePane.this.tv.isLowerEndNodes()));
                }
            });
        }
    }

    private class SplitPaneAction
    extends TPAction {
        public SplitPaneAction(TreePane tp) {
            super(tp, "Two tree views", "icons/windows.png", "Split the tree view into two tree views");
            this.putValue("ActionSupport-togglable", true);
            this.putValue("SwingSelectedKey", this.tp.mf.hasExtraView());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.putValue("SwingSelectedKey", !this.tp.mf.hasExtraView());
            this.tp.mf.toggleExtraView();
        }
    }

    private class ScaleAction
    extends TPAction {
        public ScaleAction(TreePane tp) {
            super(tp, "Scale", "icons/zoom_fit.png", "Fit to screen");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.tp.scale();
        }
    }

    private class CentrateAction
    extends TPAction {
        public CentrateAction(TreePane tp) {
            super(tp, "Centrate", "icons/centre-align-doc.png", "Align to center");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.tp.centrate();
        }
    }
}

