/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram;

import java.awt.geom.Rectangle2D;
import java.util.Vector;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.hierarchicalmodel.annotations.TreeOffset;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.DrawableObject;

public abstract class TreePositioner {
    protected TreeView tv;

    protected TreePositioner(TreeView tv) {
        this.tv = tv;
    }

    protected Rectangle2D.Float getBounds(HierarchicalNode node) {
        DrawableObject dro = this.tv.getDrawable(node);
        if (dro == null) {
            return null;
        }
        return dro.getBounds();
    }

    protected float getHorizontalMargin() {
        return ((Float)this.tv.getSetting("tv-horizontal-perc")).floatValue() / 100.0f * ((Float)this.tv.getSetting("tv-horizontal-margin")).floatValue();
    }

    protected TreeOffset getOffset(HierarchicalNode node) {
        TreeOffset ret = (TreeOffset)node.getTweakByType(TreeOffset.class);
        if (ret == null) {
            ret = new TreeOffset(0.0f, 0.0f);
        }
        return ret;
    }

    protected Position.Pnt getPos(HierarchicalNode node) {
        DrawableObject dro = this.tv.getDrawable(node);
        if (dro == null) {
            return null;
        }
        if (dro.getPos() == null) {
            dro.setPos(new Position(null, node));
        }
        return dro.getPos().first();
    }

    protected float getVerticalMargin() {
        return ((Float)this.tv.getSetting("tv-vertical-perc")).floatValue() / 100.0f * ((Float)this.tv.getSetting("tv-vertical-margin")).floatValue();
    }

    protected Vector<HierarchicalNode> getNextNodes(HierarchicalNode node) {
        Vector<HierarchicalNode> nextNodes = node.isCollapsed() ? node.getFirstExpandedOffspring() : node.getChildren();
        return nextNodes;
    }

    public abstract float computeHeight();

    public abstract float computeWidth();

    public abstract void invertTree(boolean var1);

    public abstract void lowerEndNodes();
}

