/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import nl.rug.syntree.Settings;
import nl.rug.syntree.hierarchicalmodel.HierarchicalBranch;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Document;
import nl.rug.syntree.hierarchicalmodel.annotations.Line;
import nl.rug.syntree.hierarchicalmodel.annotations.Mark;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.hierarchicalmodel.annotations.Strike;
import nl.rug.syntree.mainview.MainFrame;
import nl.rug.syntree.mainview.UIUtilities;
import nl.rug.syntree.mainview.View;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.treediagram.HorizontalPositioner;
import nl.rug.syntree.treediagram.KeyListener;
import nl.rug.syntree.treediagram.TreeControl;
import nl.rug.syntree.treediagram.TreeInteractor;
import nl.rug.syntree.treediagram.TreeMenu;
import nl.rug.syntree.treediagram.TreePane;
import nl.rug.syntree.treediagram.TreePositioner;
import nl.rug.syntree.treediagram.VerticalPositioner;
import nl.rug.syntree.treediagram.activities.ChildPendler;
import nl.rug.syntree.treediagram.activities.Selecter;
import nl.rug.syntree.treediagram.activities.TreeActivity;
import nl.rug.syntree.treediagram.activities.UserPositioniser;
import nl.rug.syntree.treediagram.drawables.DrawableBranch;
import nl.rug.syntree.treediagram.drawables.DrawableDocument;
import nl.rug.syntree.treediagram.drawables.DrawableLine;
import nl.rug.syntree.treediagram.drawables.DrawableMark;
import nl.rug.syntree.treediagram.drawables.DrawableNode;
import nl.rug.syntree.treediagram.drawables.DrawableObject;
import nl.rug.syntree.treediagram.drawables.DrawableStrike;
import nl.rug.syntree.treediagram.drawables.PosDrawable;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.svg.SVGOMDefsElement;
import org.apache.batik.dom.svg.SVGOMMarkerElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg.SVGOMRectElement;
import org.apache.batik.dom.svg12.SVG12DOMImplementation;
import org.apache.batik.dom.svg12.SVG12OMDocument;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.AbstractPanInteractor;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.Interactor;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGSVGElement;

public class TreeView
extends JSVGCanvas
implements Observer,
JGVTComponentListener,
ComponentListener,
View {
    public static final String SYNTREENS = "http://let.webhosting.rug.nl/incpar/";
    public static final String SVGNS = "http://www.w3.org/2000/svg";
    public static final String PANMODE_PROP = "prop-panmode";
    public static final String FIRSTUPDATE_PROP = "prop-first-update";
    public static final String UPDATED_PROP = "prop-updated";
    private TreeControl tc;
    private HierarchicalController controller;
    private TreePositioner positioner;
    private MainFrame mainframe;
    public SVG12OMDocument doc;
    public Element rootElm;
    public Element annoElm;
    private HashMap<Integer, DrawableObject> drawables = new HashMap();
    private float cachedX;
    private float cachedY;
    private float cachedWidth;
    private float cachedHeight;
    private Vector<Interactor> stdInteractors = new Vector();
    private HierarchicalModel currentModel = null;
    private TreeActivity currentAct = null;
    private PosDrawable selectedPos = null;
    private EventListener gcl = null;
    private HierarchicalObject doPositionising = null;
    private Position.Pnt doPositionisingPos = null;
    private TreeMenu menu = null;
    private int id;
    private boolean haltSelect = false;
    private boolean haltClick = false;
    private boolean panMode = false;
    private boolean customPan = false;
    private PanAction panAct = null;
    private boolean firstUpdate = true;
    private PropertyChangeSupport pcs = null;
    private TreePane treePane = null;
    private boolean hasCollapsed = false;
    private boolean isActive = true;

    public TreeView(int id, HierarchicalController control, MainFrame mf) {
        super(null, true, false);
        this.id = id;
        this.setDocumentState(1);
        this.firstUpdate = this.id == 0;
        this.controller = control;
        this.currentModel = control.getModel();
        this.positioner = new HorizontalPositioner(this);
        this.mainframe = mf;
        this.tc = new TreeControl(this);
        this.setDocumentState(1);
        this.setDoubleBuffered(true);
        this.setDoubleBufferedRendering(true);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.textSelectionManager = null;
        this.addJGVTComponentListener(this);
        this.addComponentListener(this);
        this.setRecenterOnResize(true);
        this.getInteractors().clear();
        KeyListener kl = new KeyListener(this);
        this.getInteractors().add(kl);
        this.getInteractors().add(new AbstractPanInteractor(){

            @Override
            public boolean startInteraction(InputEvent ie) {
                if (TreeView.this.panMode) {
                    return true;
                }
                if (ie.isConsumed()) {
                    return false;
                }
                if (ie.isShiftDown()) {
                    TreeView.this.firePropChange(TreeView.PANMODE_PROP, false, true);
                }
                int mask = 1088;
                boolean ret = (ie.getModifiersEx() & mask) == mask && TreeView.this.currentAct == null;
                return ret;
            }

            @Override
            public boolean endInteraction() {
                boolean ret = super.endInteraction();
                TreeView.this.customPan = true;
                if (ret && !TreeView.this.panMode) {
                    TreeView.this.firePropChange(TreeView.PANMODE_PROP, true, false);
                }
                return ret;
            }
        });
        this.stdInteractors.addAll(this.getInteractors());
        this.menu = new TreeMenu(this);
        this.addMouseListener(new MouseAdapter(){
            private boolean doShow = false;

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.doShow = true;
                }
            }

            @Override
            public void mouseReleased(final MouseEvent evt) {
                if (evt.isPopupTrigger() || this.doShow) {
                    this.doShow = false;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TreeView.this.menu.show(TreeView.this, evt.getX(), evt.getY());
                        }
                    });
                }
            }
        });
        this.pcs = new PropertyChangeSupport(this);
        this.panAct = new PanAction(this);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener listen) {
        super.addPropertyChangeListener(prop, listen);
        this.pcs.addPropertyChangeListener(prop, listen);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listen) {
        super.addPropertyChangeListener(listen);
        this.pcs.addPropertyChangeListener(listen);
    }

    public void firePropChange(String prop, Object old, Object nw) {
        this.pcs.firePropertyChange(prop, old, nw);
    }

    public void firePropChange(String prop, boolean old, boolean nw) {
        this.pcs.firePropertyChange(prop, old, nw);
    }

    private DrawableObject annotationToDrawable(HierarchicalObject arg) {
        if (arg instanceof Line) {
            return new DrawableLine(this, (Line)arg);
        }
        if (arg instanceof Document) {
            return new DrawableDocument(this, (Document)arg);
        }
        if (arg instanceof Mark) {
            return new DrawableMark(this, (Mark)arg);
        }
        if (arg instanceof Strike) {
            return new DrawableStrike(this, (Strike)arg);
        }
        return null;
    }

    private void buildSVG() {
        Vector<DrawableObject> notUpdated = new Vector<DrawableObject>();
        notUpdated.addAll(this.drawables.values());
        System.out.println("Building nodes");
        for (HierarchicalNode root : this.getModel().getRootNodes()) {
            this.buildSVG(root, notUpdated);
        }
        System.out.println("TV Annotations: " + this.getModel().getAnnotations().size());
        for (HierarchicalObject obj : this.getModel().getAnnotations()) {
            DrawableObject dro;
            if (!this.drawables.containsKey(obj.getId())) {
                dro = this.annotationToDrawable(obj);
                if (dro == null) {
                    System.err.println("Warning: no drawable for " + obj.getClass().getName());
                    continue;
                }
                this.drawObject(dro);
                continue;
            }
            dro = this.drawables.get(obj.getId());
            dro.update(obj);
            notUpdated.remove(dro);
        }
        for (DrawableObject dro : notUpdated) {
            this.drawables.remove(dro.that().getId());
            dro.wipe();
        }
    }

    private void buildSVG(HierarchicalNode node, Vector<DrawableObject> noup) {
        DrawableObject dro;
        if (!this.drawables.containsKey(node.getId())) {
            dro = new DrawableNode(this, node);
            this.drawObject(dro);
        } else {
            dro = this.drawables.get(node.getId());
            if (dro.update(node)) {
                noup.remove(dro);
            }
        }
        if (node.isCollapsed()) {
            this.hasCollapsed = true;
            for (HierarchicalNode offspring : node.getFirstExpandedOffspring()) {
                this.buildSVG(offspring, noup);
            }
            if (node.hasChildren()) {
                HierarchicalBranch firstBranch = node.getBranches().firstElement();
                this.addBranchToSVG(firstBranch, noup);
            }
        } else {
            for (HierarchicalBranch branch : node.getBranches()) {
                this.buildSVG(branch.getChild(), noup);
                this.addBranchToSVG(branch, noup);
            }
        }
    }

    private void addBranchToSVG(HierarchicalBranch branch, Vector<DrawableObject> noup) {
        if (!this.drawables.containsKey(branch.getId())) {
            DrawableBranch dro = new DrawableBranch(this, branch);
            this.drawObject(dro);
        } else {
            DrawableObject dro = this.drawables.get(branch.getId());
            if (dro.update(branch)) {
                noup.remove(dro);
            }
        }
    }

    private void clearDocument() {
        if (this.rootElm != null) {
            this.doc.getRootElement().removeChild(this.rootElm);
        }
        if (this.annoElm != null) {
            this.doc.getRootElement().removeChild(this.annoElm);
        }
        this.rootElm = this.doc.createElementNS(SVGNS, "g");
        this.rootElm.setAttributeNS(null, "id", "model");
        this.annoElm = this.doc.createElementNS(SVGNS, "g");
        this.annoElm.setAttributeNS(null, "id", "annotations");
        this.doc.getRootElement().appendChild(this.rootElm);
        this.doc.getRootElement().appendChild(this.annoElm);
    }

    private SVG12OMDocument createEmptyDoc() {
        SVG12DOMImplementation impl = (SVG12DOMImplementation)SVG12DOMImplementation.getDOMImplementation();
        SVG12OMDocument newDoc = (SVG12OMDocument)impl.createDocument(SVGNS, "svg", null);
        newDoc.setIsSVG12(true);
        int w = this.getWidth();
        int h = this.getHeight();
        SVGSVGElement docElm = newDoc.getRootElement();
        docElm.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:syntree", SYNTREENS);
        docElm.setAttributeNS(null, "viewbox", "0 0 " + w + " " + h);
        docElm.setAttributeNS(null, "preserveAspectRatio", "xMidYMid meet");
        docElm.setAttributeNS(null, "width", "" + w);
        docElm.setAttributeNS(null, "height", "" + h);
        docElm.setAttributeNS(null, "version", "1.2");
        docElm.setAttributeNS(SYNTREENS, "syntree:version", "0.8");
        SVGOMRectElement rect = (SVGOMRectElement)newDoc.createElementNS(SVGNS, "rect");
        rect.setAttributeNS(null, "id", "model-background");
        rect.setAttributeNS(null, "x", "0");
        rect.setAttributeNS(null, "y", "0");
        rect.setAttributeNS(null, "width", "100%");
        rect.setAttributeNS(null, "height", "100%");
        rect.setAttributeNS(null, "pointer-events", "all");
        rect.setAttributeNS(null, "fill", "#FFF");
        rect.setAttributeNS(null, "stroke-width", "0");
        rect.setAttributeNS(null, "stroke", "#000");
        SVGOMDefsElement defs = (SVGOMDefsElement)newDoc.createElementNS(SVGNS, "defs");
        SVGOMMarkerElement arrowMarker = (SVGOMMarkerElement)newDoc.createElementNS(SVGNS, "marker");
        arrowMarker.setAttributeNS(null, "id", "arrowEnd");
        arrowMarker.setAttributeNS(null, "markerWidth", "5");
        arrowMarker.setAttributeNS(null, "markerHeight", "4");
        arrowMarker.setAttributeNS(null, "refX", "2.5");
        arrowMarker.setAttributeNS(null, "refY", "2");
        arrowMarker.setAttributeNS(null, "orient", "auto");
        SVGOMPathElement arrowPath = (SVGOMPathElement)newDoc.createElementNS(SVGNS, "path");
        arrowPath.setAttributeNS(null, "d", "M0,0 L0,4 L5,2 L0,0 z");
        arrowPath.setAttributeNS(null, "fill", "" + TreeView.colourToHTML((Color)this.getSetting("tv-line-colour")));
        arrowMarker.appendChild(arrowPath);
        defs.appendChild(arrowMarker);
        arrowMarker = (SVGOMMarkerElement)arrowMarker.cloneNode(false);
        arrowMarker.setAttributeNS(null, "id", "arrowStart");
        arrowMarker.setAttributeNS(null, "refX", "3");
        arrowPath = (SVGOMPathElement)arrowPath.cloneNode(true);
        arrowPath.setAttributeNS(null, "d", "M0,2 L5,4 L5,0 L0,2 z");
        arrowMarker.appendChild(arrowPath);
        defs.appendChild(arrowMarker);
        arrowMarker = (SVGOMMarkerElement)arrowMarker.cloneNode(false);
        arrowMarker.setAttributeNS(null, "id", "depArrow");
        arrowMarker.setAttributeNS(null, "refX", "2.5");
        arrowPath = (SVGOMPathElement)arrowPath.cloneNode(true);
        arrowPath.setAttributeNS(null, "d", "M0,0 L0,4 L5,2 L0,0 z");
        arrowPath.setAttributeNS(null, "fill", "#F00");
        arrowMarker.appendChild(arrowPath);
        defs.appendChild(arrowMarker);
        docElm.appendChild(defs);
        docElm.appendChild(rect);
        this.gcl = new EventListener(){

            private void click(DOMMouseEvent evt) {
                if (evt.getButton() == 0 && evt.getDetail() == 1) {
                    TreeView.this.controller.selectNone();
                }
            }

            private void down(DOMMouseEvent evt) {
                TreeView.this.startActivity(new Selecter(TreeView.this, evt));
            }

            @Override
            public void handleEvent(Event arg0) {
                switch (arg0.getType()) {
                    case "mouseup": {
                        this.click((DOMMouseEvent)arg0);
                        break;
                    }
                    case "mousedown": {
                        this.down((DOMMouseEvent)arg0);
                    }
                }
            }
        };
        rect.addEventListener("mouseup", this.gcl, false);
        rect.addEventListener("mousedown", this.gcl, false);
        return newDoc;
    }

    private void drawObject(DrawableObject obj) {
        this.drawables.put(obj.that().getId(), obj);
        System.out.println("Put obj : " + obj.that().getId());
        obj.draw();
    }

    private void fireUpdateEvent() {
        if (this.firstUpdate) {
            this.firePropChange(FIRSTUPDATE_PROP, true, false);
            this.firstUpdate = false;
        }
        this.firePropChange(UPDATED_PROP, null, null);
    }

    private DrawableObject getDrawableById(int id) {
        return this.drawables.get(id);
    }

    private void postUpdate() {
        for (HierarchicalNode root : this.getModel().getRootNodes()) {
            this.postUpdate(root);
        }
        float xMin = Float.MAX_VALUE;
        float yMin = Float.MAX_VALUE;
        float xMax = Float.MIN_VALUE;
        float yMax = Float.MIN_VALUE;
        for (DrawableObject dro : this.drawables.values()) {
            if (!dro.validate()) continue;
            dro.reposition();
            Rectangle2D.Float bounds = dro.getBounds();
            if (bounds == null) continue;
            xMin = Math.min(xMin, (float)bounds.getMinX());
            yMin = Math.min(yMin, (float)bounds.getMinY());
            xMax = Math.max(xMax, (float)bounds.getMaxX());
            yMax = Math.max(yMax, (float)bounds.getMaxY());
        }
        this.cachedX = xMin;
        this.cachedY = yMin;
        this.cachedWidth = xMax - xMin;
        this.cachedHeight = yMax - yMin;
        if (this.doPositionising != null && this.currentAct == null) {
            HierarchicalObject obj = this.doPositionising;
            this.doPositionising = null;
            this.startUserPositioning(obj, this.doPositionisingPos);
        }
        this.treePane.removeMessage();
        if (this.hasCollapsed) {
            this.treePane.displayMessage("Model contains hidden structure.", 1);
        }
        if (this.currentAct != null) {
            this.currentAct.resume();
            if (this.currentAct instanceof ChildPendler) {
                this.treePane.displayMessage("Choose intended location by moving the mouse and clicking.", 0);
            }
        }
    }

    private void postUpdate(HierarchicalNode node) {
        if (this.currentAct == null && node.pendle() && this.id == 0) {
            System.out.println("TV start childPendler for " + node);
            this.startActivity(new ChildPendler(this, (DrawableNode)this.getDrawable(node)));
        }
        for (HierarchicalNode child : node.getChildren()) {
            this.postUpdate(child);
        }
    }

    private void preUpdate() {
        System.out.println(Thread.currentThread().getId());
        for (Interactor i : this.getInteractors()) {
            if (!(i instanceof TreeInteractor)) continue;
            ((TreeInteractor)i).end();
        }
        if (this.currentAct != null) {
            this.currentAct.pause();
        }
        this.getOverlays().clear();
        this.getInteractors().clear();
        this.getInteractors().addAll(this.stdInteractors);
        if (this.isHorizontal()) {
            if (!(this.positioner instanceof HorizontalPositioner)) {
                this.positioner = new HorizontalPositioner(this);
            }
        } else if (!(this.positioner instanceof VerticalPositioner)) {
            this.positioner = new VerticalPositioner(this);
        }
        this.hasCollapsed = false;
    }

    private void updateModel(HierarchicalModel newModel) {
        this.currentModel = newModel;
        this.clearDocument();
        this.drawables.clear();
    }

    private void updateSelection() {
        for (DrawableObject dro : this.drawables.values()) {
            dro.selectMe(dro.amSelected());
            if (this.customPan || !dro.amSelected()) continue;
            dro.scrollIntoView();
        }
    }

    private void updateSVG(HierarchicalNode updateRoot) {
        try {
            System.out.println("TV (" + Thread.currentThread().getId() + ") update begin");
            this.preUpdate();
            this.buildSVG();
            this.positioner.computeWidth();
            this.positioner.computeHeight();
            this.positioner.invertTree(this.isInverted());
            if (this.isLowerEndNodes()) {
                this.positioner.lowerEndNodes();
            }
            this.postUpdate();
            System.out.println("TV (" + Thread.currentThread().getId() + ") update end");
        }
        catch (Exception e) {
            e.printStackTrace();
            UIUtilities.handleException(e, this, this.getModel());
        }
    }

    @Override
    protected void installKeyboardActions() {
    }

    public void cancelActivity() {
        if (this.currentAct == null) {
            return;
        }
        this.currentAct.cancel();
        this.controller.update(this.controller.endCompoundEdit());
        this.haltSelect(false);
        this.haltClick(false);
    }

    public void centrate() {
        AffineTransform vt = this.getRenderingTransform();
        vt.setToScale(vt.getScaleX(), vt.getScaleY());
        double tvWidth = (double)this.getCachedWidth() * vt.getScaleX();
        double tvHeight = (double)this.getCachedHeight() * vt.getScaleY();
        this.centrate(tvWidth / 2.0, tvHeight / 2.0);
    }

    public void centrate(double x, double y) {
        AffineTransform vt = this.getRenderingTransform();
        vt.setToScale(vt.getScaleX(), vt.getScaleY());
        Dimension d = this.getSize();
        double compWidth = d.getWidth();
        double compHeight = d.getHeight();
        double tvX = (double)this.getCachedX() * vt.getScaleX();
        double tvY = (double)this.getCachedY() * vt.getScaleY();
        AffineTransform at = AffineTransform.getTranslateInstance(compWidth / 2.0 - x - tvX, compHeight / 2.0 - y - tvY);
        at.concatenate(vt);
        this.setRenderingTransform(at);
        this.customPan = false;
        this.pan(false);
        System.out.println("TV centrate: " + x + ", " + y);
    }

    @Override
    public void setRenderingTransform(AffineTransform at) {
        super.setRenderingTransform(at);
        this.getController().endCurrentEditor();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.getUpdateManager() == null) {
            return;
        }
        this.getUpdateManager().getUpdateRunnableQueue().invokeLater(new Runnable(){

            @Override
            public void run() {
                SVGSVGElement docElm = TreeView.this.doc.getRootElement();
                int w = TreeView.this.getWidth();
                int h = TreeView.this.getHeight();
                docElm.setAttributeNS(null, "viewbox", "0 0 " + w + " " + h);
                docElm.setAttributeNS(null, "width", "" + w);
                docElm.setAttributeNS(null, "height", "" + h);
                TreeView.this.componentTransformChanged(null);
                if (TreeView.this.getModel().isCentered()) {
                    TreeView.this.centrate();
                }
            }
        });
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentTransformChanged(ComponentEvent event) {
        UpdateManager um = this.controller.getUpdateManager();
        if (um == null) {
            um = this.getUpdateManager();
        }
        um.getUpdateRunnableQueue().invokeLater(new Runnable(){

            @Override
            public void run() {
                AffineTransform at = TreeView.this.getRenderingTransform();
                Element modelBg = TreeView.this.doc.getElementById("model-background");
                int w = TreeView.this.getWidth();
                int h = TreeView.this.getHeight();
                modelBg.setAttributeNS(null, "x", "" + -at.getTranslateX() / at.getScaleX());
                modelBg.setAttributeNS(null, "y", "" + -at.getTranslateY() / at.getScaleY());
                modelBg.setAttributeNS(null, "width", "" + (double)w / at.getScaleX());
                modelBg.setAttributeNS(null, "height", "" + (double)h / at.getScaleY());
            }
        });
    }

    public void endActivity() {
        if (this.currentAct == null) {
            return;
        }
        this.currentAct = null;
        this.treePane.removeMessage();
        this.controller.update(this.controller.endCompoundEdit());
        this.haltSelect(false);
        this.haltClick(false);
    }

    public Rectangle2D.Float getBackgroundBounds() {
        if (this.doc == null) {
            return null;
        }
        Element bg = this.doc.getElementById("model-background");
        if (bg == null) {
            return null;
        }
        GraphicsNode node = this.getUpdateManager().getBridgeContext().getGraphicsNode(bg);
        if (node == null) {
            return null;
        }
        Rectangle2D r = node.getGlobalTransform().createTransformedShape(node.getBounds()).getBounds2D();
        return new Rectangle2D.Float((float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight());
    }

    public Rectangle2D.Float getCollectiveBounds(Vector<HierarchicalNode> nodes) {
        DrawableObject firstNode = this.getDrawable(nodes.firstElement());
        DrawableObject lastNode = this.getDrawable(nodes.lastElement());
        Rectangle2D.Float firstBounds = firstNode.getBounds();
        Rectangle2D.Float lastBounds = lastNode.getBounds();
        Position.Pnt firstPos = firstNode.getPos().first();
        Position.Pnt lastPos = lastNode.getPos().first();
        Rectangle2D.Float bounds = new Rectangle2D.Float();
        if (this.isHorizontal()) {
            bounds.height = (float)(0.5 * (double)firstBounds.height + 0.5 * (double)lastBounds.height + (double)lastPos.y - (double)firstPos.y);
            bounds.width = firstBounds.width;
        } else {
            bounds.width = (float)(0.5 * (double)firstBounds.width + 0.5 * (double)lastBounds.width + (double)lastPos.x - (double)firstPos.x);
            bounds.height = firstBounds.height;
        }
        return bounds;
    }

    public float getCachedHeight() {
        return this.cachedHeight;
    }

    public float getCachedWidth() {
        return this.cachedWidth;
    }

    public float getCachedX() {
        return this.cachedX;
    }

    public float getCachedY() {
        return this.cachedY;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public TreeControl getControl() {
        return this.tc;
    }

    public HierarchicalController getController() {
        return this.controller;
    }

    public DrawableObject getDrawable(HierarchicalObject obj) {
        return this.getDrawableById(obj.getId());
    }

    public Collection<DrawableObject> getDrawables() {
        return Collections.unmodifiableCollection(this.drawables.values());
    }

    @Override
    public int getId() {
        return this.id;
    }

    public MainFrame getMainframe() {
        return this.mainframe;
    }

    @Override
    public HierarchicalModel getModel() {
        return this.currentModel;
    }

    public Action getPanAction() {
        return this.panAct;
    }

    public Position.Pnt getSelectedPos() {
        if (this.selectedPos == null) {
            return null;
        }
        return this.selectedPos.pos;
    }

    public DrawableObject getSelectedPosObj() {
        return this.selectedPos.obj;
    }

    public Object getSetting(String key) {
        return Settings.get(key, this.getModel(), this);
    }

    public DrawableObject getTargetObject(Element elm) {
        while (elm != null) {
            System.out.println("Target " + elm.getLocalName() + "#" + elm.getAttributeNS(null, "id"));
            String idStr = elm.getAttributeNS(SYNTREENS, "obj");
            if (!idStr.equals("")) {
                int id = Integer.parseInt(idStr);
                return this.getDrawableById(id);
            }
            if (elm.getParentNode() instanceof SVG12OMDocument) break;
            elm = (Element)elm.getParentNode();
        }
        return null;
    }

    @Override
    public Class getType() {
        return TreeView.class;
    }

    public boolean haltClick() {
        return this.haltClick;
    }

    public TreeView haltClick(boolean b) {
        this.haltClick = b;
        return this;
    }

    public boolean haltSelect() {
        return this.haltSelect;
    }

    public TreeView haltSelect(boolean b) {
        this.haltSelect = b;
        return this;
    }

    public void init() {
        this.doc = this.createEmptyDoc();
        this.clearDocument();
        this.addGVTTreeRendererListener(new GVTTreeRendererAdapter(){

            @Override
            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                if (TreeView.this.getUpdateManager() == null || !TreeView.this.isActive) {
                    return;
                }
                TreeView.this.controller.getModel().addObserver(TreeView.this);
                TreeView.this.currentModel = TreeView.this.controller.getModel();
                TreeView.this.controller.getSelectionManager().addObserver(TreeView.this);
                if (TreeView.this.id == 0) {
                    TreeView.this.controller.setUpdateManager(TreeView.this.getUpdateManager());
                }
                TreeView.this.removeGVTTreeRendererListener(this);
                TreeView.this.controller.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreeView.this.update(TreeView.this.currentModel, null);
                    }
                });
                TreeView.this.treePane.zoomRestore();
            }
        });
        this.setSVGDocument(this.doc);
    }

    public boolean isHorizontal() {
        return (Boolean)this.getSetting("tv-horizontal");
    }

    public boolean isInverted() {
        return (Boolean)this.getSetting("tv-inverted");
    }

    public boolean isLowerEndNodes() {
        return (Boolean)this.getSetting("tv-lower-endnodes");
    }

    public void moveTree(DrawableNode drn, float dx, float dy) {
        HierarchicalNode node = (HierarchicalNode)drn.that();
        drn.translate(dx, dy);
        for (HierarchicalBranch branch : node.getBranches()) {
            DrawableBranch drBranch = (DrawableBranch)this.getDrawable(branch);
            drBranch.translate(dx, dy);
            HierarchicalNode child = branch.getChild();
            DrawableNode drChild = (DrawableNode)this.getDrawable(child);
            this.moveTree(drChild, dx, dy);
        }
    }

    public boolean pan() {
        return this.panMode;
    }

    public TreeView pan(boolean b) {
        boolean old = this.panMode;
        this.panMode = b;
        this.firePropChange(PANMODE_PROP, old, b);
        return this;
    }

    public void prepareActivity(TreeActivity act, HierarchicalObject obj) {
        DrawableObject dro = this.getDrawable(obj);
        if (dro != null) {
            act.prepare(dro);
        }
        this.startActivity(act);
    }

    public TreeView setBGColour(Color clr) {
        if (this.doc == null) {
            return null;
        }
        this.doc.getElementById("model-background").setAttributeNS(null, "fill", TreeView.colourToHTML(clr));
        return this;
    }

    public void setSelectedPos(PosDrawable pd) {
        if (this.selectedPos != null) {
            this.selectedPos.selectMe(false);
        }
        this.selectedPos = pd;
        if (pd != null) {
            pd.selectMe(true);
        }
    }

    public void setOrientSetting(boolean horiz, boolean invert) {
        this.getModel().setSetting("tv-horizontal", Boolean.valueOf(horiz));
        this.getModel().setSetting("tv-inverted", Boolean.valueOf(invert));
        this.controller.update(null);
    }

    public void setSetting(String key, Serializable value) {
        this.controller.setSetting(key, value, this);
    }

    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    @Override
    public String settingPrefix() {
        return "TV_";
    }

    public void startActivity(TreeActivity act) {
        if (this.currentAct != null) {
            return;
        }
        this.getController().startCompoundEdit();
        this.haltSelect(true);
        this.haltClick(true);
        this.currentAct = act;
        act.start();
    }

    public void startUserPositioning(DrawableObject obj, Position.Pnt pos) {
        this.startActivity(new UserPositioniser(this, obj, pos));
    }

    public void startUserPositioning(HierarchicalObject obj, Position.Pnt pos) {
        DrawableObject dro = this.getDrawable(obj);
        if (dro == null || !dro.isDrawn()) {
            this.doPositionising = obj;
            this.doPositionisingPos = pos;
            return;
        }
        this.startUserPositioning(dro, pos);
    }

    public void pauseIfSecondary() {
        if (this.updateManager.getUpdateRunnableQueue().getThread() != Thread.currentThread() && this.id != 0 && !SwingUtilities.isEventDispatchThread()) {
            this.updateManager.getUpdateRunnableQueue().suspendExecution(true);
        }
    }

    public void resumeIfSecondary() {
        if (this.updateManager.getUpdateRunnableQueue().getThread() != Thread.currentThread() && this.id != 0 && !SwingUtilities.isEventDispatchThread()) {
            this.updateManager.resume();
        }
    }

    @Override
    public void update(Observable obs, Object arg1) {
        this.controller.endCurrentEditor();
        this.pauseIfSecondary();
        this.validate();
        if (obs instanceof HierarchicalModel) {
            if (this.currentModel != (HierarchicalModel)obs) {
                this.updateModel((HierarchicalModel)obs);
            }
            this.updateSVG(null);
        }
        this.updateSelection();
        this.fireUpdateEvent();
        if (this.getModel().isCentered()) {
            this.centrate();
        }
        if (this.id == 1) {
            this.renderGVTTree();
        }
        this.resumeIfSecondary();
    }

    public static String colourToHTML(Color c) {
        return "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
    }

    public static Iterable<Node> nodeListIterator(final NodeList nl) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.idx < nl.getLength();
                    }

                    @Override
                    public Node next() {
                        return nl.item(this.idx++);
                    }

                    @Override
                    public void remove() {
                        throw new Error("remove() not implementable for NodeList-iterator");
                    }
                };
            }
        };
    }

    public static SVGPoint translatePoint(SVGPoint pnt, Element elm) {
        SVGMatrix mat = ((SVGLocatable)((Object)elm)).getScreenCTM();
        return pnt.matrixTransform(mat.inverse());
    }

    public void end() {
        this.isActive = false;
    }

    private static class PanAction
    extends AbstractAction
    implements PropertyChangeListener {
        private TreeView tv;

        public PanAction(TreeView tv) {
            this.tv = tv;
            this.putValue("ActionSupport-togglable", true);
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/enable-custom-panning.png"));
            this.putValue("SwingSelectedKey", this.tv.pan());
            this.tv.addPropertyChangeListener(TreeView.PANMODE_PROP, this);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.tv.pan(!this.tv.pan());
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            System.out.println("TV.PA get prop: " + arg0.getPropertyName() + " = " + arg0.getNewValue());
            if (arg0.getPropertyName().equals(TreeView.PANMODE_PROP)) {
                this.putValue("SwingSelectedKey", this.tv.pan());
            }
        }
    }
}

