/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram;

import java.util.ArrayList;
import java.util.Vector;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.treediagram.TreePositioner;
import nl.rug.syntree.treediagram.TreeView;

public class VerticalPositioner
extends TreePositioner {
    public VerticalPositioner(TreeView tv) {
        super(tv);
    }

    private float anglifyHeight(HierarchicalNode node, ArrayList<Float> maxHeights, float lowestY, float highestY) {
        float nodeY = this.getPos((HierarchicalNode)node).y;
        float nodeHeight = this.getBounds((HierarchicalNode)node).height;
        lowestY = Math.min(lowestY, nodeY - nodeHeight / 2.0f);
        Vector<HierarchicalNode> nextNodes = this.getNextNodes(node);
        if (nextNodes.size() > 0) {
            float maxChildHeight = maxHeights.get(node.getDepth() + 1).floatValue();
            float childY = nodeY + nodeHeight / 2.0f + maxChildHeight / 2.0f;
            float height = 0.0f;
            float subWidth = this.getPos((HierarchicalNode)nextNodes.lastElement()).x - this.getPos((HierarchicalNode)nextNodes.firstElement()).x;
            float verticalMargin = this.getVerticalMargin();
            if (subWidth == 0.0f) {
                childY += verticalMargin;
            } else {
                float absoluteHeight;
                float maxAngle;
                float subAngle;
                float childIncrement = verticalMargin;
                if (((Boolean)this.tv.getSetting("tv-set-constant-angle")).booleanValue()) {
                    float angle = ((Float)this.tv.getSetting("tv-constant-angle")).floatValue();
                    childIncrement = (float)((double)subWidth / (2.0 * Math.tan(Math.toRadians(0.5 * (double)angle))));
                }
                if (((Boolean)this.tv.getSetting("tv-set-max-angle")).booleanValue() && (subAngle = (float)(2.0 * Math.toDegrees(Math.atan(subWidth / 2.0f / childIncrement)))) > (maxAngle = ((Float)this.tv.getSetting("tv-max-angle")).floatValue())) {
                    childIncrement = (float)((double)subWidth / (2.0 * Math.tan(Math.toRadians(0.5 * (double)maxAngle))));
                }
                if (((Boolean)this.tv.getSetting("tv-set-max-height")).booleanValue() && childIncrement > (absoluteHeight = ((Float)this.tv.getSetting("tv-max-height")).floatValue() / 100.0f * verticalMargin)) {
                    childIncrement = absoluteHeight;
                }
                childY += childIncrement;
            }
            highestY = Math.max(highestY, childY + maxChildHeight / 2.0f);
            for (HierarchicalNode child : nextNodes) {
                Position.Pnt p = this.getPos(child);
                p.y = childY;
                height = Math.max(height, this.anglifyHeight(child, maxHeights, lowestY, highestY));
            }
            return height;
        }
        return highestY - lowestY;
    }

    private float computeHeight(HierarchicalNode node, ArrayList<Float> maxHeights, float offset, float margin) {
        int depth = node.getDepth();
        float ownHeight = this.getBounds((HierarchicalNode)node).height;
        float height = (offset += this.getOffset((HierarchicalNode)node).y) + ownHeight;
        Vector<HierarchicalNode> nextNodes = this.getNextNodes(node);
        for (HierarchicalNode nextNode : nextNodes) {
            height = Math.max(this.computeHeight(nextNode, maxHeights, offset + margin + maxHeights.get(depth).floatValue(), margin), height);
        }
        float y = offset + ownHeight / 2.0f;
        Position.Pnt p = this.getPos(node);
        p.y = y;
        return height;
    }

    private ArrayList<Float> computeMaxHeights(HierarchicalNode root) {
        ArrayList<Float> ret = new ArrayList<Float>();
        return this.computeMaxHeights(root, ret);
    }

    private ArrayList<Float> computeMaxHeights(HierarchicalNode node, ArrayList<Float> maxHeights) {
        float ownHeight = this.getBounds((HierarchicalNode)node).height;
        int depth = node.getDepth();
        if (maxHeights.size() > depth) {
            maxHeights.set(depth, Float.valueOf(Math.max(maxHeights.get(depth).floatValue(), ownHeight)));
        } else {
            int expectedSize = Math.max(maxHeights.size(), depth) + 1;
            while (maxHeights.size() < expectedSize) {
                maxHeights.add(Float.valueOf(0.0f));
            }
            maxHeights.add(depth, Float.valueOf(ownHeight));
        }
        for (HierarchicalNode child : this.getNextNodes(node)) {
            this.computeMaxHeights(child, maxHeights);
        }
        return maxHeights;
    }

    private float computeWidth(HierarchicalNode node, float offset, float margin) throws IllegalStateException {
        float localMargin;
        float ownWidth = this.getBounds((HierarchicalNode)node).width;
        float width = 0.0f;
        float x = 0.0f;
        offset += this.getOffset((HierarchicalNode)node).x;
        Vector<HierarchicalNode> nextNodes = this.getNextNodes(node);
        float f = localMargin = node.isCollapsed() ? 0.0f : margin;
        if (nextNodes.size() > 0) {
            for (HierarchicalNode child : nextNodes) {
                width += this.computeWidth(child, offset + width, margin) + localMargin;
            }
            width -= localMargin;
            float subWidth = this.getPos((HierarchicalNode)nextNodes.lastElement()).x - this.getPos((HierarchicalNode)nextNodes.firstElement()).x;
            if (ownWidth > width) {
                HierarchicalNode leftmostOffspring = node.getTerminals().firstElement();
                float shiftWidth = this.getPos((HierarchicalNode)nextNodes.firstElement()).x - this.getPos((HierarchicalNode)leftmostOffspring).x;
                float firstChildWidth = this.getBounds((HierarchicalNode)leftmostOffspring).width;
                for (HierarchicalNode child : nextNodes) {
                    this.shiftTreeX(child, (ownWidth - subWidth) / 2.0f - shiftWidth - firstChildWidth / 2.0f);
                }
                x = offset + ownWidth / 2.0f;
                width = ownWidth;
            } else {
                x = subWidth / 2.0f + this.getPos((HierarchicalNode)nextNodes.firstElement()).x;
            }
        } else {
            width = ownWidth;
            x = offset + width / 2.0f;
        }
        Position.Pnt p = this.getPos(node);
        p.x = x;
        return width;
    }

    private void invertTree(float height) {
        for (HierarchicalNode node : this.tv.getModel().getRootNodes()) {
            this.invertTree(node, height);
        }
    }

    private void invertTree(HierarchicalNode node, float height) {
        Position.Pnt p = this.getPos(node);
        p.y *= -1.0f;
        Vector<HierarchicalNode> nextNodes = this.getNextNodes(node);
        for (HierarchicalNode next : nextNodes) {
            this.invertTree(next, height);
        }
    }

    private void shiftTreeX(HierarchicalNode node, float delta) {
        Position.Pnt p = this.getPos(node);
        if (p != null) {
            p.x += delta;
        } else {
            throw new Error("Attempt to shift node without Position");
        }
        for (HierarchicalNode next : this.getNextNodes(node)) {
            this.shiftTreeX(next, delta);
        }
    }

    public float anglifyHeight() {
        float maxTreeHeight = 0.0f;
        for (HierarchicalNode rootNode : this.tv.getModel().getRootNodes()) {
            ArrayList<Float> maxHeights;
            float curTreeHeight = this.anglifyHeight(rootNode, maxHeights = this.computeMaxHeights(rootNode), 0.0f, 0.0f);
            maxTreeHeight = curTreeHeight > maxTreeHeight ? curTreeHeight : maxTreeHeight;
        }
        return maxTreeHeight;
    }

    @Override
    public float computeHeight() {
        float height = 0.0f;
        for (HierarchicalNode node : this.tv.getModel().getRootNodes()) {
            ArrayList<Float> maxHeights = this.computeMaxHeights(node);
            height = Math.max(this.computeHeight(node, maxHeights, ((Float)this.tv.getSetting("tv-offset-y")).floatValue(), this.getVerticalMargin()), height);
        }
        if (((Boolean)this.tv.getSetting("tv-set-constant-angle")).booleanValue() || ((Boolean)this.tv.getSetting("tv-set-max-angle")).booleanValue() || ((Boolean)this.tv.getSetting("tv-set-max-height")).booleanValue()) {
            height = this.anglifyHeight();
        }
        return height;
    }

    @Override
    public float computeWidth() {
        float width = ((Float)this.tv.getSetting("tv-offset-x")).floatValue();
        for (HierarchicalNode node : this.tv.getModel().getRootNodes()) {
            width += this.computeWidth(node, width, this.getHorizontalMargin()) + this.getHorizontalMargin();
        }
        return width - this.getHorizontalMargin();
    }

    @Override
    public void invertTree(boolean inverted) {
        if (inverted) {
            this.invertTree(0.0f);
        }
    }

    @Override
    public void lowerEndNodes() {
        for (HierarchicalNode rootNode : this.tv.getModel().getRootNodes()) {
            Vector<HierarchicalNode> endNodes = rootNode.getTerminals();
            boolean invert = this.tv.isInverted();
            float maxY = invert ? Float.MAX_VALUE : Float.MIN_VALUE;
            for (HierarchicalNode endNode : endNodes) {
                float curY = this.getPos((HierarchicalNode)endNode).y;
                if (invert) {
                    maxY = Math.min(curY, maxY);
                    continue;
                }
                maxY = Math.max(curY, maxY);
            }
            for (HierarchicalNode endNode : endNodes) {
                Position.Pnt p = this.getPos(endNode);
                p.y = maxY;
            }
        }
    }
}

