/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.activities;

import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.activities.TreeActivity;
import nl.rug.syntree.treediagram.activities.UserPositioniser;
import nl.rug.syntree.treediagram.drawables.DrawableObject;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGPoint;

public class Anchorizer
implements TreeActivity,
EventListener {
    private TreeView tv;
    private Position.Pnt pnt;
    private boolean paused = false;
    private Element depLignum = null;

    public Anchorizer(TreeView tv, Position.Pnt pnt) {
        this.tv = tv;
        this.pnt = pnt;
    }

    private void move(DOMMouseEvent evt) {
        SVGPoint svpnt = TreeView.translatePoint(new SVGOMPoint(evt.getClientX(), evt.getClientY()), this.tv.rootElm);
        this.depLignum.setAttributeNS(null, "x2", "" + svpnt.getX());
        this.depLignum.setAttributeNS(null, "y2", "" + svpnt.getY());
    }

    private void up(DOMMouseEvent evt) {
        SVGPoint svpnt = TreeView.translatePoint(new SVGOMPoint(evt.getClientX(), evt.getClientY()), this.tv.rootElm);
        DrawableObject target = this.tv.getTargetObject((Element)((Object)evt.getTarget()));
        if (target != null) {
            Position.Pnt p = UserPositioniser.closestPos(target.getPos(), svpnt.getX(), svpnt.getY());
            this.pnt.x = this.pnt.getAbsX() - p.getAbsX();
            this.pnt.y = this.pnt.getAbsY() - p.getAbsY();
            this.pnt.anchor(p);
            System.out.println("Anchorized " + this.pnt + " to " + p);
        } else {
            this.pnt.x = this.pnt.getAbsX();
            this.pnt.y = this.pnt.getAbsY();
            this.pnt.anchor(null);
        }
        evt.stopImmediatePropagation();
        this.end();
    }

    @Override
    public void cancel() {
        this.end();
    }

    @Override
    public void end() {
        if (this.depLignum.getParentNode() != null) {
            this.depLignum.getParentNode().removeChild(this.depLignum);
            this.tv.doc.getRootElement().removeEventListener("mousemove", this, true);
            this.tv.doc.getRootElement().removeEventListener("mousedown", this, true);
            this.tv.endActivity();
        }
    }

    @Override
    public void handleEvent(Event arg0) {
        if (this.paused) {
            return;
        }
        switch (arg0.getType()) {
            case "mousedown": 
            case "mouseup": {
                this.up((DOMMouseEvent)arg0);
                break;
            }
            case "mousemove": {
                this.move((DOMMouseEvent)arg0);
            }
        }
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void prepare(Object dro) {
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    @Override
    public void start() {
        this.depLignum = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "line");
        this.depLignum.setAttributeNS(null, "pointer-events", "none");
        this.depLignum.setAttributeNS(null, "stroke", "#FF0000");
        this.depLignum.setAttributeNS(null, "stroke-width", "2");
        this.depLignum.setAttributeNS(null, "stroke-dasharray", "2");
        this.depLignum.setAttributeNS(null, "x1", "" + this.pnt.getAbsX());
        this.depLignum.setAttributeNS(null, "y1", "" + this.pnt.getAbsY());
        this.depLignum.setAttributeNS(null, "x2", this.pnt.anchor() != null ? "" + this.pnt.anchor().getAbsX() : "0");
        this.depLignum.setAttributeNS(null, "y2", this.pnt.anchor() != null ? "" + this.pnt.anchor().getAbsX() : "0");
        this.tv.annoElm.appendChild(this.depLignum);
        this.tv.doc.getRootElement().addEventListener("mousemove", this, true);
        this.tv.doc.getRootElement().addEventListener("mousedown", this, true);
    }
}

