/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.activities;

import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.activities.TreeActivity;
import nl.rug.syntree.treediagram.drawables.DrawableNode;
import nl.rug.syntree.treediagram.drawables.DrawableObject;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGSVGElement;

public class ChildPendler
implements EventListener,
TreeActivity {
    private DrawableNode drn;
    private HierarchicalNode node;
    private TreeView tv;
    private boolean paused = false;
    private int origPos = 0;

    public ChildPendler(TreeView tv, DrawableNode drn) {
        this.tv = tv;
        this.drn = drn;
        this.node = (HierarchicalNode)this.drn.that();
        this.origPos = this.node.getSiblingIndex();
    }

    private void down(DOMMouseEvent evt) {
        this.end();
    }

    public static int computeSibIdx(TreeView tv, HierarchicalNode node, float ownX) {
        int idx;
        int newIdx = idx = node.getSiblingIndex();
        for (HierarchicalNode sib : node.getParent().getChildren()) {
            if (sib.getId() == node.getId()) continue;
            DrawableObject dro = tv.getDrawable(sib);
            int sibIdx = sib.getSiblingIndex();
            float sibX = dro.getX();
            if (idx < sibIdx && ownX > sibX) {
                newIdx = Math.max(sibIdx, idx);
            }
            if (idx <= sibIdx || !(ownX < sibX)) continue;
            newIdx = Math.min(sibIdx, idx);
        }
        return newIdx;
    }

    private void move(DOMMouseEvent evt) {
        SVGPoint pnt = TreeView.translatePoint(new SVGOMPoint(evt.getClientX(), evt.getClientY()), this.tv.rootElm);
        this.drn.getPos().first().x = pnt.getX();
        this.drn.reposition();
        int oldIdx = this.node.getSiblingIndex();
        int newIdx = ChildPendler.computeSibIdx(this.tv, this.node, pnt.getX());
        if (oldIdx != newIdx) {
            this.tv.getController().moveChild(this.node, newIdx);
            this.tv.getDrawable(this.node.getParent().getBranchFor(this.node)).selectMe(true);
        }
    }

    @Override
    public void cancel() {
        this.tv.getController().moveChild(this.node, this.origPos);
        this.end();
    }

    @Override
    public void end() {
        SVGSVGElement docElm = this.tv.doc.getRootElement();
        this.drn.getGroupElm().removeAttributeNS(null, "pointer-events");
        docElm.removeEventListener("mousemove", this, false);
        docElm.removeEventListener("mouseup", this, false);
        this.drn.reposition();
        this.node.pendle(false);
        System.out.println("CP end");
        this.tv.endActivity();
    }

    @Override
    public void handleEvent(Event arg0) {
        if (this.paused) {
            return;
        }
        switch (arg0.getType()) {
            case "mousemove": {
                this.move((DOMMouseEvent)arg0);
                break;
            }
            case "mouseup": {
                this.down((DOMMouseEvent)arg0);
            }
        }
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void prepare(Object dro) {
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    public void setDrawable(DrawableObject obj) {
        this.drn = (DrawableNode)obj;
        this.node = (HierarchicalNode)this.drn.that();
    }

    @Override
    public void start() {
        SVGSVGElement docElm = this.tv.doc.getRootElement();
        this.drn.getGroupElm().setAttributeNS(null, "pointer-events", "none");
        if (this.drn.getGroupElm().getParentNode() != null) {
            this.drn.getGroupElm().getParentNode().appendChild(this.drn.getGroupElm());
        }
        docElm.addEventListener("mousemove", this, false);
        docElm.addEventListener("mouseup", this, false);
        System.out.println("CP start");
    }
}

