/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.activities;

import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.activities.ChildPendler;
import nl.rug.syntree.treediagram.activities.TreeActivity;
import nl.rug.syntree.treediagram.drawables.DrawableNode;
import nl.rug.syntree.treediagram.drawables.DrawableObject;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGSVGElement;

public class NodeMover
implements TreeActivity,
EventListener {
    private boolean paused;
    private DrawableNode drn;
    private HierarchicalNode node;
    private TreeView tv;
    private boolean firstMove = true;
    private float prevX;
    private float prevY;
    private float initX;
    private float initY;

    public NodeMover(TreeView tv, DrawableNode drn) {
        this.tv = tv;
        this.drn = drn;
        this.node = (HierarchicalNode)drn.that();
        this.prevX = 0.0f;
        this.prevY = 0.0f;
    }

    private void drop(DOMMouseEvent evt) {
        int newIdx;
        int oldIdx;
        SVGPoint pnt = TreeView.translatePoint(new SVGOMPoint(evt.getClientX(), evt.getClientY()), this.tv.rootElm);
        DrawableObject tgt = this.tv.getTargetObject((Element)((Object)evt.getTarget()));
        if (tgt != null && tgt instanceof DrawableNode && ((DrawableNode)tgt).getId() != this.drn.getId()) {
            if (this.tv.getController().moveSubTree(this.node, (HierarchicalNode)tgt.that())) {
                // empty if block
            }
        } else if (this.node.hasParent() && (oldIdx = this.node.getSiblingIndex()) != (newIdx = ChildPendler.computeSibIdx(this.tv, this.node, pnt.getX()))) {
            this.tv.getController().moveChild(this.node, newIdx);
        }
    }

    private void move(DOMMouseEvent evt) {
        SVGPoint pnt = TreeView.translatePoint(new SVGOMPoint(evt.getClientX(), evt.getClientY()), this.tv.rootElm);
        this.drop(evt);
        if (this.firstMove) {
            this.prevX = pnt.getX();
            this.prevY = pnt.getY();
            this.initX = pnt.getX() - this.drn.getPos().centerX();
            this.initY = pnt.getY() - this.drn.getPos().centerY();
            this.firstMove = false;
            this.tv.moveTree(this.drn, this.initX, this.initY);
        } else {
            this.tv.moveTree(this.drn, pnt.getX() - this.prevX + this.initX, pnt.getY() - this.prevY + this.initY);
        }
        if (this.node.hasParent()) {
            this.tv.getDrawable(this.node.getParent().getBranchFor(this.node)).reposition();
        }
    }

    private void up(DOMMouseEvent evt) {
        this.drop(evt);
        this.end();
    }

    @Override
    public void cancel() {
        this.end();
    }

    @Override
    public void end() {
        SVGSVGElement docElm = this.tv.doc.getRootElement();
        this.drn.getGroupElm().removeAttributeNS(null, "pointer-events");
        docElm.removeEventListener("mousemove", this, false);
        docElm.removeEventListener("mouseup", this, false);
        this.drn.reposition();
        this.tv.endActivity();
    }

    @Override
    public void handleEvent(Event arg0) {
        if (this.paused) {
            return;
        }
        switch (arg0.getType()) {
            case "mousedown": 
            case "mouseup": {
                this.up((DOMMouseEvent)arg0);
                break;
            }
            case "mousemove": {
                this.move((DOMMouseEvent)arg0);
            }
        }
    }

    @Override
    public void pause() {
        this.paused = true;
        this.firstMove = true;
    }

    @Override
    public void prepare(Object dro) {
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    @Override
    public void start() {
        SVGSVGElement docElm = this.tv.doc.getRootElement();
        this.drn.getGroupElm().setAttributeNS(null, "pointer-events", "none");
        if (this.drn.getGroupElm().getParentNode() != null) {
            this.drn.getGroupElm().getParentNode().appendChild(this.drn.getGroupElm());
        }
        docElm.addEventListener("mousemove", this, false);
        docElm.addEventListener("mouseup", this, false);
    }
}

