/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.activities;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.activities.TreeActivity;
import nl.rug.syntree.treediagram.drawables.DrawableObject;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGSVGElement;

public class Selecter
implements TreeActivity,
EventListener {
    private TreeView tv;
    private Element rect;
    private boolean paused;
    private float x1;
    private float y1;
    private float x2;
    private float y2;

    public Selecter(TreeView tv, DOMMouseEvent evt) {
        this.tv = tv;
        SVGPoint pnt = TreeView.translatePoint(new SVGOMPoint(evt.getClientX(), evt.getClientY()), this.tv.doc.getRootElement());
        this.x1 = pnt.getX();
        this.y1 = pnt.getY();
    }

    @Override
    public void cancel() {
        this.end();
    }

    @Override
    public void end() {
        System.out.println("Selecter end");
        if (this.rect != null && this.rect.getParentNode() != null) {
            this.rect.getParentNode().removeChild(this.rect);
        }
        SVGSVGElement docElm = this.tv.doc.getRootElement();
        docElm.removeEventListener("mousemove", this, false);
        docElm.removeEventListener("mouseup", this, false);
        this.tv.endActivity();
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void prepare(Object dro) {
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    @Override
    public void start() {
        System.out.println("Selecter start");
        SVGSVGElement docElm = this.tv.doc.getRootElement();
        this.rect = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "rect");
        this.rect.setAttributeNS(null, "fill", TreeView.colourToHTML((Color)this.tv.getSetting("selection-colour")));
        this.rect.setAttributeNS(null, "opacity", "0.3");
        this.rect.setAttributeNS(null, "x", "" + this.x1);
        this.rect.setAttributeNS(null, "y", "" + this.y1);
        this.rect.setAttributeNS(null, "width", "1");
        this.rect.setAttributeNS(null, "height", "1");
        docElm.appendChild(this.rect);
        docElm.addEventListener("mousemove", this, false);
        docElm.addEventListener("mouseup", this, false);
    }

    private void up(DOMMouseEvent evt) {
        evt.stopImmediatePropagation();
        evt.preventDefault();
        GraphicsNode node = this.tv.getUpdateManager().getBridgeContext().getGraphicsNode(this.rect);
        Rectangle2D bgBounds = node.getGlobalTransform().createTransformedShape(node.getBounds()).getBounds2D();
        Vector<HierarchicalObject> objs = new Vector<HierarchicalObject>();
        for (DrawableObject dro : this.tv.getDrawables()) {
            Rectangle2D.Float bounds = dro.getBounds();
            if (!bgBounds.contains(bounds)) continue;
            objs.add(dro.that());
        }
        this.end();
        this.tv.getController().selectObjects(objs);
    }

    private void move(DOMMouseEvent evt) {
        SVGPoint pnt = TreeView.translatePoint(new SVGOMPoint(evt.getClientX(), evt.getClientY()), this.rect);
        this.x2 = pnt.getX();
        this.y2 = pnt.getY();
        if (this.x2 > this.x1) {
            this.rect.setAttributeNS(null, "x", "" + this.x1);
            this.rect.setAttributeNS(null, "width", "" + (this.x2 - this.x1));
        } else {
            this.rect.setAttributeNS(null, "x", "" + this.x2);
            this.rect.setAttributeNS(null, "width", "" + (this.x1 - this.x2));
        }
        if (this.y2 > this.y1) {
            this.rect.setAttributeNS(null, "y", "" + this.y1);
            this.rect.setAttributeNS(null, "height", "" + (this.y2 - this.y1));
        } else {
            this.rect.setAttributeNS(null, "y", "" + this.y2);
            this.rect.setAttributeNS(null, "height", "" + (this.y1 - this.y2));
        }
    }

    @Override
    public void handleEvent(Event arg0) {
        if (this.paused) {
            return;
        }
        switch (arg0.getType()) {
            case "mouseup": {
                this.up((DOMMouseEvent)arg0);
                break;
            }
            case "mousemove": {
                this.move((DOMMouseEvent)arg0);
            }
        }
    }
}

