/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.activities;

import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.annotations.TreeOffset;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.activities.TreeActivity;
import nl.rug.syntree.treediagram.drawables.DrawableNode;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGSVGElement;

public class TreeMover
implements TreeActivity,
EventListener {
    private boolean paused;
    private DrawableNode drn;
    private HierarchicalNode node;
    private TreeView tv;
    private boolean firstMove = true;
    private float prevX;
    private float prevY;
    private float initX;
    private float initY;
    private float tgtX;
    private float tgtY;
    private TreeOffset offset;

    public TreeMover(TreeView tv, DrawableNode drn) {
        this.tv = tv;
        this.drn = drn;
        this.node = (HierarchicalNode)drn.that();
        this.prevX = 0.0f;
        this.prevY = 0.0f;
        this.tgtX = 0.0f;
        this.tgtY = 0.0f;
        this.offset = (TreeOffset)this.node.getTweakByType(TreeOffset.class);
        if (this.offset == null) {
            this.offset = new TreeOffset(0.0f, 0.0f);
        }
    }

    private void move(DOMMouseEvent evt) {
        SVGPoint pnt = TreeView.translatePoint(new SVGOMPoint(evt.getClientX(), evt.getClientY()), this.tv.rootElm);
        if (this.firstMove) {
            this.prevX = pnt.getX();
            this.prevY = pnt.getY();
            this.initX = pnt.getX() - this.drn.getPos().centerX();
            this.initY = pnt.getY() - this.drn.getPos().centerY();
            this.firstMove = false;
            this.tgtX = this.initX;
            this.tgtY = this.initY;
        } else {
            this.tgtX = pnt.getX() - this.prevX + this.initX;
            this.tgtY = pnt.getY() - this.prevY + this.initY;
        }
        this.tv.moveTree(this.drn, this.tgtX, this.tgtY);
        if (this.node.hasParent()) {
            this.tv.getDrawable(this.node.getParent().getBranchFor(this.node)).reposition();
        }
    }

    private void up(DOMMouseEvent evt) {
        this.offset.x = this.tgtX + this.offset.x;
        this.offset.y = this.tgtY + this.offset.y;
        this.node.addTweak(this.offset);
        this.end();
    }

    @Override
    public void cancel() {
        this.end();
    }

    @Override
    public void end() {
        SVGSVGElement docElm = this.tv.doc.getRootElement();
        this.drn.getGroupElm().removeAttributeNS(null, "pointer-events");
        docElm.removeEventListener("mousemove", this, false);
        docElm.removeEventListener("mouseup", this, false);
        this.drn.reposition();
        this.tv.endActivity();
    }

    @Override
    public void handleEvent(Event arg0) {
        if (this.paused) {
            return;
        }
        switch (arg0.getType()) {
            case "mousedown": 
            case "mouseup": {
                this.up((DOMMouseEvent)arg0);
                break;
            }
            case "mousemove": {
                this.move((DOMMouseEvent)arg0);
            }
        }
    }

    @Override
    public void pause() {
        this.paused = true;
        this.firstMove = true;
    }

    @Override
    public void prepare(Object dro) {
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    @Override
    public void start() {
        SVGSVGElement docElm = this.tv.doc.getRootElement();
        this.drn.getGroupElm().setAttributeNS(null, "pointer-events", "none");
        if (this.drn.getGroupElm().getParentNode() != null) {
            this.drn.getGroupElm().getParentNode().appendChild(this.drn.getGroupElm());
        }
        docElm.addEventListener("mousemove", this, false);
        docElm.addEventListener("mouseup", this, false);
    }
}

