/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.activities;

import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.activities.TreeActivity;
import nl.rug.syntree.treediagram.drawables.DrawableObject;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGSVGElement;

public class UserPositioniser
implements EventListener,
TreeActivity {
    public DrawableObject obj;
    private TreeView tv;
    public Position.Pnt dragPoint;
    private Position.Pnt oldPnt;
    private float initX = 0.0f;
    private float initY = 0.0f;
    private boolean paused = false;
    private float origX = 0.0f;
    private float origY = 0.0f;

    public UserPositioniser(TreeView tv, DrawableObject obj, Position.Pnt point) {
        this.tv = tv;
        this.obj = obj;
        this.dragPoint = point;
        this.origX = this.dragPoint.x;
        this.origY = this.dragPoint.y;
        this.initX = this.dragPoint.getAbsX() - this.dragPoint.x;
        this.initY = this.dragPoint.getAbsY() - this.dragPoint.y;
        point.target(null);
    }

    public UserPositioniser(TreeView tv, HierarchicalObject obj, Position.Pnt point) {
        this(tv, (DrawableObject)null, point);
    }

    private void move(DOMMouseEvent evt) {
        SVGPoint pnt = TreeView.translatePoint(new SVGOMPoint(evt.getClientX(), evt.getClientY()), this.tv.rootElm);
        this.dragPoint.x = pnt.getX() - this.initX;
        this.dragPoint.y = pnt.getY() - this.initY;
        this.obj.reposition();
    }

    private void up(DOMMouseEvent evt) {
        DrawableObject target = this.tv.getTargetObject((Element)((Object)evt.getTarget()));
        System.out.println("UP Drop on " + (target != null ? target.that() : evt.getTarget()));
        if (target != null && target.that().getId() != this.obj.getId()) {
            SVGPoint pnt = TreeView.translatePoint(new SVGOMPoint(evt.getClientX(), evt.getClientY()), this.tv.rootElm);
            this.dragPoint.anchor(target.getPos().centerPos());
            this.dragPoint.target(target.that());
            this.dragPoint.x = 0.0f;
            this.dragPoint.y = 0.0f;
            target.reposition();
        }
        this.end();
    }

    @Override
    public void cancel() {
        this.dragPoint.x = this.origX;
        this.dragPoint.y = this.origY;
        this.dragPoint.anchor(this.oldPnt.anchor());
        this.dragPoint.target(this.oldPnt.target());
        this.end();
    }

    @Override
    public void end() {
        SVGSVGElement docElm = this.tv.doc.getRootElement();
        this.obj.getGroupElm().removeAttributeNS(null, "pointer-events");
        docElm.removeEventListener("mousemove", this, true);
        docElm.removeEventListener("mouseup", this, true);
        this.obj.reposition();
        this.tv.getController().selectOnly(this.obj.that());
        System.out.println("UP end");
        this.tv.endActivity();
    }

    @Override
    public void handleEvent(Event arg0) {
        if (this.paused) {
            return;
        }
        switch (arg0.getType()) {
            case "mousemove": {
                this.move((DOMMouseEvent)arg0);
                break;
            }
            case "mouseup": {
                this.up((DOMMouseEvent)arg0);
            }
        }
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void prepare(Object dro) {
        if (!(dro instanceof DrawableObject)) {
            return;
        }
        this.obj = (DrawableObject)dro;
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    @Override
    public void start() {
        SVGSVGElement docElm = this.tv.doc.getRootElement();
        this.oldPnt = this.dragPoint.createCopy();
        this.obj.getGroupElm().setAttributeNS(null, "pointer-events", "none");
        if (this.obj.getGroupElm().getParentNode().getFirstChild() != this.obj.getGroupElm()) {
            this.obj.getGroupElm().getParentNode().insertBefore(this.obj.getGroupElm(), this.obj.getGroupElm().getParentNode().getFirstChild());
        }
        docElm.addEventListener("mousemove", this, true);
        docElm.addEventListener("mouseup", this, true);
    }

    public static Position.Pnt closestPos(Position pos, float x, float y) {
        Position.Pnt ret = pos.centerPos();
        for (Position.Pnt p : pos) {
            float dy;
            float rx = ret.getAbsX() - x;
            float ry = ret.getAbsY() - y;
            float dx = p.getAbsX() - x;
            if (!(dx * dx + (dy = p.getAbsY() - y) * dy < rx * rx + ry * ry)) continue;
            ret = p;
        }
        return ret;
    }
}

