/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.drawables;

import java.awt.geom.Rectangle2D;
import java.util.Vector;
import nl.rug.syntree.Settings;
import nl.rug.syntree.hierarchicalmodel.HierarchicalBranch;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.actions.BranchShapeAction;
import nl.rug.syntree.hierarchicalmodel.actions.BranchStyleAction;
import nl.rug.syntree.hierarchicalmodel.annotations.Hidden;
import nl.rug.syntree.hierarchicalmodel.annotations.Line;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.mainview.components.ActionGroup;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.DrawableLine;
import nl.rug.syntree.treediagram.drawables.DrawableObject;

public class DrawableBranch
extends DrawableLine {
    private static final String[] dashArrays = new String[]{"0,0", "5,6", "1,5"};
    private HierarchicalBranch branch;

    public DrawableBranch(TreeView tv, HierarchicalBranch branch) {
        super(tv, new Line(tv.getModel(), new Position.Pnt[0]));
        this.computeHere = false;
        this.branch = branch;
        this.pos = this.line.getPos();
        super.grabTweaks();
    }

    private float getChildMargin() {
        return this.branch.getChild().getTweakByType(Hidden.class) == null ? (float)this.getThickness() : 0.0f;
    }

    private float getParentMargin() {
        return this.branch.getParent().getTweakByType(Hidden.class) == null ? (float)this.getThickness() : 0.0f;
    }

    private Position angulated1(Position.Pnt parentPos, Position.Pnt childPos, Rectangle2D.Float pBounds, Rectangle2D.Float cBounds) {
        Position.Pnt middlePos = new Position.Pnt(parentPos, this.branch);
        if (this.tv.isHorizontal()) {
            if (cBounds.getCenterY() < pBounds.getMinY()) {
                parentPos.y = -pBounds.height / 2.0f - this.getParentMargin();
                parentPos.x = 0.0f;
                middlePos.y = childPos.getAbsY() - parentPos.getAbsY();
            } else if (cBounds.getCenterY() > pBounds.getMaxY()) {
                parentPos.y = pBounds.height / 2.0f + this.getParentMargin();
                parentPos.x = 0.0f;
                middlePos.y = childPos.getAbsY() - parentPos.getAbsY();
            } else {
                parentPos.y = parentPos.y > childPos.y ? (parentPos.y += pBounds.height / 2.0f) : (parentPos.y -= pBounds.height / 2.0f);
                parentPos.y += childPos.getAbsY() - parentPos.getAbsY();
                parentPos.x = pBounds.width / 2.0f + this.getParentMargin();
                middlePos.y = 0.0f;
                middlePos.x = 0.0f;
            }
            childPos.x = -cBounds.width / 2.0f - this.getChildMargin();
        } else {
            if (cBounds.getCenterX() < pBounds.getMinX()) {
                parentPos.x = -pBounds.width / 2.0f - this.getParentMargin();
                parentPos.y = 0.0f;
                middlePos.x = childPos.getAbsX() - parentPos.getAbsX();
            } else if (cBounds.getCenterX() > pBounds.getMaxX()) {
                parentPos.x = pBounds.width / 2.0f + this.getParentMargin();
                parentPos.y = 0.0f;
                middlePos.x = childPos.getAbsX() - parentPos.getAbsX();
            } else {
                parentPos.x = parentPos.x > childPos.x ? (parentPos.x += pBounds.width / 2.0f) : (parentPos.x -= pBounds.width / 2.0f);
                parentPos.x += childPos.getAbsX() - parentPos.getAbsX();
                parentPos.y = pBounds.height / 2.0f;
                middlePos.x = 0.0f;
                middlePos.y = 0.0f;
            }
            childPos.y = -cBounds.height / 2.0f - this.getChildMargin();
        }
        return new Position(parentPos, middlePos, childPos);
    }

    private Position angulated2(Position.Pnt parentPos, Position.Pnt childPos, Rectangle2D.Float pBounds, Rectangle2D.Float cBounds) {
        Position.Pnt lineSplitPos = new Position.Pnt(parentPos, this.branch);
        Position.Pnt middlePos = new Position.Pnt(lineSplitPos, this.branch);
        if (this.tv.isHorizontal()) {
            childPos.y = 0.0f;
            parentPos.x = pBounds.width / 2.0f + this.getParentMargin();
            lineSplitPos.x = ((Float)this.tv.getSetting("tv-horizontal-perc")).floatValue() / 100.0f * ((Float)this.tv.getSetting("tv-horizontal-margin")).floatValue() / 2.0f;
            middlePos.y = childPos.getAbsY() - parentPos.getAbsY();
            if (cBounds.getMinY() + cBounds.getHeight() / 3.0 < pBounds.getCenterY() && cBounds.getMaxY() - cBounds.getHeight() / 3.0 > pBounds.getCenterY() && this.branch.getParent().getChildren().size() > 2) {
                middlePos.y = 0.0f;
                childPos.y -= childPos.getAbsY() - parentPos.getAbsY();
            }
            childPos.x = -cBounds.width / 2.0f - this.getChildMargin();
        } else {
            childPos.x = 0.0f;
            parentPos.y = pBounds.height / 2.0f + this.getParentMargin();
            lineSplitPos.y = ((Float)this.tv.getSetting("tv-vertical-perc")).floatValue() / 100.0f * ((Float)this.tv.getSetting("tv-vertical-margin")).floatValue() / 2.0f;
            middlePos.x = childPos.getAbsX() - parentPos.getAbsX();
            if (cBounds.getMinX() + cBounds.getWidth() / 3.0 < pBounds.getCenterX() && cBounds.getMaxX() - cBounds.getWidth() / 3.0 > pBounds.getCenterX() && this.branch.getParent().getChildren().size() > 2) {
                middlePos.x = 0.0f;
                childPos.x -= childPos.getAbsX() - parentPos.getAbsX();
            }
            childPos.y = -cBounds.height / 2.0f - this.getChildMargin();
        }
        return new Position(parentPos, lineSplitPos, middlePos, childPos);
    }

    private Position default0(Position.Pnt parentPos, Position.Pnt childPos, Rectangle2D.Float pBounds, Rectangle2D.Float cBounds) {
        if (this.tv.isHorizontal()) {
            parentPos.x = pBounds.width / 2.0f + this.getParentMargin();
            childPos.x = -cBounds.width / 2.0f - this.getChildMargin();
        } else {
            parentPos.y = pBounds.height / 2.0f + this.getParentMargin();
            childPos.y = -cBounds.height / 2.0f - this.getChildMargin();
        }
        return new Position(parentPos, childPos);
    }

    private Position dendrogram(Position.Pnt parentPos, Position.Pnt childPos, Rectangle2D.Float pBounds, Rectangle2D.Float cBounds) {
        Position.Pnt middlePos = new Position.Pnt(parentPos, this.branch);
        if (this.tv.isHorizontal()) {
            parentPos.x = pBounds.width / 2.0f + this.getParentMargin();
            middlePos.x = 0.0f;
            middlePos.y = childPos.getAbsY() - parentPos.getAbsY();
            childPos.x = -cBounds.width / 2.0f - this.getChildMargin();
        } else {
            parentPos.y = pBounds.height / 2.0f + this.getParentMargin();
            middlePos.x = childPos.getAbsX() - parentPos.getAbsX();
            middlePos.y = 0.0f;
            childPos.y = -cBounds.height / 2.0f - this.getChildMargin();
        }
        return new Position(parentPos, middlePos, childPos);
    }

    private Settings.BranchType getType() {
        if (this.branch.isTriangle() || this.branch.getParent().isCollapsed()) {
            return Settings.BranchType.TRIANGLE;
        }
        return (Settings.BranchType)((Object)this.tv.getSetting("tv-branch-type"));
    }

    private Position linkedsister(Position.Pnt parentPos, Position.Pnt childPos, Rectangle2D.Float pBounds, Rectangle2D.Float cBounds) {
        Position.Pnt middlePos = new Position.Pnt(childPos, this.branch);
        if (this.tv.isHorizontal()) {
            childPos.y = 0.0f;
            middlePos.x = 0.0f;
            parentPos.x = pBounds.width / 2.0f + this.getParentMargin();
            childPos.x = -cBounds.width / 2.0f - this.getChildMargin();
            if (cBounds.getCenterY() < pBounds.getMinY()) {
                childPos.y = -cBounds.height / 2.0f - this.getChildMargin();
            } else if (cBounds.getCenterY() > pBounds.getMaxY()) {
                childPos.y = cBounds.height / 2.0f + this.getChildMargin();
            }
            middlePos.y = parentPos.getAbsY() - childPos.getAbsY();
        } else {
            childPos.x = 0.0f;
            middlePos.y = 0.0f;
            parentPos.y = pBounds.height / 2.0f + this.getParentMargin();
            childPos.y = -cBounds.height / 2.0f - this.getChildMargin();
            if (cBounds.getCenterX() < pBounds.getMinX()) {
                childPos.x = -cBounds.width / 2.0f - this.getChildMargin();
            } else if (cBounds.getCenterX() > pBounds.getMaxX()) {
                childPos.x = cBounds.width / 2.0f + this.getChildMargin();
            }
            middlePos.x = parentPos.getAbsX() - childPos.getAbsX();
        }
        return new Position(parentPos, middlePos, childPos);
    }

    private void repos() {
        Position.Pnt childPos;
        Rectangle2D.Float cBounds;
        HierarchicalNode childNode = this.branch.getChild();
        HierarchicalNode parentNode = this.branch.getParent();
        if (parentNode == null) {
            System.out.println("DrBr has no parent: " + this.that() + " (" + childNode + ")");
        }
        if (this.tv.getDrawable(parentNode) == null) {
            System.out.println("DrBr parent not drawn: " + parentNode);
        }
        Rectangle2D.Float pBounds = this.tv.getDrawable(parentNode).getBounds();
        Position.Pnt parentPos = new Position.Pnt(this.tv.getDrawable(parentNode).getPos().centerPos(), this.branch);
        if (parentNode.isCollapsed()) {
            Position.Pnt centerPos;
            Vector<HierarchicalNode> terminals = parentNode.getFirstExpandedOffspring();
            if (terminals.isEmpty()) {
                cBounds = new Rectangle2D.Float();
                cBounds.height = 20.0f;
                cBounds.width = 20.0f;
                centerPos = new Position.Pnt(parentPos, this.branch);
                if (this.tv.isHorizontal()) {
                    centerPos.x = 50.0f;
                } else {
                    centerPos.y = 50.0f;
                }
            } else {
                cBounds = this.tv.getCollectiveBounds(terminals);
                DrawableObject firstNode = this.tv.getDrawable(terminals.firstElement());
                Position.Pnt firstPos = firstNode.getPos().first();
                centerPos = new Position.Pnt(firstPos, this.branch);
                if (this.tv.isHorizontal()) {
                    centerPos.y = cBounds.height / 2.0f - firstNode.getBounds().height / 2.0f;
                } else {
                    centerPos.x = cBounds.width / 2.0f - firstNode.getBounds().width / 2.0f;
                }
            }
            childPos = new Position.Pnt(centerPos, this.branch);
        } else {
            cBounds = this.tv.getDrawable(childNode).getBounds();
            childPos = new Position.Pnt(this.tv.getDrawable(childNode).getPos().centerPos(), this.branch);
        }
        if (pBounds == null || cBounds == null) {
            return;
        }
        switch (this.getType()) {
            case ANGULATED1: {
                this.pos = this.angulated1(parentPos, childPos, pBounds, cBounds);
                break;
            }
            case ANGULATED2: {
                this.pos = this.angulated2(parentPos, childPos, pBounds, cBounds);
                break;
            }
            case LINKEDSISTER: {
                this.pos = this.linkedsister(parentPos, childPos, pBounds, cBounds);
                break;
            }
            case DENDROGRAM: {
                this.pos = this.dendrogram(parentPos, childPos, pBounds, cBounds);
                break;
            }
            case TRIANGLE: {
                this.pos = this.triangular(parentPos, childPos, pBounds, cBounds);
                break;
            }
            default: {
                this.pos = this.default0(parentPos, childPos, pBounds, cBounds);
            }
        }
        boolean horiz = this.tv.isHorizontal();
        if (this.tv.isInverted()) {
            for (Position.Pnt pos : this.pos) {
                if (horiz) {
                    pos.x *= -1.0f;
                    continue;
                }
                pos.y *= -1.0f;
            }
        }
        this.line.setPos(this.pos);
    }

    private void styleLine() {
        this.group.setAttributeNS("http://let.webhosting.rug.nl/incpar/", "syntree:branch", "" + this.branch.getId());
        this.group.setAttributeNS("http://let.webhosting.rug.nl/incpar/", "syntree:parent", "" + this.branch.getParent().getId());
        this.group.setAttributeNS("http://let.webhosting.rug.nl/incpar/", "syntree:child", "" + this.branch.getChild().getId());
        this.polyEl.setAttributeNS(null, "stroke-width", "" + super.getThickness());
        if (this.branch.getChild().pendle()) {
            this.polyEl.setAttributeNS(null, "stroke", "" + TreeView.colourToHTML(super.getColour("tv-line-warning-colour")));
            this.polyEl.setAttributeNS(null, "stroke-dasharray", dashArrays[2]);
        } else {
            this.polyEl.setAttributeNS(null, "stroke-dasharray", dashArrays[this.branch.getStyle()]);
            if (this.branch.getParent().isCollapsed()) {
                this.polyEl.setAttributeNS(null, "stroke", "" + TreeView.colourToHTML(super.getColour("tv-line-warning-colour")));
            } else {
                this.polyEl.setAttributeNS(null, "stroke", "" + TreeView.colourToHTML(super.getColour("tv-line-colour")));
            }
        }
        this.bgEl.setAttributeNS(null, "stroke", "" + TreeView.colourToHTML(super.getColour("tv-line-colour")));
        this.bgEl.setAttributeNS(null, "stroke-width", "" + super.getThickness() * 2);
    }

    private Position triangular(Position.Pnt parentPos, Position.Pnt childPos, Rectangle2D.Float pBounds, Rectangle2D.Float cBounds) {
        Position.Pnt middlePos = new Position.Pnt(childPos, this.branch);
        Position.Pnt reParentPos = new Position.Pnt(parentPos, this.branch);
        if (this.tv.isHorizontal()) {
            middlePos.x = 0.0f;
            middlePos.y = -cBounds.height;
            parentPos.x = pBounds.width / 2.0f + this.getParentMargin();
            childPos.x = -cBounds.width / 2.0f - this.getChildMargin();
            childPos.y = cBounds.height / 2.0f;
        } else {
            middlePos.x = -cBounds.width;
            middlePos.y = 0.0f;
            parentPos.y = pBounds.height / 2.0f + this.getParentMargin();
            childPos.x = cBounds.width / 2.0f;
            childPos.y = -cBounds.height / 2.0f - this.getChildMargin();
        }
        return new Position(parentPos, middlePos, childPos, reParentPos);
    }

    @Override
    protected void doAnchorPoints(boolean ad) {
    }

    @Override
    public void draw() {
        this.makeGroup();
        super.makeLines();
        this.update(this.branch);
        this.appendGroup();
    }

    @Override
    public ActionGroup getActions() {
        ActionGroup ret = super.getActions(true);
        ret.removeAction(this.tv.getControl().getAnchorizeAction());
        ret.add(this.title(), new ActionGroup(this.tv.getController().getAction(BranchStyleAction.class)));
        ret.add(this.title(), new ActionGroup(this.tv.getController().getAction(BranchShapeAction.class)));
        ret.add(this.title(), this.tv.getControl().getChangeThicknessActions());
        return ret;
    }

    @Override
    public int getId() {
        return this.branch.getId();
    }

    @Override
    public String getIDPrefix() {
        return "branch";
    }

    @Override
    public void reposition() {
        this.repos();
        super.reposition();
    }

    @Override
    public HierarchicalObject that() {
        return this.branch;
    }

    @Override
    public String title() {
        return "Branch";
    }

    @Override
    public boolean update(Object obj) {
        if (!(obj instanceof HierarchicalBranch)) {
            return false;
        }
        this.repos();
        super.update(this.line);
        this.styleLine();
        return true;
    }
}

