/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.drawables;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import nl.rug.syntree.Settings;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Document;
import nl.rug.syntree.hierarchicalmodel.nodecontent.DocumentContent;
import nl.rug.syntree.mainview.UIUtilities;
import nl.rug.syntree.mainview.components.ActionGroup;
import nl.rug.syntree.treediagram.EditLabelOverlay;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.DrawableObject;
import nl.rug.syntree.treediagram.drawables.StyleToCSSConverter;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGOMRect;
import org.apache.batik.dom.svg12.SVGOMFlowDivElement;
import org.apache.batik.dom.svg12.SVGOMFlowParaElement;
import org.apache.batik.dom.svg12.SVGOMFlowSpanElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGRect;

public class DrawableDocument
extends DrawableObject {
    protected Element flowRoot;
    protected SVGOMFlowDivElement flowDiv;
    protected Element flowPath;
    protected Element bg;
    protected Element testPath;
    protected float cachedWidth = 0.0f;
    protected float cachedHeight = 0.0f;
    protected Document objDoc;
    protected DocumentContent doc;
    protected boolean amEditing = false;
    private SVGRect mindims = null;

    private DrawableDocument(TreeView tv) {
        super(tv);
        this.fixed = true;
    }

    public DrawableDocument(TreeView tv, Document doc) {
        this(tv);
        this.objDoc = doc;
        this.doc = doc.content;
    }

    public DrawableDocument(TreeView tv, DocumentContent doc) {
        this(tv);
        this.doc = doc;
    }

    private void buildSVG() {
        while (this.flowDiv.getChildElementCount() > 0) {
            for (Node n : TreeView.nodeListIterator(this.flowDiv.getChildNodes())) {
                this.flowDiv.removeChild(n);
            }
        }
        javax.swing.text.Element root = this.doc.getDefaultRootElement();
        for (int i = 0; i < root.getElementCount(); ++i) {
            Element elm = this.docToSVG(root.getElement(i));
            this.flowDiv.appendChild(elm);
        }
    }

    private SVGRect flowDivDims(SVGOMFlowDivElement flowDiv) {
        SVGOMRect ret = new SVGOMRect(0.0f, 0.0f, 0.0f, 0.0f);
        for (Node n : TreeView.nodeListIterator(flowDiv.getChildNodes())) {
            if (!(n instanceof SVGOMFlowParaElement)) continue;
            SVGRect tmp = this.flowParaDims((SVGOMFlowParaElement)n);
            if (tmp.getWidth() > ret.getWidth()) {
                ret.setWidth(tmp.getWidth());
            }
            ret.setHeight(ret.getHeight() + tmp.getHeight());
        }
        return ret;
    }

    private SVGRect flowParaDims(SVGOMFlowParaElement flowPara) {
        Element text = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "text");
        for (Node n : TreeView.nodeListIterator(flowPara.getChildNodes())) {
            if (!(n instanceof SVGOMFlowSpanElement)) continue;
            this.flowSpanDims((SVGOMFlowSpanElement)n, text);
        }
        this.appendToGroup(text);
        this.appendGroup();
        SVGRect bbox = ((SVGLocatable)((Object)text)).getBBox();
        SVGOMRect ret = new SVGOMRect(0.0f, 0.0f, this.minDimensions().getWidth(), this.minDimensions().getHeight());
        if (bbox != null) {
            ret = new SVGOMRect(0.0f, 0.0f, bbox.getWidth(), bbox.getHeight());
        }
        text.getParentNode().removeChild(text);
        return ret;
    }

    private void flowSpanDims(SVGOMFlowSpanElement flowSpan, Element text) {
        Element tspan = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "tspan");
        tspan.setAttributeNS(null, "style", flowSpan.getAttributeNS(null, "style"));
        tspan.appendChild(flowSpan.getFirstChild().cloneNode(true));
        text.appendChild(tspan);
    }

    private SVGRect minDimensions() {
        if (this.mindims == null) {
            this.mindims = new SVGOMRect(0.0f, 0.0f, 0.0f, 0.0f);
        }
        float minSize = ((Float)this.tv.getSetting("tv-label-min-size")).floatValue();
        this.mindims.setWidth(minSize);
        this.mindims.setHeight(minSize);
        return this.mindims;
    }

    private SVGRect reFlowDivDims(SVGOMFlowDivElement flowDiv) {
        float width = 0.0f;
        float height = 0.0f;
        for (Node n : TreeView.nodeListIterator(flowDiv.getChildNodes())) {
            if (!(n instanceof SVGOMFlowParaElement)) continue;
            SVGRect extent = this.reFlowParaDims((SVGOMFlowParaElement)n);
            width = Math.max(width, extent.getWidth());
            height += extent.getHeight();
        }
        return new SVGOMRect(0.0f, 0.0f, width + 2.0f, height + 2.0f);
    }

    private SVGRect reFlowParaDims(SVGOMFlowParaElement flowPara) {
        float width = 0.0f;
        float height = 0.0f;
        for (int i = 0; i < flowPara.getNumberOfChars(); ++i) {
            SVGRect extent = flowPara.getExtentOfChar(i);
            width += extent.getWidth();
            height = Math.max(height, extent.getHeight());
        }
        return new SVGOMRect(0.0f, 0.0f, width, height);
    }

    private void updateDimensions() {
        float width = this.minDimensions().getWidth();
        float height = this.minDimensions().getHeight();
        if (!this.isHidden()) {
            try {
                SVGRect dimz = this.flowDivDims(this.flowDiv);
                width = dimz.getWidth() * 10.0f;
                height = dimz.getHeight() * 10.0f;
            }
            catch (Exception ex) {
                UIUtilities.handleException(ex, null, this.tv.getModel());
            }
            this.flowPath.setAttributeNS(null, "d", "M0,0 l0.0," + height + " l" + width + "," + 0.0f + " l" + 0.0f + "," + -height + " z");
            try {
                SVGRect extent = this.reFlowDivDims(this.flowDiv);
                width = Math.max(this.minDimensions().getWidth(), extent.getWidth());
                height = Math.max(this.minDimensions().getHeight(), extent.getHeight());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.cachedWidth = width;
        this.cachedHeight = height;
        this.flowPath.setAttributeNS(null, "d", "M" + (double)(-width) / 2.0 + "," + (double)(-height) / 2.0 + " l" + 0.0f + "," + height + " l" + width + "," + 0.0f + " l" + 0.0f + "," + -height + " z");
        this.bg.setAttributeNS(null, "x", "" + -width / 2.0f);
        this.bg.setAttributeNS(null, "y", "" + -height / 2.0f);
        this.bg.setAttributeNS(null, "width", "" + width);
        this.bg.setAttributeNS(null, "height", "" + height);
        this.testPath.setAttributeNS(null, "d", "M" + (double)(-width) / 2.0 + "," + (double)(-height) / 2.0 + " l" + 0.0f + "," + height + " l" + width + "," + 0.0f + " l" + 0.0f + "," + -height + " z");
        this.testPath.setAttributeNS(null, "stroke", "#F00");
        this.testPath.setAttributeNS(null, "stroke-width", "1");
        this.testPath.setAttributeNS(null, "fill", "none");
    }

    protected Color getColour() {
        return super.getColour("tv-node-bg-colour");
    }

    protected Element makeBG() {
        this.bg = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "rect");
        this.bg.setAttributeNS(null, "stroke", TreeView.colourToHTML((Color)this.tv.getSetting("tv-node-bg-colour")));
        this.bg.setAttributeNS(null, "width", "0");
        this.bg.setAttributeNS(null, "height", "0");
        return this.bg;
    }

    protected Element makeFlowRoot() {
        this.flowRoot = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "flowRoot");
        Element flowRegion = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "flowRegion");
        this.flowPath = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "path");
        this.flowDiv = (SVGOMFlowDivElement)this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "flowDiv");
        this.flowRoot.setAttributeNS(null, "fill", "none");
        this.flowPath.setAttributeNS(null, "stroke-width", "0");
        this.flowPath.setAttributeNS(null, "d", "M0,0 l1,1 z");
        flowRegion.appendChild(this.flowPath);
        this.flowRoot.appendChild(flowRegion);
        this.flowRoot.appendChild(this.flowDiv);
        this.appendToGroup(this.flowRoot);
        this.testPath = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "path");
        this.update(this.doc);
        return this.flowRoot;
    }

    public Element docToSVG(javax.swing.text.Element elm) {
        Element ret = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "flowPara");
        AttributeSet attrs = elm.getElement(0).getAttributes();
        ret.setAttributeNS(null, "text-align", StyleToCSSConverter.convertAlignment(attrs.getAttribute(StyleConstants.Alignment)));
        for (int i = 0; i < elm.getElementCount(); ++i) {
            Element child = this.textElmToSVG(elm.getElement(i));
            if (child == null) continue;
            ret.appendChild(child);
        }
        return ret;
    }

    @Override
    public void draw() {
        this.makeBG();
        this.makeGroup();
        this.appendGroup();
        this.appendToGroup(this.bg);
        this.makeFlowRoot();
    }

    public void editLabel() {
        EditLabelOverlay leo = new EditLabelOverlay(this.tv, (SVGOMElement)this.group, this.doc);
        this.tv.getOverlays().add(leo);
        this.tv.getInteractors().add(leo);
        this.amEditing = true;
        leo.start();
    }

    @Override
    public ActionGroup getActions() {
        ActionGroup ret = super.getActions();
        ret.add(this.title(), new ActionGroup(this.tv.getControl().getEditLabelAction()));
        return ret;
    }

    @Override
    public String getIDPrefix() {
        return "textbox";
    }

    @Override
    public void onMouseClick(DOMMouseEvent evt) {
        if (!this.amEditing) {
            super.onMouseClick(evt);
        }
    }

    @Override
    public void onMouseOut(DOMMouseEvent evt) {
        this.selectMe(this.amSelected());
        this.bg.setAttributeNS(null, "stroke-width", "1");
    }

    @Override
    public void onMouseOver(DOMMouseEvent evt) {
        if (this.amSelected()) {
            this.bg.setAttributeNS(null, "stroke-width", "2");
        } else {
            this.bg.setAttributeNS(null, "stroke", TreeView.colourToHTML((Color)this.tv.getSetting("tv-node-hover-colour")));
        }
    }

    @Override
    public void onMouseUp(DOMMouseEvent evt) {
        if (evt.getButton() == 0 && evt.getDetail() == 2 && !evt.getCtrlKey()) {
            this.editLabel();
        }
    }

    @Override
    public void selectMe(boolean b) {
        super.selectMe(b);
        Color clr = b ? (Color)this.tv.getSetting("selection-colour") : this.getColour();
        this.bg.setAttributeNS(null, "stroke", TreeView.colourToHTML(clr));
    }

    public Element textElmToSVG(javax.swing.text.Element elm) {
        String content;
        try {
            content = this.doc.getText(elm.getStartOffset(), elm.getEndOffset() - elm.getStartOffset());
        }
        catch (BadLocationException e1) {
            return null;
        }
        Element ret = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "flowSpan");
        Style s = this.doc.addStyle("", null);
        Settings.defaultStyle(s, this.model);
        AttributeSet attrs = elm.getAttributes();
        s.addAttributes(attrs);
        String css = StyleToCSSConverter.mapToString(StyleToCSSConverter.attrToMap(s));
        ret.setAttributeNS(null, "style", css);
        if (!elm.isLeaf()) {
            for (int i = 0; i < elm.getElementCount(); ++i) {
                ret.appendChild(this.textElmToSVG(elm.getElement(i)));
            }
        } else {
            ret.appendChild(this.tv.doc.createTextNode(content));
        }
        return ret;
    }

    @Override
    public HierarchicalObject that() {
        return this.objDoc != null ? this.objDoc : null;
    }

    @Override
    public String title() {
        return "Note";
    }

    @Override
    public boolean update(Object obj) {
        if (!(obj instanceof StyledDocument) && !(obj instanceof Document)) {
            System.out.println("DrawDoc obj is not StyledDoc: " + obj.getClass().getName());
            return false;
        }
        if (obj instanceof DocumentContent) {
            this.doc = (DocumentContent)obj;
        } else if (obj instanceof Document) {
            this.doc = ((Document)obj).content;
        }
        super.grabTweaks();
        this.buildSVG();
        this.updateDimensions();
        this.bg.setAttributeNS(null, "fill-opacity", "1.0");
        if (this.isHidden()) {
            this.bg.setAttributeNS(null, "fill-opacity", "0.0");
        }
        this.bg.setAttributeNS(null, "fill", TreeView.colourToHTML(this.getColour()));
        if (this.doc.virgin()) {
            this.bg.setAttributeNS(null, "stroke-dasharray", "2,2");
        } else {
            this.bg.removeAttributeNS(null, "stroke-dasharray");
        }
        this.amEditing = false;
        super.update();
        return true;
    }
}

