/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.drawables;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.ArrowHead;
import nl.rug.syntree.hierarchicalmodel.annotations.Line;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.hierarchicalmodel.annotations.Style;
import nl.rug.syntree.mainview.components.ActionGroup;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.DrawableObject;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;

public class DrawableLine
extends DrawableObject {
    protected boolean computeHere = true;
    protected final Line line;
    protected Element polyEl;
    protected Element bgEl;
    private static final int TOP = 1;
    private static final int LEFT = 2;
    private static final int BOTTOM = 4;
    private static final int RIGHT = 8;

    public DrawableLine(TreeView tv, Line line) {
        super(tv);
        this.line = line;
        this.pos = line.getPos();
    }

    private void computeCoords(StringBuilder sb, Position.Pnt posFrom, Position.Pnt posTo, Position.Pnt ctrl1, Position.Pnt ctrl2) {
        Point2D.Float margin;
        Rectangle2D.Float toBounds;
        Point2D.Float from = posFrom.getAbs(this.tv);
        Point2D.Float to = posTo.getAbs(this.tv);
        Point2D.Float prev = from;
        Point2D.Float next = to;
        float diffFromX = 0.0f;
        float diffFromY = 0.0f;
        float diffToX = 0.0f;
        float diffToY = 0.0f;
        if (ctrl1 != null) {
            prev = ctrl1.getAbs();
            next = ctrl1.getAbs();
        }
        if (ctrl2 != null) {
            prev = ctrl2.getAbs();
        }
        Rectangle2D.Float fromBounds = posFrom.target() == null || this.tv.getDrawable(posFrom.target()) == null ? null : this.tv.getDrawable(posFrom.target()).getBounds();
        Rectangle2D.Float float_ = toBounds = posTo.target() == null || this.tv.getDrawable(posTo.target()) == null ? null : this.tv.getDrawable(posTo.target()).getBounds();
        if (fromBounds != null) {
            margin = DrawableLine.pointToMargin(DrawableLine.pointDirection(fromBounds, next), this.getStartMargin());
            next = DrawableLine.nearestPoint(fromBounds, next);
            diffFromX = next.x - (fromBounds.x + fromBounds.width / 2.0f) + margin.x;
            diffFromY = next.y - (fromBounds.y + fromBounds.height / 2.0f) + margin.y;
        }
        if (toBounds != null) {
            prev = DrawableLine.nearestPoint(toBounds, prev);
            margin = DrawableLine.pointToMargin(DrawableLine.pointDirection(toBounds, prev), this.getEndMargin());
            diffToX = prev.x - (toBounds.x + toBounds.width / 2.0f) + margin.x;
            diffToY = prev.y - (toBounds.y + toBounds.height / 2.0f) + margin.y;
        }
        sb.append("M" + (from.x + diffFromX) + "," + (from.y + diffFromY) + " ");
        sb.append(this.lineType());
        if (ctrl1 != null) {
            sb.append(ctrl1.getAbsX() + "," + ctrl1.getAbsY() + " ");
        }
        if (ctrl2 != null) {
            sb.append(ctrl2.getAbsX() + "," + ctrl2.getAbsY() + " ");
        }
        sb.append(to.x + diffToX + "," + (to.y + diffToY) + " ");
    }

    private Color getColour() {
        return super.getColour("tv-line-colour");
    }

    private String lineType() {
        switch (this.line.getCurving()) {
            case 2: {
                return "Q";
            }
            case 3: {
                return "C";
            }
        }
        return "L";
    }

    private void styleEl(Element el) {
        el.setAttributeNS(null, "stroke", TreeView.colourToHTML((Color)this.tv.getSetting("tv-line-colour")));
        el.setAttributeNS(null, "stroke-linecap", "round");
        el.setAttributeNS(null, "stroke-linejoin", "round");
        el.setAttributeNS(null, "stroke-width", "" + this.getThickness());
        el.setAttributeNS(null, "fill", "none");
    }

    protected ActionGroup getActions(boolean sup) {
        return super.getActions();
    }

    protected boolean getEndArrow() {
        ArrowHead ah = (ArrowHead)this.that().getTweakByType(ArrowHead.class);
        if (ah != null) {
            return ah.atEnd;
        }
        return false;
    }

    protected float getEndMargin() {
        if (this.getEndArrow()) {
            return 5.0f;
        }
        return (float)this.getThickness() / 2.0f;
    }

    protected boolean getStartArrow() {
        ArrowHead ah = (ArrowHead)this.that().getTweakByType(ArrowHead.class);
        if (ah != null) {
            return ah.atStart;
        }
        return false;
    }

    protected float getStartMargin() {
        if (this.getStartArrow()) {
            return 5.0f;
        }
        return (float)this.getThickness() / 2.0f;
    }

    protected void makeLines() {
        this.polyEl = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "path");
        this.bgEl = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "path");
        this.styleEl(this.polyEl);
        this.styleEl(this.bgEl);
        this.bgEl.setAttributeNS(null, "stroke-opacity", "0.0");
        this.bgEl.setAttributeNS(null, "stroke-width", "" + this.getThickness() * 2);
        super.appendToGroup(this.bgEl);
        super.appendToGroup(this.polyEl);
    }

    @Override
    public DrawableObject addPos(Position.Pnt p) {
        super.addPos(p);
        this.line.validate();
        return this;
    }

    @Override
    public void draw() {
        this.makeGroup();
        this.makeLines();
        this.update(this.line);
        this.appendGroup();
    }

    @Override
    public ActionGroup getActions() {
        ActionGroup ret = super.getActions();
        ret.add(this.title(), this.tv.getControl().getCurveActions());
        ret.add(this.title(), new ActionGroup(this.tv.getControl().getAddPosAction()));
        ret.add(this.title(), new ActionGroup(this.tv.getControl().getArrowStartAction()));
        ret.add(this.title(), new ActionGroup(this.tv.getControl().getArrowEndAction()));
        return ret.add(this.title(), this.tv.getControl().getChangeThicknessActions());
    }

    @Override
    public String getIDPrefix() {
        return "line";
    }

    @Override
    public void onMouseOut(DOMMouseEvent evt) {
        this.bgEl.setAttributeNS(null, "stroke-opacity", this.amSelected() ? "1.0" : "0.0");
    }

    @Override
    public void onMouseOver(DOMMouseEvent evt) {
        this.bgEl.setAttributeNS(null, "stroke-opacity", "1.0");
    }

    @Override
    public void reposition() {
        super.reposition();
        Position cp = this.line.getPos();
        StringBuilder sb = new StringBuilder();
        if (this.computeHere) {
            Position.Pnt prev = cp.get(0);
            Position.Pnt ctrl1 = null;
            Position.Pnt ctrl2 = null;
            for (int i = 1; i < cp.size(); ++i) {
                if (this.line.getCurving() == 2 || this.line.getCurving() == 3) {
                    ctrl1 = cp.get(i++);
                }
                if (this.line.getCurving() == 3) {
                    ctrl2 = cp.get(i++);
                }
                try {
                    this.computeCoords(sb, prev, cp.get(i), ctrl1, ctrl2);
                }
                catch (IndexOutOfBoundsException ex) {
                    System.out.println("IOOBE " + this.line.getPos() + ": " + i + "/" + this.line.getPos().size());
                    ex.printStackTrace();
                }
                prev = cp.get(i);
            }
        } else {
            boolean first = true;
            for (Position.Pnt p : cp) {
                sb.append((first ? "M" : "L") + p.getAbsX() + "," + p.getAbsY() + " ");
                first = false;
            }
        }
        this.polyEl.setAttributeNS(null, "d", sb.toString() + "");
        this.bgEl.setAttributeNS(null, "d", sb.toString() + "");
        ArrowHead ah = (ArrowHead)this.that().getTweakByType(ArrowHead.class);
        this.polyEl.removeAttributeNS(null, "marker-start");
        this.polyEl.removeAttributeNS(null, "marker-end");
        this.bgEl.removeAttributeNS(null, "marker-start");
        this.bgEl.removeAttributeNS(null, "marker-end");
        if (ah != null) {
            if (ah.atStart) {
                this.polyEl.setAttributeNS(null, "marker-start", "url(#arrowStart)");
            }
            if (ah.atEnd) {
                this.polyEl.setAttributeNS(null, "marker-end", "url(#arrowEnd)");
            }
        }
    }

    @Override
    public void selectMe(boolean b) {
        Color clr;
        if (b) {
            clr = (Color)this.tv.getSetting("selection-colour");
            this.bgEl.setAttributeNS(null, "stroke-opacity", "1.0");
        } else {
            clr = this.getColour();
            this.bgEl.setAttributeNS(null, "stroke-opacity", "0.0");
        }
        this.bgEl.setAttributeNS(null, "stroke", TreeView.colourToHTML(clr));
        super.selectMe(b);
    }

    @Override
    public DrawableObject setThickness(int thickness) {
        if (this.style == null) {
            this.style = new Style();
            this.that().addTweak(this.style);
        }
        this.style.thickness = thickness;
        return this;
    }

    @Override
    public HierarchicalObject that() {
        return this.line;
    }

    @Override
    public String title() {
        return "Line";
    }

    @Override
    public boolean update(Object obj) {
        if (!(obj instanceof Line)) {
            return false;
        }
        if (this.line != (Line)obj) {
            System.out.println("DLignum delta lin");
        }
        super.grabTweaks();
        this.pos = this.line.getPos();
        this.reposition();
        this.polyEl.setAttributeNS(null, "stroke", TreeView.colourToHTML(this.getColour()));
        this.polyEl.setAttributeNS(null, "stroke-width", "" + this.getThickness());
        this.bgEl.setAttributeNS(null, "stroke", TreeView.colourToHTML(this.getColour()));
        this.bgEl.setAttributeNS(null, "stroke-width", "" + this.getThickness() * 2);
        this.selectMe(this.amSelected());
        super.update();
        return true;
    }

    private static float clamp(float x, float lower, float upper) {
        return Math.max(lower, Math.min(upper, x));
    }

    private static Point2D.Float nearestPoint(Rectangle2D.Float rect, Point2D.Float pnt) {
        float t = rect.y;
        float l = rect.x;
        float b = t + rect.height;
        float r = l + rect.width;
        float x = pnt.x;
        float y = pnt.y;
        x = DrawableLine.clamp(x, l, r);
        y = DrawableLine.clamp(y, t, b);
        float dl = Math.abs(x - l);
        float dr = Math.abs(x - r);
        float dt = Math.abs(y - t);
        float db = Math.abs(y - b);
        float m = Math.min(dl, Math.min(dr, Math.min(dt, db)));
        Point2D.Float ret = new Point2D.Float(r, y);
        if (m == dt) {
            ret.setLocation(x, t);
        } else if (m == db) {
            ret.setLocation(x, b);
        } else if (m == dl) {
            ret.setLocation(l, y);
        }
        return ret;
    }

    private static int pointDirection(Rectangle2D.Float rect, Point2D.Float pnt) {
        float t = rect.y;
        float l = rect.x;
        float b = t + rect.height;
        float r = l + rect.width;
        float x = pnt.x;
        float y = pnt.y;
        x = DrawableLine.clamp(x, l, r);
        y = DrawableLine.clamp(y, t, b);
        float dl = Math.abs(x - l);
        float dr = Math.abs(x - r);
        float dt = Math.abs(y - t);
        float db = Math.abs(y - b);
        float m = Math.min(dl, Math.min(dr, Math.min(dt, db)));
        int ret = 8;
        if (m == dt) {
            ret = 1;
        } else if (m == db) {
            ret = 4;
        } else if (m == dl) {
            ret = 2;
        }
        return ret;
    }

    private static Point2D.Float pointToMargin(int dir, float margin) {
        Point2D.Float ret = new Point2D.Float(0.0f, 0.0f);
        if ((dir & 1) > 0) {
            ret.y = -margin;
        } else if ((dir & 4) > 0) {
            ret.y = margin;
        }
        if ((dir & 2) > 0) {
            ret.x = -margin;
        } else if ((dir & 8) > 0) {
            ret.x = margin;
        }
        return ret;
    }
}

