/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.drawables;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Mark;
import nl.rug.syntree.mainview.components.ActionGroup;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.DrawableObject;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;

public class DrawableMark
extends DrawableObject {
    protected transient Element rect;
    protected transient Element rectBg;
    protected transient Element ellips;
    protected transient Element ellipsBg;
    protected Mark mark;

    public DrawableMark(TreeView tv, Mark mark) {
        super(tv);
        this.mark = mark;
    }

    private Color getColour() {
        return super.getColour("tv-line-colour");
    }

    @Override
    public void draw() {
        super.makeGroup();
        super.appendGroup();
        this.update(this.mark);
    }

    @Override
    public ActionGroup getActions() {
        ActionGroup ret = super.getActions();
        ret.add(this.title(), new ActionGroup(this.tv.getControl().getAddPosAction()));
        return ret.add(this.title(), this.tv.getControl().getChangeThicknessActions());
    }

    @Override
    public String getIDPrefix() {
        return "mark";
    }

    @Override
    public void onMouseOut(DOMMouseEvent evt) {
        if (this.rectBg != null) {
            this.rectBg.setAttributeNS(null, "stroke-opacity", this.amSelected() ? "1.0" : "0.0");
        }
        if (this.ellipsBg != null) {
            this.ellipsBg.setAttributeNS(null, "stroke-opacity", this.amSelected() ? "1.0" : "0.0");
        }
    }

    @Override
    public void onMouseOver(DOMMouseEvent evt) {
        if (this.rectBg != null) {
            this.rectBg.setAttributeNS(null, "stroke-opacity", "1.0");
        }
        if (this.ellipsBg != null) {
            this.ellipsBg.setAttributeNS(null, "stroke-opacity", "1.0");
        }
    }

    @Override
    public void reposition() {
        super.reposition();
        this.update(this);
    }

    @Override
    public void selectMe(boolean b) {
        Color clr = b ? (Color)this.tv.getSetting("selection-colour") : this.getColour();
        if (this.rectBg != null) {
            this.rectBg.setAttributeNS(null, "stroke", TreeView.colourToHTML(clr));
        }
        if (this.ellipsBg != null) {
            this.ellipsBg.setAttributeNS(null, "stroke", TreeView.colourToHTML(clr));
        }
        super.selectMe(b);
    }

    @Override
    public HierarchicalObject that() {
        return this.mark;
    }

    private void fixExistence() {
        if (this.mark.rectangle) {
            if (this.rect == null) {
                this.rect = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "rect");
                this.rect.setAttributeNS(null, "fill", "none");
            }
            if (this.rectBg == null) {
                this.rectBg = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "rect");
                this.rectBg.setAttributeNS(null, "fill", "none");
            }
            if (this.ellips != null && this.ellips.getParentNode() != null) {
                this.ellips.getParentNode().removeChild(this.ellips);
            }
            if (this.ellipsBg != null && this.ellipsBg.getParentNode() != null) {
                this.ellipsBg.getParentNode().removeChild(this.ellipsBg);
            }
        } else {
            if (this.ellips == null) {
                this.ellips = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "ellipse");
                this.ellips.setAttributeNS(null, "fill", "none");
            }
            if (this.ellipsBg == null) {
                this.ellipsBg = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "ellipse");
                this.ellipsBg.setAttributeNS(null, "fill", "none");
            }
            if (this.rect != null && this.rect.getParentNode() != null) {
                this.rect.getParentNode().removeChild(this.rect);
            }
            if (this.rectBg != null && this.rectBg.getParentNode() != null) {
                this.rectBg.getParentNode().removeChild(this.rectBg);
            }
        }
    }

    private void fixAppendage() {
        if (this.mark.rectangle) {
            if (this.rectBg.getParentNode() == null) {
                this.appendToGroup(this.rectBg);
            }
            if (this.rect.getParentNode() == null) {
                this.appendToGroup(this.rect);
            }
        } else {
            if (this.ellipsBg.getParentNode() == null) {
                this.appendToGroup(this.ellipsBg);
            }
            if (this.ellips.getParentNode() == null) {
                this.appendToGroup(this.ellips);
            }
        }
    }

    private void doRect(Rectangle2D.Float extent, float minRad) {
        this.rect.setAttributeNS(null, "x", "" + extent.x);
        this.rectBg.setAttributeNS(null, "x", "" + extent.x);
        this.rect.setAttributeNS(null, "y", "" + extent.y);
        this.rectBg.setAttributeNS(null, "y", "" + extent.y);
        float w = extent.width;
        float h = extent.height;
        if (w < minRad) {
            w = minRad;
        }
        if (h < minRad) {
            h = minRad;
        }
        this.rect.setAttributeNS(null, "width", "" + extent.getWidth());
        this.rectBg.setAttributeNS(null, "width", "" + extent.getWidth());
        this.rect.setAttributeNS(null, "height", "" + extent.getHeight());
        this.rectBg.setAttributeNS(null, "height", "" + extent.getHeight());
        this.rect.setAttributeNS(null, "stroke", TreeView.colourToHTML(this.getColour()));
        this.rectBg.setAttributeNS(null, "stroke", TreeView.colourToHTML(this.getColour()));
        this.rect.setAttributeNS(null, "stroke-width", "" + this.getThickness());
        this.rectBg.setAttributeNS(null, "stroke-width", "" + (float)this.getThickness() * 2.0f);
    }

    private void doEllips(Rectangle2D.Float extent, float minRad) {
        this.ellips.setAttributeNS(null, "cx", "" + extent.getCenterX());
        this.ellipsBg.setAttributeNS(null, "cx", "" + extent.getCenterX());
        this.ellips.setAttributeNS(null, "cy", "" + extent.getCenterY());
        this.ellipsBg.setAttributeNS(null, "cy", "" + extent.getCenterY());
        float rx = (float)(extent.getWidth() / 2.0 * Math.sqrt(2.0));
        float ry = (float)(extent.getHeight() / 2.0 * Math.sqrt(2.0));
        if (rx < minRad) {
            rx = minRad;
        }
        if (ry < minRad) {
            ry = minRad;
        }
        this.ellips.setAttributeNS(null, "rx", "" + rx);
        this.ellipsBg.setAttributeNS(null, "rx", "" + rx);
        this.ellips.setAttributeNS(null, "ry", "" + ry);
        this.ellipsBg.setAttributeNS(null, "ry", "" + ry);
        this.ellips.setAttributeNS(null, "stroke", TreeView.colourToHTML(this.getColour()));
        this.ellipsBg.setAttributeNS(null, "stroke", TreeView.colourToHTML(this.getColour()));
        this.ellips.setAttributeNS(null, "stroke-width", "" + this.getThickness());
        this.ellipsBg.setAttributeNS(null, "stroke-width", "" + (float)this.getThickness() * 2.0f);
    }

    @Override
    public boolean update(Object obj) {
        if (obj instanceof DrawableMark) {
            obj = ((DrawableMark)obj).mark;
        } else if (!(obj instanceof Mark)) {
            return false;
        }
        super.grabTweaks();
        System.out.println("Drawing mark with target" + this.pos.first().target());
        float minRad = ((Float)this.tv.getSetting("tv-mark-min-radius")).floatValue();
        Rectangle2D.Float extent = this.pos.extent(this.tv);
        this.fixExistence();
        if (this.mark.rectangle) {
            this.doRect(extent, minRad);
        } else {
            this.doEllips(extent, minRad);
        }
        this.fixAppendage();
        super.update();
        return true;
    }

    @Override
    public String title() {
        return "Mark (" + (this.mark.rectangle ? "rectangle)" : "ellipse)");
    }
}

